/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.relationship.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipKindDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class RelationshipKindRegistry
extends ContributionFragmentRegistry<RelationshipKindDescriptor> {
    private Map<String, Set<RelationshipKind>> registeredKinds = new HashMap<String, Set<RelationshipKind>>();

    public Set<RelationshipKind> getRegisteredKinds() {
        return this.getRegisteredKinds(null);
    }

    public Set<RelationshipKind> getRegisteredKinds(String group) {
        if (group != null) {
            return this.registeredKinds.get(group);
        }
        HashSet<RelationshipKind> allKinds = new HashSet<RelationshipKind>();
        for (Set<RelationshipKind> kinds : this.registeredKinds.values()) {
            allKinds.addAll(kinds);
        }
        return allKinds;
    }

    public Set<RelationshipKind> filterUnregisteredRelationshipKinds(Set<RelationshipKind> kindsToFilter) {
        HashSet<RelationshipKind> filteredKinds = new HashSet<RelationshipKind>();
        for (RelationshipKind kind : kindsToFilter) {
            Set<RelationshipKind> kinds = this.registeredKinds.get(kind.getGroup());
            if (kinds == null || !kinds.contains(kind)) continue;
            filteredKinds.add(kind);
        }
        return filteredKinds;
    }

    public String getContributionId(RelationshipKindDescriptor contrib) {
        return contrib.getId();
    }

    public void contributionUpdated(String id, RelationshipKindDescriptor contrib, RelationshipKindDescriptor newOrigContrib) {
        String group = contrib.getGroup();
        String name = contrib.getName();
        if (contrib.isEnabled()) {
            Set<RelationshipKind> kinds = this.registeredKinds.get(group);
            if (kinds == null) {
                kinds = new HashSet<RelationshipKind>();
                this.registeredKinds.put(group, kinds);
            }
            RelationshipKind kind = RelationshipKind.newInstance(group, name);
            kinds.add(kind);
        } else {
            this.removeRelationshipKind(contrib);
        }
    }

    private void removeRelationshipKind(RelationshipKindDescriptor contrib) {
        Set<RelationshipKind> kinds = this.registeredKinds.get(contrib.getGroup());
        RelationshipKind kind = RelationshipKind.newInstance(contrib.getGroup(), contrib.getName());
        kinds.remove(kind);
    }

    public void contributionRemoved(String id, RelationshipKindDescriptor origContrib) {
        this.removeRelationshipKind(origContrib);
    }

    public RelationshipKindDescriptor clone(RelationshipKindDescriptor orig) {
        return orig.clone();
    }

    public void merge(RelationshipKindDescriptor src, RelationshipKindDescriptor dst) {
        dst.setName(src.getName());
        dst.setGroup(src.getGroup());
        boolean enabled = src.isEnabled();
        if (enabled != dst.isEnabled()) {
            dst.setEnabled(enabled);
        }
    }
}

