/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.activity.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.AbstractActivityPageProvider;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.social.activity.stream.UserActivityStreamFilter;
import org.nuxeo.runtime.api.Framework;

public class UserActivityStreamPageProvider
extends AbstractActivityPageProvider<ActivityMessage> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserActivityStreamPageProvider.class);
    public static final String ACTOR_PROPERTY = "actor";
    public static final String LOCALE_PROPERTY = "locale";
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String STREAM_TYPE_PROPERTY = "streamType";
    public static final String ACTIVITY_LINK_BUILDER_NAME_PROPERTY = "activityLinkBuilderName";
    public static final String FOR_ACTOR_STREAM_TYPE = "forActor";
    public static final String FROM_ACTOR_STREAM_TYPE = "fromActor";
    protected List<ActivityMessage> pageActivityMessages;

    public List<ActivityMessage> getCurrentPage() {
        if (this.pageActivityMessages == null) {
            this.pageActivityMessages = new ArrayList<ActivityMessage>();
            long pageSize = this.getMinMaxPageSize();
            ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
            String streamType = this.getStreamType();
            if (FOR_ACTOR_STREAM_TYPE.equals(streamType)) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put(ACTOR_PROPERTY, this.getActor());
                parameters.put("queryType", (Object)UserActivityStreamFilter.QueryType.ACTIVITY_STREAM_FOR_ACTOR);
                ActivitiesList activities = activityStreamService.query("UserActivityStreamFilter", parameters, this.getCurrentPageOffset(), pageSize);
                this.nextOffset = this.offset + (long)activities.size();
                activities = activities.filterActivities(this.getCoreSession());
                this.pageActivityMessages.addAll(activities.toActivityMessages(this.getLocale(), this.getActivityLinkBuilderName()));
            } else if (FROM_ACTOR_STREAM_TYPE.equals(streamType)) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put(ACTOR_PROPERTY, this.getActor());
                parameters.put("queryType", (Object)UserActivityStreamFilter.QueryType.ACTIVITY_STREAM_FROM_ACTOR);
                ActivitiesList activities = activityStreamService.query("UserActivityStreamFilter", parameters, this.getCurrentPageOffset(), pageSize);
                this.nextOffset = this.offset + (long)activities.size();
                activities = activities.filterActivities(this.getCoreSession());
                this.pageActivityMessages.addAll(activities.toActivityMessages(this.getLocale(), this.getActivityLinkBuilderName()));
            } else {
                log.error((Object)("Unknown stream type: " + streamType));
            }
            this.setResultsCount(-2L);
        }
        return this.pageActivityMessages;
    }

    protected String getActor() {
        Map props = this.getProperties();
        String actor = (String)props.get(ACTOR_PROPERTY);
        if (actor == null) {
            throw new ClientRuntimeException("Cannot find actor property.");
        }
        return actor;
    }

    protected Locale getLocale() {
        Map props = this.getProperties();
        Locale locale = (Locale)props.get(LOCALE_PROPERTY);
        if (locale == null) {
            throw new ClientRuntimeException("Cannot find locale property.");
        }
        return locale;
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession session = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (session == null) {
            throw new ClientRuntimeException("Cannot find coreSession property.");
        }
        return session;
    }

    protected String getStreamType() {
        Map props = this.getProperties();
        String streamType = (String)props.get(STREAM_TYPE_PROPERTY);
        if (streamType == null) {
            streamType = FOR_ACTOR_STREAM_TYPE;
        }
        return streamType;
    }

    protected String getActivityLinkBuilderName() {
        Map props = this.getProperties();
        return (String)props.get(ACTIVITY_LINK_BUILDER_NAME_PROPERTY);
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        this.pageActivityMessages = null;
        super.pageChanged();
    }

    public void refresh() {
        this.pageActivityMessages = null;
        super.refresh();
    }
}

