/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.jaxrs.utils;

import com.phloc.commons.io.streams.StringInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.nuxeo.ecm.core.api.ClientException;

public class SAXModifier {
    private final Document source;
    private final Document target;

    public SAXModifier(String source, String target) throws ClientException {
        try {
            SAXReader reader = new SAXReader();
            this.source = reader.read((InputStream)new StringInputStream(source, Charset.defaultCharset()));
            this.target = reader.read((InputStream)new StringInputStream(target, Charset.defaultCharset()));
            this.syncNamespaces();
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public SAXModifier(Document source, Document target) {
        this.source = source;
        this.target = target;
        this.syncNamespaces();
    }

    public void moveNodes(String xpathExpression) {
        SAXModifier.moveNodes(this.source, this.target, xpathExpression);
    }

    public void moveNode(String xpathExpression) {
        SAXModifier.moveNode(this.source, this.target, xpathExpression, false);
    }

    public void moveNode(String xpathExpression, boolean deleteTargetNode) {
        SAXModifier.moveNode(this.source, this.target, xpathExpression, deleteTargetNode);
    }

    public void moveChildren(String xpathExpression) {
        SAXModifier.moveChildren(this.source, this.target, xpathExpression);
    }

    public String buildTargetAsXml() {
        SAXModifier.cleanNamespaces(this.target);
        return this.target.asXML();
    }

    protected void syncNamespaces() {
        SAXModifier.syncNamespaces(this.source, this.target);
    }

    public static void moveNodes(Document source, Document target, String xpathExpression) {
        List nodes = source.selectNodes(xpathExpression);
        if (nodes.size() > 0) {
            String targetPath = ((Node)nodes.get(0)).getParent().getPath();
            Element targetElement = (Element)target.selectSingleNode(targetPath);
            for (Object obj : nodes) {
                Node contribute = (Node)obj;
                targetElement.add(contribute.detach());
            }
        }
    }

    public static void syncNamespaces(Document source, Document target) {
        for (Object obj : source.getRootElement().additionalNamespaces()) {
            Namespace namespace = (Namespace)obj;
            target.getRootElement().add(namespace);
        }
    }

    public static void moveChildren(Document source, Document target, String xpathExpression) {
        Element sourceElt = (Element)source.selectSingleNode(xpathExpression);
        ((Element)target.selectSingleNode(xpathExpression)).appendContent((Branch)sourceElt);
    }

    public static void moveNode(Document source, Document target, String xpathExpression, boolean deleteTargetNode) {
        Node targetNode;
        Node tNode;
        Node node = source.selectSingleNode(xpathExpression);
        if (deleteTargetNode && (tNode = target.selectSingleNode(xpathExpression)) != null) {
            tNode.detach();
        }
        if ((targetNode = target.selectSingleNode(node.getParent().getPath())).getNodeType() != 1) {
            return;
        }
        ((Element)targetNode).add(node.detach());
    }

    public static void cleanNamespaces(Document source) {
        SAXModifier.cleanNamespaces(source.getRootElement().content());
    }

    protected static void cleanNamespaces(List content) {
        for (Object obj : content) {
            if (!(obj instanceof Element)) continue;
            Element elt = (Element)obj;
            for (Object nso : elt.declaredNamespaces()) {
                Namespace ns = (Namespace)nso;
                elt.remove(ns);
            }
            if (!elt.hasContent()) continue;
            SAXModifier.cleanNamespaces(elt.content());
        }
    }
}

