/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.jaxrs.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;

public class ZipExploder {
    protected ZipFile zip;
    protected Blob scarBlob;
    protected boolean exploded = false;
    protected final List<Map<String, Object>> otherBlobs = new ArrayList<Map<String, Object>>();
    protected static final String RO_FACET = "ORI_READ_ONLY";
    private static final Log log = LogFactory.getLog(ZipExploder.class);

    public ZipExploder(Blob blob) throws IOException {
        try {
            File tmp = File.createTempFile("zip", "entry");
            blob.transferTo(tmp);
            this.zip = new ZipFile(tmp);
        }
        catch (ZipException e) {
            log.info((Object)("Blob is not a correctly unzipped: " + e.getMessage()));
            log.debug((Object)e);
        }
    }

    protected void explode() throws ClientException {
        if (this.zip == null || this.exploded) {
            return;
        }
        try {
            Enumeration<? extends ZipEntry> entries = this.zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextEntry = entries.nextElement();
                String blobName = nextEntry.getName();
                if (blobName.endsWith(".scar")) {
                    this.scarBlob = StreamingBlob.createFromStream((InputStream)this.zip.getInputStream(nextEntry), (String)"application/scenari");
                    this.scarBlob.setFilename(blobName);
                    continue;
                }
                StreamingBlob subFileBlob = StreamingBlob.createFromStream((InputStream)this.zip.getInputStream(nextEntry));
                subFileBlob.setFilename(blobName);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("file", subFileBlob);
                map.put("filename", blobName);
                this.otherBlobs.add(map);
            }
            this.exploded = true;
        }
        catch (IOException e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public Blob findScar() throws ClientException {
        if (this.scarBlob == null) {
            this.explode();
        }
        return this.scarBlob;
    }

    public DocumentModel updateDocumentModel(DocumentModel parentLessDoc, DocumentModel targetDoc) throws ClientException {
        DataModel uid = targetDoc.getDataModel("uid");
        targetDoc.copyContent(parentLessDoc);
        ((DocumentModelImpl)targetDoc).addDataModel(uid);
        if (this.zip == null) {
            return targetDoc;
        }
        this.explode();
        if (this.scarBlob != null) {
            targetDoc.setPropertyValue("dc:title", (Serializable)((Object)ZipExploder.prepareScarFilename(this.scarBlob.getFilename())));
            targetDoc.setPropertyValue("file:content", (Serializable)this.scarBlob);
        }
        targetDoc.setPropertyValue("files:files", (Serializable)this.otherBlobs.toArray());
        targetDoc.addFacet(RO_FACET);
        return targetDoc;
    }

    public DocumentModel createDocumentModel(DocumentModel parentLessDoc, DocumentModel parentDocument) throws ClientException {
        CoreSession session = parentLessDoc.getCoreSession();
        DocumentModel doc = session.createDocumentModel(parentDocument.getPathAsString(), null, parentLessDoc.getType());
        return this.updateDocumentModel(parentLessDoc, doc);
    }

    public static String prepareScarFilename(String filename) {
        return filename.substring(0, filename.length() - 5);
    }
}

