/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.jaxrs.webengine;

import eu.scenari.jaxrs.webengine.ImportScreenObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;

@Path(value="/scenari")
@WebObject(type="ScenariRoot")
public class ScenariRoot
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(ScenariRoot.class);
    protected final HttpHeaders headers;
    protected final Set<String> authorizedOrigins = new HashSet<String>();
    protected CoreSession session;

    public ScenariRoot(@Context HttpServletRequest request, @Context HttpHeaders headers) {
        this.headers = headers;
        this.authorizedOrigins.add("*");
        try {
            this.session = SessionFactory.getSession((HttpServletRequest)request);
        }
        catch (WebApplicationException e) {
            log.debug((Object)"Unable to instantiate CoreSession, in case of open url.");
        }
    }

    @OPTIONS
    public Response handleCorsPreflightOnManifest(@Context HttpHeaders headers) {
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/xml"})
    public Object getRoot() {
        log.info((Object)"Deprecated use /manifest instead.");
        return this.getManifest();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/manifest")
    public Object getManifest() {
        Response.ResponseBuilder builder = Response.ok((Object)this.getView("index"));
        return builder.build();
    }

    public String getZipUploadUrl() {
        return String.format("%s/upload", this.getModuleURL());
    }

    @OPTIONS
    @Path(value="/upload")
    public Response handleCorsPreflightForUpload() {
        return Response.ok().build();
    }

    @POST
    @Path(value="/upload")
    public Object upload(InputStream input) throws URISyntaxException, ClientException, IOException {
        Blob zipBlob = StreamingBlob.createFromStream((InputStream)input).persist();
        if (zipBlob.getLength() < 1L) {
            return Response.noContent().build();
        }
        ZipDocumentImporter importer = new ZipDocumentImporter(this.session, zipBlob);
        importer.runUnrestricted();
        Response.ResponseBuilder builder = Response.created((URI)this.getImportScreenUrl(this.session.getRepositoryName(), importer.documentRef));
        return builder.build();
    }

    protected URI getImportScreenUrl(String repositoryName, DocumentRef ref) throws URISyntaxException {
        return new URI(String.format("%s/importscreen/%s/%s", this.getModuleURL(), repositoryName, ref.toString()));
    }

    public String getModuleURL() {
        return String.format("%s%s", VirtualHostHelper.getServerURL((ServletRequest)this.request), this.getContext().getModulePath().substring(1));
    }

    @OPTIONS
    @Path(value="/importscreen")
    public Response handleCorsPreflightForImportScreen() {
        Response.ResponseBuilder res = Response.ok();
        return res.build();
    }

    @Path(value="/importscreen/{repository}/{idref}")
    public Object importScreen(@PathParam(value="repository") String repository, @PathParam(value="idref") String idRef) throws ClientException {
        return new ImportScreenObject(this.getContext(), repository, idRef);
    }

    public static class ZipDocumentImporter
    extends UnrestrictedSessionRunner {
        protected Blob blob;
        public DocumentRef documentRef;
        protected final Principal principal;

        public ZipDocumentImporter(CoreSession session, Blob zipBlob) {
            super(session);
            this.principal = session.getPrincipal();
            this.blob = zipBlob;
        }

        public void run() throws ClientException {
            DocumentModel zipBlobDoc = this.session.createDocumentModel("File");
            zipBlobDoc.setPropertyValue("file:content", (Serializable)this.blob);
            zipBlobDoc = this.session.createDocument(zipBlobDoc);
            ACP acp = zipBlobDoc.getACP();
            ACL acl = acp.getOrCreateACL();
            acl.add((Object)new ACE(this.principal.getName(), "ReadWrite", true));
            acp.addACL(acl);
            this.documentRef = zipBlobDoc.getRef();
            this.session.setACP(this.documentRef, acp, true);
        }
    }
}

