/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMapper {
    private static final Logger logger = LoggerFactory.getLogger(UserMapper.class);
    protected final String baseUrl;

    public UserMapper(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public GroupResource getGroupResourceFromGroupModel(DocumentModel groupModel) throws Exception {
        logger.debug("getGroupResourceFromGroupModel | {}", (Object)groupModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        GroupResource groupResource = new GroupResource(CoreSchema.GROUP_DESCRIPTOR);
        String groupId = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupIdField());
        String groupLabel = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupLabelField());
        groupResource.setDisplayName(groupLabel);
        groupResource.setId(groupId);
        groupResource.setExternalId(groupId);
        URI location = new URI(this.baseUrl + "/" + groupId);
        Meta meta = new Meta(null, null, location, "1");
        groupResource.setMeta(meta);
        return groupResource;
    }

    public UserResource getUserResourcefromUserModel(DocumentModel userModel) throws Exception {
        logger.debug("getUserResourcefromUserModel | {}", (Object)userModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        UserResource userResource = new UserResource(CoreSchema.USER_DESCRIPTOR);
        String userId = (String)userModel.getProperty(um.getUserSchemaName(), um.getUserIdField());
        userResource.setUserName(userId);
        userResource.setId(userId);
        userResource.setExternalId(userId);
        String fname = (String)userModel.getProperty(um.getUserSchemaName(), "firstName");
        String lname = (String)userModel.getProperty(um.getUserSchemaName(), "lastName");
        String email = (String)userModel.getProperty(um.getUserSchemaName(), "email");
        String company = (String)userModel.getProperty(um.getUserSchemaName(), "company");
        Object displayName = fname + " " + lname;
        displayName = ((String)displayName).trim();
        userResource.setDisplayName((String)displayName);
        ArrayList<Entry> emails = new ArrayList<Entry>();
        if (email != null) {
            emails.add(new Entry((Object)email, "string"));
            userResource.setEmails(emails);
        }
        Name fullName = new Name((String)displayName, lname, "", fname, "", "");
        userResource.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", Name.NAME_RESOLVER, (Object)fullName);
        URI location = new URI(this.baseUrl + "/" + userId);
        Meta meta = new Meta(null, null, location, "1");
        userResource.setMeta(meta);
        List groupIds = um.getPrincipal(userId).getAllGroups();
        ArrayList<Entry> groups = new ArrayList<Entry>();
        for (String groupId : groupIds) {
            groups.add(new Entry((Object)groupId, "string"));
        }
        userResource.setGroups(groups);
        userResource.setActive(Boolean.valueOf(true));
        return userResource;
    }

    public DocumentModel createUserModelFromUserResource(UserResource user) throws ClientException {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel newUser = um.getBareUserModel();
        String userId = user.getId();
        if (userId == null || userId.isEmpty()) {
            userId = user.getUserName();
        }
        logger.debug("createUserModelFromUserResource | {}", (Object)user.getId());
        newUser.setProperty(um.getUserSchemaName(), um.getUserIdField(), (Object)userId);
        this.updateUserModel(newUser, user);
        DocumentModel userModel = (DocumentModel)Framework.doPrivileged(() -> um.createUser(newUser));
        UserManager um2 = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel2 = um2.getUserModel(userModel.getId());
        logger.debug("User {} created with ID {}", (Object)userId, (Object)userModel2.getId());
        return userModel;
    }

    public DocumentModel updateUserModelFromUserResource(String uid, UserResource user) throws ClientException {
        logger.debug("updateUserModelFromUserResource {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel == null) {
            logger.warn("User not found {}", (Object)uid);
            return null;
        }
        this.updateUserModel(userModel, user);
        um.updateUser(userModel);
        return userModel;
    }

    protected void updateUserModel(DocumentModel userModel, UserResource userResouce) throws ClientException {
        String displayName;
        logger.debug("updateUserModel {}", (Object)userModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (userResouce.getEmails() != null && userResouce.getEmails().size() > 0) {
            userModel.setProperty(um.getUserSchemaName(), "email", ((Entry)userResouce.getEmails().iterator().next()).getValue());
        }
        if ((displayName = userResouce.getDisplayName()) != null && !displayName.isEmpty()) {
            int idx = displayName.indexOf(" ");
            if (idx > 0) {
                userModel.setProperty(um.getUserSchemaName(), "firstName", (Object)displayName.substring(0, idx).trim());
                userModel.setProperty(um.getUserSchemaName(), "lastName", (Object)displayName.substring(idx + 1).trim());
            } else {
                userModel.setProperty(um.getUserSchemaName(), "firstName", (Object)displayName);
                userModel.setProperty(um.getUserSchemaName(), "lastName", (Object)"");
            }
        }
    }

    public DocumentModel createGroupModelFromGroupResource(GroupResource group) throws ClientException {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (um.getGroup(group.getId()) == null) {
            DocumentModel newGroup = um.getBareGroupModel();
            String groupId = group.getId();
            if (groupId == null || groupId.isEmpty()) {
                groupId = group.getDisplayName();
            }
            newGroup.setProperty(um.getGroupSchemaName(), um.getGroupIdField(), (Object)groupId);
            this.updateGroupModel(newGroup, group);
            return um.createGroup(newGroup);
        }
        logger.warn("Group already exists {}", (Object)group.getId());
        return this.updateGroupModelFromGroupResource(group.getId(), group);
    }

    public DocumentModel updateGroupModelFromGroupResource(String uid, GroupResource group) throws ClientException {
        logger.debug("updateGroupModelFromGroupResource | {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupModel = um.getGroupModel(uid);
        if (groupModel == null) {
            logger.warn("Group not found {}", (Object)uid);
            return null;
        }
        this.updateGroupModel(groupModel, group);
        um.updateGroup(groupModel);
        return groupModel;
    }

    protected void updateGroupModel(DocumentModel userModel, GroupResource groupResouce) throws ClientException {
        logger.debug("updateGroupModel");
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        String displayName = groupResouce.getDisplayName();
        if (displayName != null && !displayName.isEmpty()) {
            userModel.setProperty(um.getGroupSchemaName(), um.getGroupLabelField(), (Object)displayName);
        }
    }
}

