/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;

public class BulkConfig {
    private final boolean supported;
    private final long maxOperations;
    private final long maxPayloadSize;
    public static final AttributeValueResolver<BulkConfig> BULK_CONFIG_RESOLVER = new AttributeValueResolver<BulkConfig>(){

        @Override
        public BulkConfig toInstance(SCIMAttributeValue value) {
            return new BulkConfig((Boolean)value.getSubAttributeValue("supported", BOOLEAN_RESOLVER), (Long)value.getSubAttributeValue("maxOperations", INTEGER_RESOLVER), (Long)value.getSubAttributeValue("maxPayloadSize", INTEGER_RESOLVER));
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, BulkConfig value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(3);
            AttributeDescriptor supportedDescriptor = attributeDescriptor.getSubAttribute("supported");
            subAttributes.add(SCIMAttribute.create(supportedDescriptor, BOOLEAN_RESOLVER.fromInstance(supportedDescriptor, value.supported)));
            AttributeDescriptor maxOperationsDescriptor = attributeDescriptor.getSubAttribute("maxOperations");
            subAttributes.add(SCIMAttribute.create(maxOperationsDescriptor, INTEGER_RESOLVER.fromInstance(maxOperationsDescriptor, value.maxOperations)));
            AttributeDescriptor maxPayloadSizeDescriptor = attributeDescriptor.getSubAttribute("maxPayloadSize");
            subAttributes.add(SCIMAttribute.create(maxPayloadSizeDescriptor, INTEGER_RESOLVER.fromInstance(maxPayloadSizeDescriptor, value.maxPayloadSize)));
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };

    public BulkConfig(boolean supported, long maxOperations, long maxPayloadSize) {
        this.supported = supported;
        this.maxOperations = maxOperations;
        this.maxPayloadSize = maxPayloadSize;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public long getMaxOperations() {
        return this.maxOperations;
    }

    public long getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkConfig that = (BulkConfig)o;
        if (this.maxOperations != that.maxOperations) {
            return false;
        }
        if (this.maxPayloadSize != that.maxPayloadSize) {
            return false;
        }
        return this.supported == that.supported;
    }

    public int hashCode() {
        int result = this.supported ? 1 : 0;
        result = 31 * result + (int)(this.maxOperations ^ this.maxOperations >>> 32);
        result = 31 * result + (int)(this.maxPayloadSize ^ this.maxPayloadSize >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkConfig");
        sb.append("{supported=").append(this.supported);
        sb.append(", maxOperations=").append(this.maxOperations);
        sb.append(", maxPayloadSize=").append(this.maxPayloadSize);
        sb.append('}');
        return sb.toString();
    }
}

