/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.json;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.QueryRequest;
import com.unboundid.scim.json.JSONException;
import com.unboundid.scim.json.JSONWriter;
import com.unboundid.scim.marshal.StreamMarshaller;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.ListResponse;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.ServerErrorException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonStreamMarshaller
implements StreamMarshaller {
    private final OutputStreamWriter outputStreamWriter;
    private final JSONWriter jsonWriter;

    public JsonStreamMarshaller(OutputStream outputStream) throws SCIMException {
        try {
            this.outputStreamWriter = new OutputStreamWriter(outputStream);
            this.jsonWriter = new JSONWriter(this.outputStreamWriter);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot create JSON marshaller: " + e.getMessage());
        }
    }

    @Override
    public void close() throws SCIMException {
        try {
            this.outputStreamWriter.close();
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot close marshaller: " + e.getMessage());
        }
    }

    @Override
    public void marshal(BaseResource resource) throws SCIMException {
        boolean includeSchemas = !(resource instanceof ResourceDescriptor);
        try {
            this.marshal(resource, includeSchemas);
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write resource: " + e.getMessage());
        }
    }

    private void marshal(BaseResource resource, boolean includeSchemas) throws JSONException {
        this.jsonWriter.object();
        HashSet<String> schemas = new HashSet<String>(resource.getResourceDescriptor().getAttributeSchemas());
        if (includeSchemas) {
            this.jsonWriter.key("schemas");
            this.jsonWriter.array();
            for (String schema : schemas) {
                this.jsonWriter.value(schema);
            }
            this.jsonWriter.endArray();
        }
        for (SCIMAttribute attribute : resource.getScimObject().getAttributes("urn:scim:schemas:core:1.0")) {
            if (attribute.getAttributeDescriptor().isMultiValued()) {
                this.writeMultiValuedAttribute(attribute, this.jsonWriter);
                continue;
            }
            this.writeSingularAttribute(attribute, this.jsonWriter);
        }
        for (String schema : schemas) {
            Collection<SCIMAttribute> attributes;
            if (schema.equalsIgnoreCase("urn:scim:schemas:core:1.0") || (attributes = resource.getScimObject().getAttributes(schema)).isEmpty()) continue;
            this.jsonWriter.key(schema);
            this.jsonWriter.object();
            for (SCIMAttribute attribute : attributes) {
                if (attribute.getAttributeDescriptor().isMultiValued()) {
                    this.writeMultiValuedAttribute(attribute, this.jsonWriter);
                    continue;
                }
                this.writeSingularAttribute(attribute, this.jsonWriter);
            }
            this.jsonWriter.endObject();
        }
        this.jsonWriter.endObject();
    }

    @Override
    public void marshal(Resources<? extends BaseResource> response) throws SCIMException {
        try {
            this.jsonWriter.object();
            this.jsonWriter.key("totalResults");
            this.jsonWriter.value(response.getTotalResults());
            this.jsonWriter.key("itemsPerPage");
            this.jsonWriter.value(response.getItemsPerPage());
            this.jsonWriter.key("startIndex");
            this.jsonWriter.value(response.getStartIndex());
            HashSet<String> schemaURIs = new HashSet<String>();
            for (BaseResource baseResource : response) {
                schemaURIs.addAll(baseResource.getResourceDescriptor().getAttributeSchemas());
            }
            this.jsonWriter.key("schemas");
            this.jsonWriter.array();
            for (String string : schemaURIs) {
                this.jsonWriter.value(string);
            }
            this.jsonWriter.endArray();
            this.jsonWriter.key("Resources");
            this.jsonWriter.array();
            for (BaseResource baseResource : response) {
                this.marshal(baseResource, false);
            }
            this.jsonWriter.endArray();
            this.jsonWriter.endObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write resources response: " + e.getMessage());
        }
    }

    @Override
    public void marshal(ListResponse<? extends BaseResource> response) throws SCIMException {
        try {
            this.jsonWriter.object();
            this.jsonWriter.key("schemas");
            this.jsonWriter.array();
            for (String string : response.getSchemas()) {
                this.jsonWriter.value(string);
            }
            this.jsonWriter.endArray();
            this.jsonWriter.key("totalResults");
            this.jsonWriter.value(response.getTotalResults());
            this.jsonWriter.key("itemsPerPage");
            this.jsonWriter.value(response.getItemsPerPage());
            if (response.getStartIndex() > 0L) {
                this.jsonWriter.key("startIndex");
                this.jsonWriter.value(response.getStartIndex());
            }
            for (String string : response.getSchemas()) {
                Map<String, Object> schemaAttributes = response.getExtensionAttributes(string);
                if (schemaAttributes == null || schemaAttributes.size() <= 0) continue;
                this.jsonWriter.key(string);
                this.jsonWriter.value(schemaAttributes);
            }
            this.jsonWriter.key("Resources");
            this.jsonWriter.array();
            for (BaseResource baseResource : response) {
                this.marshal(baseResource, true);
            }
            this.jsonWriter.endArray();
            this.jsonWriter.endObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write resources response: " + e.getMessage());
        }
    }

    @Override
    public void marshal(QueryRequest request) throws SCIMException {
        try {
            this.jsonWriter.object();
            this.jsonWriter.key("schemas");
            this.jsonWriter.array();
            for (String schema : request.getSchemas()) {
                this.jsonWriter.value(schema);
            }
            this.jsonWriter.endArray();
            if (request.getAttributes() != null) {
                this.jsonWriter.key("attributes");
                this.jsonWriter.array();
                for (String attribute : request.getAttributes()) {
                    this.jsonWriter.value(attribute);
                }
                this.jsonWriter.endArray();
            }
            if (request.getFilter() != null) {
                this.jsonWriter.key("filter");
                this.jsonWriter.value(request.getFilter());
            }
            if (request.getPageParameters() != null) {
                this.jsonWriter.key("count");
                this.jsonWriter.value(request.getPageParameters().getCount());
                this.jsonWriter.key("startIndex");
                this.jsonWriter.value(request.getPageParameters().getStartIndex());
            }
            if (request.getSortParameters() != null) {
                this.jsonWriter.key("sortBy");
                this.jsonWriter.value(request.getSortParameters().getSortBy());
                this.jsonWriter.key("sortOrder");
                this.jsonWriter.value(request.getSortParameters().getSortOrder());
            }
            for (String schema : request.getSchemas()) {
                Map<String, Object> schemaAttributes = request.getExtensionAttributes(schema);
                if (schemaAttributes == null || schemaAttributes.size() <= 0) continue;
                this.jsonWriter.key(schema);
                this.jsonWriter.value(schemaAttributes);
            }
            this.jsonWriter.endObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write streamed query request: " + e.getMessage());
        }
    }

    @Override
    public void marshal(SCIMException response) throws SCIMException {
        try {
            this.jsonWriter.object();
            this.jsonWriter.key("Errors");
            this.jsonWriter.array();
            this.jsonWriter.object();
            this.jsonWriter.key("code");
            this.jsonWriter.value(String.valueOf(response.getStatusCode()));
            String description = response.getMessage();
            if (description != null) {
                this.jsonWriter.key("description");
                this.jsonWriter.value(description);
            }
            this.jsonWriter.endObject();
            this.jsonWriter.endArray();
            this.jsonWriter.endObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write error response: " + e.getMessage());
        }
    }

    @Override
    public void writeBulkStart(int failOnErrors, Set<String> schemaURIs) throws SCIMException {
        try {
            this.jsonWriter.object();
            if (failOnErrors >= 0) {
                this.jsonWriter.key("failOnErrors");
                this.jsonWriter.value(failOnErrors);
            }
            this.jsonWriter.key("schemas");
            this.jsonWriter.array();
            for (String schemaURI : schemaURIs) {
                this.jsonWriter.value(schemaURI);
            }
            this.jsonWriter.endArray();
            this.jsonWriter.key("Operations");
            this.jsonWriter.array();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write start of bulk operations: " + e.getMessage());
        }
    }

    @Override
    public void writeBulkOperation(BulkOperation o) throws SCIMException {
        try {
            this.jsonWriter.object();
            if (o.getMethod() != null) {
                this.jsonWriter.key("method");
                this.jsonWriter.value((Object)o.getMethod());
            }
            if (o.getBulkId() != null) {
                this.jsonWriter.key("bulkId");
                this.jsonWriter.value(o.getBulkId());
            }
            if (o.getVersion() != null) {
                this.jsonWriter.key("version");
                this.jsonWriter.value(o.getVersion());
            }
            if (o.getPath() != null) {
                this.jsonWriter.key("path");
                this.jsonWriter.value(o.getPath());
            }
            if (o.getLocation() != null) {
                this.jsonWriter.key("location");
                this.jsonWriter.value(o.getLocation());
            }
            if (o.getData() != null) {
                this.jsonWriter.key("data");
                this.marshal(o.getData(), true);
            }
            if (o.getStatus() != null) {
                this.jsonWriter.key("status");
                this.jsonWriter.object();
                this.jsonWriter.key("code");
                this.jsonWriter.value(o.getStatus().getCode());
                if (o.getStatus().getDescription() != null) {
                    this.jsonWriter.key("description");
                    this.jsonWriter.value(o.getStatus().getDescription());
                }
                this.jsonWriter.endObject();
            }
            this.jsonWriter.endObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write bulk operation: " + e.getMessage());
        }
    }

    @Override
    public void writeBulkFinish() throws SCIMException {
        try {
            this.jsonWriter.endArray();
            this.jsonWriter.endObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot write end of bulk operations: " + e.getMessage());
        }
    }

    @Override
    public void bulkMarshal(int failOnErrors, List<BulkOperation> operations) throws SCIMException {
        HashSet<String> schemaURIs = new HashSet<String>();
        for (BulkOperation o : operations) {
            BaseResource resource = o.getData();
            if (resource == null) continue;
            schemaURIs.addAll(o.getData().getResourceDescriptor().getAttributeSchemas());
        }
        this.writeBulkStart(failOnErrors, schemaURIs);
        for (BulkOperation o : operations) {
            this.writeBulkOperation(o);
        }
        this.writeBulkFinish();
    }

    private void writeMultiValuedAttribute(SCIMAttribute scimAttribute, JSONWriter jsonWriter) throws JSONException {
        SCIMAttributeValue[] values = scimAttribute.getValues();
        jsonWriter.key(scimAttribute.getName());
        jsonWriter.array();
        for (SCIMAttributeValue value : values) {
            if (value == null) continue;
            if (value.isComplex()) {
                jsonWriter.object();
                for (SCIMAttribute attribute : value.getAttributes().values()) {
                    if (attribute.getAttributeDescriptor().isMultiValued()) {
                        this.writeMultiValuedAttribute(attribute, jsonWriter);
                        continue;
                    }
                    this.writeSingularAttribute(attribute, jsonWriter);
                }
                jsonWriter.endObject();
                continue;
            }
            if (scimAttribute.getAttributeDescriptor().getDataType() != null) {
                switch (scimAttribute.getAttributeDescriptor().getDataType()) {
                    case BOOLEAN: {
                        jsonWriter.value(value.getBooleanValue());
                        break;
                    }
                    case DECIMAL: {
                        jsonWriter.value(value.getDecimalValue());
                        break;
                    }
                    case INTEGER: {
                        jsonWriter.value(value.getIntegerValue());
                        break;
                    }
                    default: {
                        jsonWriter.value(value.getStringValue());
                        break;
                    }
                }
                continue;
            }
            jsonWriter.value(value.getStringValue());
        }
        jsonWriter.endArray();
    }

    private void writeSingularAttribute(SCIMAttribute scimAttribute, JSONWriter jsonWriter) throws JSONException {
        jsonWriter.key(scimAttribute.getName());
        SCIMAttributeValue val = scimAttribute.getValue();
        if (val.isComplex()) {
            jsonWriter.object();
            for (SCIMAttribute a : val.getAttributes().values()) {
                if (a.getAttributeDescriptor().isMultiValued()) {
                    this.writeMultiValuedAttribute(a, jsonWriter);
                    continue;
                }
                this.writeSingularAttribute(a, jsonWriter);
            }
            jsonWriter.endObject();
        } else if (scimAttribute.getAttributeDescriptor().getDataType() != null) {
            switch (scimAttribute.getAttributeDescriptor().getDataType()) {
                case BOOLEAN: {
                    jsonWriter.value(val.getBooleanValue());
                    break;
                }
                case DECIMAL: {
                    jsonWriter.value(val.getDecimalValue());
                    break;
                }
                case INTEGER: {
                    jsonWriter.value(val.getIntegerValue());
                    break;
                }
                default: {
                    jsonWriter.value(val.getStringValue());
                    break;
                }
            }
        } else {
            jsonWriter.value(val.getStringValue());
        }
    }
}

