/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.DatatypeConverter;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.common.http.HttpStatus;

public class HttpBasicAuthSecurityHandler
implements ClientHandler {
    private volatile String encodedCredentials;

    public HttpBasicAuthSecurityHandler(String username, String password) {
        String encoded = null;
        try {
            encoded = DatatypeConverter.printBase64Binary((byte[])(username + ":" + password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.encodedCredentials = "Basic " + encoded;
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        ClientResponse response = context.doChain(request);
        if (response.getStatusCode() == HttpStatus.UNAUTHORIZED.getCode()) {
            InputStream is = (InputStream)response.getEntity(InputStream.class);
            if (is != null) {
                is.close();
            }
            request.getHeaders().putSingle((Object)"Authorization", (Object)this.encodedCredentials);
            return context.doChain(request);
        }
        return response;
    }
}

