/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.PreconditionFailedException;
import com.unboundid.scim.sdk.ResourceNotFoundException;
import com.unboundid.scim.sdk.SCIMException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.EntityTag;

public abstract class SCIMRequest {
    private final URI baseURL;
    private final String authenticatedUserID;
    private final ResourceDescriptor resourceDescriptor;
    private final HttpServletRequest httpServletRequest;
    private final String ifMatchHeaderValue;
    private final String ifNoneMatchHeaderValue;

    public SCIMRequest(URI baseURL, String authenticatedUserID, ResourceDescriptor resourceDescriptor) {
        this.baseURL = baseURL;
        this.authenticatedUserID = authenticatedUserID;
        this.resourceDescriptor = resourceDescriptor;
        this.httpServletRequest = null;
        this.ifMatchHeaderValue = null;
        this.ifNoneMatchHeaderValue = null;
    }

    public SCIMRequest(URI baseURL, String authenticatedUserID, ResourceDescriptor resourceDescriptor, HttpServletRequest httpServletRequest) {
        this.baseURL = baseURL;
        this.authenticatedUserID = authenticatedUserID;
        this.resourceDescriptor = resourceDescriptor;
        this.httpServletRequest = httpServletRequest;
        this.ifMatchHeaderValue = httpServletRequest.getHeader("If-Match");
        this.ifNoneMatchHeaderValue = httpServletRequest.getHeader("If-None-Match");
    }

    public SCIMRequest(URI baseURL, String authenticatedUserID, ResourceDescriptor resourceDescriptor, HttpServletRequest httpServletRequest, String ifMatchHeaderValue, String ifNoneMatchHeaderValue) {
        this.baseURL = baseURL;
        this.authenticatedUserID = authenticatedUserID;
        this.resourceDescriptor = resourceDescriptor;
        this.httpServletRequest = httpServletRequest;
        this.ifMatchHeaderValue = ifMatchHeaderValue;
        this.ifNoneMatchHeaderValue = ifNoneMatchHeaderValue;
    }

    public URI getBaseURL() {
        return this.baseURL;
    }

    public String getAuthenticatedUserID() {
        return this.authenticatedUserID;
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void checkPreconditions(ResourceNotFoundException exception) throws SCIMException {
        if (this.ifMatchHeaderValue != null && this.parseMatchHeader(this.ifMatchHeaderValue).isEmpty()) {
            throw new PreconditionFailedException(exception.getMessage());
        }
    }

    public void checkPreconditions(EntityTag currentVersion) throws SCIMException {
        if (this.ifMatchHeaderValue != null) {
            this.evaluateIfMatch(currentVersion, this.ifMatchHeaderValue);
        } else if (this.ifNoneMatchHeaderValue != null) {
            this.evaluateIfNoneMatch(currentVersion, this.ifNoneMatchHeaderValue);
        }
    }

    protected void evaluateIfMatch(EntityTag eTag, String headerValue) throws SCIMException {
        List<EntityTag> eTags = this.parseMatchHeader(headerValue);
        if (!this.isMatch(eTags, eTag)) {
            throw new PreconditionFailedException("Resource changed since last retrieved", eTag.toString(), null);
        }
    }

    protected void evaluateIfNoneMatch(EntityTag eTag, String headerValue) throws SCIMException {
        List<EntityTag> eTags = this.parseMatchHeader(headerValue);
        if (this.isMatch(eTags, eTag)) {
            throw new PreconditionFailedException("Resource did not change since last retrieved", eTag.toString(), null);
        }
    }

    private boolean isMatch(List<EntityTag> eTags, EntityTag eTag) {
        if (eTag == null) {
            return false;
        }
        if (eTags.isEmpty()) {
            return true;
        }
        String value = eTag.getValue();
        for (EntityTag e : eTags) {
            if (!value.equals(e.getValue())) continue;
            return true;
        }
        return false;
    }

    private List<EntityTag> parseMatchHeader(String headerValue) throws InvalidResourceException {
        ArrayList<EntityTag> versions = null;
        if (headerValue != null) {
            String[] valueTokens = headerValue.split(",");
            versions = new ArrayList<EntityTag>(valueTokens.length);
            for (String token : valueTokens) {
                EntityTag tag;
                try {
                    tag = EntityTag.valueOf((String)token);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidResourceException(e.getMessage(), e);
                }
                if (tag.getValue().equals("*")) {
                    return Collections.emptyList();
                }
                versions.add(tag);
            }
        }
        return versions;
    }
}

