/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.ComplexValue;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMResponse;
import com.unboundid.scim.sdk.SimpleValue;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class BaseResource
implements SCIMResponse {
    public static final ResourceFactory<BaseResource> BASE_RESOURCE_FACTORY = new ResourceFactory<BaseResource>(){

        @Override
        public BaseResource createResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            return new BaseResource(resourceDescriptor, scimObject);
        }
    };
    private final ResourceDescriptor resourceDescriptor;
    private final SCIMObject scimObject;

    public BaseResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
        this.resourceDescriptor = resourceDescriptor;
        this.scimObject = scimObject;
    }

    public BaseResource(ResourceDescriptor resourceDescriptor) {
        this.resourceDescriptor = resourceDescriptor;
        this.scimObject = new SCIMObject();
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public SCIMObject getScimObject() {
        return this.scimObject;
    }

    public String getId() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "id", AttributeValueResolver.STRING_RESOLVER);
    }

    public void setId(String id) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "id", AttributeValueResolver.STRING_RESOLVER, id);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public String getExternalId() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "externalId", AttributeValueResolver.STRING_RESOLVER);
    }

    public void setExternalId(String externalId) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "externalId", AttributeValueResolver.STRING_RESOLVER, externalId);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta getMeta() {
        return this.getSingularAttributeValue("urn:scim:schemas:core:1.0", "meta", Meta.META_RESOLVER);
    }

    public void setMeta(Meta meta) {
        try {
            this.setSingularAttributeValue("urn:scim:schemas:core:1.0", "meta", Meta.META_RESOLVER, meta);
        }
        catch (InvalidResourceException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getSingularAttributeValue(String schema, String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue value;
        SCIMAttribute attribute = this.scimObject.getAttribute(schema, name);
        if (attribute != null && (value = attribute.getValue()) != null) {
            return resolver.toInstance(value);
        }
        return null;
    }

    public <T> void setSingularAttributeValue(String schema, String name, AttributeValueResolver<T> resolver, T value) throws InvalidResourceException {
        if (value == null) {
            this.scimObject.removeAttribute(schema, name);
            return;
        }
        AttributeDescriptor attributeDescriptor = this.getResourceDescriptor().getAttribute(schema, name);
        this.scimObject.setAttribute(SCIMAttribute.create(attributeDescriptor, resolver.fromInstance(attributeDescriptor, value)));
    }

    public <T> Collection<T> getAttributeValues(String schema, String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue[] values;
        SCIMAttribute attribute = this.scimObject.getAttribute(schema, name);
        if (attribute != null && (values = attribute.getValues()) != null) {
            ArrayList<T> entries = new ArrayList<T>(values.length);
            for (SCIMAttributeValue v : values) {
                entries.add(resolver.toInstance(v));
            }
            return entries;
        }
        return null;
    }

    public <T> void setAttributeValues(String schema, String name, AttributeValueResolver<T> resolver, Collection<T> values) throws InvalidResourceException {
        if (values == null) {
            this.scimObject.removeAttribute(schema, name);
            return;
        }
        AttributeDescriptor attributeDescriptor = this.getResourceDescriptor().getAttribute(schema, name);
        SCIMAttributeValue[] entries = new SCIMAttributeValue[values.size()];
        int i = 0;
        for (T value : values) {
            entries[i++] = resolver.fromInstance(attributeDescriptor, value);
        }
        this.scimObject.setAttribute(SCIMAttribute.create(attributeDescriptor, entries));
    }

    public void setSimpleAttribute(String name, SimpleValue value) throws InvalidResourceException {
        this.setSimpleAttribute(this.findDescriptor(name), value);
    }

    public void setSimpleAttribute(String schema, String name, SimpleValue value) throws InvalidResourceException {
        this.setSimpleAttribute(this.getResourceDescriptor().getAttribute(schema, name), value);
    }

    public void setComplexAttribute(String name, ComplexValue attributeValue) throws InvalidResourceException {
        this.setComplexAttribute(this.findDescriptor(name), attributeValue);
    }

    public void setComplexAttribute(String schema, String name, ComplexValue attributeValue) throws InvalidResourceException {
        this.setComplexAttribute(this.getResourceDescriptor().getAttribute(schema, name), attributeValue);
    }

    public void setMultiValuedAttribute(String name, Collection<ComplexValue> values) throws InvalidResourceException {
        this.setMultiValuedAttribute(this.findDescriptor(name), values);
    }

    public void setMultiValuedAttribute(String schema, String name, Collection<ComplexValue> values) throws InvalidResourceException {
        this.setMultiValuedAttribute(this.getResourceDescriptor().getAttribute(schema, name), values);
    }

    public void addOrReplaceMultiValuedValue(String name, ComplexValue attributeValue) throws InvalidResourceException {
        this.addOrReplaceMultiValuedValue(this.findDescriptor(name), attributeValue);
    }

    public void addOrReplaceMultiValuedValue(String schema, String name, ComplexValue attributeValue) throws InvalidResourceException {
        this.addOrReplaceMultiValuedValue(this.getResourceDescriptor().getAttribute(schema, name), attributeValue);
    }

    public SimpleValue getSimpleAttributeValue(String name) throws InvalidResourceException {
        return this.getSimpleAttributeValue(this.findDescriptor(name));
    }

    public SimpleValue getSimpleAttributeValue(String schema, String name) throws InvalidResourceException {
        return this.getSimpleAttributeValue(this.getDescriptor(name, schema));
    }

    public ComplexValue getComplexAttributeValue(String name) throws InvalidResourceException {
        return this.getComplexAttributeValue(this.findDescriptor(name));
    }

    public ComplexValue getComplexAttributeValue(String schema, String name) throws InvalidResourceException {
        return this.getComplexAttributeValue(this.getDescriptor(name, schema));
    }

    public Collection<ComplexValue> getMultiValuedAttribute(String name) throws InvalidResourceException {
        return this.getAttributeValues(this.findDescriptor(name));
    }

    public Collection<ComplexValue> getMultiValuedAttribute(String schema, String name) throws InvalidResourceException {
        return this.getAttributeValues(this.getDescriptor(name, schema));
    }

    @Override
    public void marshal(Marshaller marshaller, OutputStream outputStream) throws Exception {
        marshaller.marshal(this, outputStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseResource)) {
            return false;
        }
        BaseResource that = (BaseResource)o;
        if (!this.resourceDescriptor.equals(that.resourceDescriptor)) {
            return false;
        }
        return this.scimObject.equals(that.scimObject);
    }

    public int hashCode() {
        int result = this.resourceDescriptor.hashCode();
        result = 31 * result + this.scimObject.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BaseResource");
        sb.append("{resource=").append(this.resourceDescriptor.getSchema());
        sb.append(':');
        sb.append(this.resourceDescriptor.getName());
        sb.append(", scimObject=").append(this.scimObject);
        sb.append('}');
        return sb.toString();
    }

    private AttributeDescriptor findDescriptor(String attributeName) throws InvalidResourceException {
        AttributeDescriptor attributeDescriptor = null;
        for (String schema : this.getResourceDescriptor().getAttributeSchemas()) {
            AttributeDescriptor d = this.getResourceDescriptor().findAttribute(schema, attributeName);
            if (d == null) continue;
            if (attributeDescriptor == null) {
                attributeDescriptor = d;
                continue;
            }
            throw new InvalidResourceException(String.format("Ambiguous attribute: %s is defined by more than one schema.", attributeName));
        }
        if (attributeDescriptor == null) {
            throw new InvalidResourceException(String.format("No attribute with name %s defined for this resource", attributeName));
        }
        return attributeDescriptor;
    }

    private SimpleValue getSimpleAttributeValue(AttributeDescriptor descriptor) throws InvalidResourceException {
        SCIMAttributeValue value;
        this.validateNotComplex(descriptor);
        SCIMAttribute attribute = this.scimObject.getAttribute(descriptor.getSchema(), descriptor.getName());
        if (attribute != null && (value = attribute.getValue()) != null) {
            return value.getValue();
        }
        return null;
    }

    private ComplexValue getComplexAttributeValue(AttributeDescriptor descriptor) throws InvalidResourceException {
        this.validateComplex(descriptor);
        this.validateSingular(descriptor);
        return this.getSingularAttributeValue(descriptor.getSchema(), descriptor.getName(), AttributeValueResolver.COMPLEX_RESOLVER);
    }

    private Collection<ComplexValue> getAttributeValues(AttributeDescriptor descriptor) throws InvalidResourceException {
        this.validateMultiValued(descriptor);
        this.validateComplex(descriptor);
        return this.getAttributeValues(descriptor.getSchema(), descriptor.getName(), AttributeValueResolver.COMPLEX_RESOLVER);
    }

    private void setSimpleAttribute(AttributeDescriptor descriptor, SimpleValue value) throws InvalidResourceException {
        this.validateNotComplex(descriptor);
        this.scimObject.setAttribute(SCIMAttribute.create(descriptor, SCIMAttributeValue.createSimpleValue(value)));
    }

    private void setComplexAttribute(AttributeDescriptor descriptor, ComplexValue attributeValue) throws InvalidResourceException {
        this.validateComplex(descriptor);
        this.validateSingular(descriptor);
        this.setSingularAttributeValue(descriptor.getSchema(), descriptor.getName(), AttributeValueResolver.COMPLEX_RESOLVER, attributeValue);
    }

    private void setMultiValuedAttribute(AttributeDescriptor descriptor, Collection<ComplexValue> values) throws InvalidResourceException {
        this.validateMultiValued(descriptor);
        this.validateComplex(descriptor);
        this.setAttributeValues(descriptor.getSchema(), descriptor.getName(), AttributeValueResolver.COMPLEX_RESOLVER, values);
    }

    private void addOrReplaceMultiValuedValue(AttributeDescriptor descriptor, ComplexValue attributeValue) throws InvalidResourceException {
        Collection<ComplexValue> currentValues = this.getAttributeValues(descriptor);
        if (currentValues == null) {
            currentValues = Collections.singleton(attributeValue);
        } else {
            String canonicalType = attributeValue.getStringValue("type");
            if (canonicalType != null) {
                Iterator<ComplexValue> iterator = currentValues.iterator();
                while (iterator.hasNext()) {
                    ComplexValue value = iterator.next();
                    if (!value.containsKey("type") || !value.getStringValue("type").equals(canonicalType)) continue;
                    iterator.remove();
                    break;
                }
            }
            currentValues.add(attributeValue);
        }
        this.setAttributeValues(descriptor.getSchema(), descriptor.getName(), AttributeValueResolver.COMPLEX_RESOLVER, currentValues);
    }

    private AttributeDescriptor getDescriptor(String name, String schema) throws InvalidResourceException {
        AttributeDescriptor descriptor = this.getResourceDescriptor().getAttribute(schema, name);
        if (descriptor == null) {
            throw new InvalidResourceException(String.format("No attribute with name %s defined with schema %s", name, schema));
        }
        return descriptor;
    }

    private void validateComplex(AttributeDescriptor descriptor) throws InvalidResourceException {
        if (!descriptor.getDataType().equals((Object)AttributeDescriptor.DataType.COMPLEX)) {
            throw new InvalidResourceException(String.format("Attribute %s is not defined as complex.", descriptor.getName()));
        }
    }

    private void validateNotComplex(AttributeDescriptor descriptor) throws InvalidResourceException {
        if (descriptor.getDataType().equals((Object)AttributeDescriptor.DataType.COMPLEX)) {
            throw new InvalidResourceException(String.format("Attribute %s is defined as complex.", descriptor.getName()));
        }
    }

    private void validateMultiValued(AttributeDescriptor descriptor) throws InvalidResourceException {
        if (!descriptor.isMultiValued()) {
            throw new InvalidResourceException(String.format("Attribute %s is not defined as multi-valued.", descriptor.getName()));
        }
    }

    private void validateSingular(AttributeDescriptor descriptor) throws InvalidResourceException {
        if (descriptor.isMultiValued()) {
            throw new InvalidResourceException(String.format("Attribute %s is not a singular attribute.", descriptor.getName()));
        }
    }
}

