/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.QueryRequest;
import com.unboundid.scim.sdk.ListResponse;
import com.unboundid.scim.sdk.PageParameters;
import com.unboundid.scim.sdk.SortParameters;
import java.util.List;

public class StreamedQueryRequest
extends QueryRequest {
    public static final String STREAMED_SEARCH_REQUEST_SCHEMA = "urn:unboundId:scim:api:messages:2.0:StreamedSearchRequest";
    public static final String RESUME_TOKEN_ATTRIBUTE = "resumeToken";

    public StreamedQueryRequest(String filter, List<String> attributes, int pageSize) {
        this.getSchemas().add(STREAMED_SEARCH_REQUEST_SCHEMA);
        this.setFilter(filter);
        this.setAttributes(attributes);
        this.setPageSize(pageSize);
    }

    public void setPageSize(int pageSize) {
        super.setPageParameters(new PageParameters(0, pageSize));
    }

    public int getPageSize() {
        return super.getPageParameters().getCount();
    }

    public String getResumeToken() {
        return (String)this.getExtensionAttribute(STREAMED_SEARCH_REQUEST_SCHEMA, RESUME_TOKEN_ATTRIBUTE);
    }

    @Override
    public SortParameters getSortParameters() {
        return null;
    }

    @Override
    public void setSortParameters(SortParameters sortParameters) {
        throw new UnsupportedOperationException("StreamedQuery does not support sorting.");
    }

    @Override
    public void setPageParameters(PageParameters pageParameters) {
        throw new UnsupportedOperationException("Use setPageSize() instead.");
    }

    public boolean hasMoreResults(ListResponse lastResponse) {
        String resumeToken = (String)lastResponse.getExtensionAttribute(STREAMED_SEARCH_REQUEST_SCHEMA, RESUME_TOKEN_ATTRIBUTE);
        this.setExtensionAttribute(STREAMED_SEARCH_REQUEST_SCHEMA, RESUME_TOKEN_ATTRIBUTE, resumeToken);
        return resumeToken != null && !resumeToken.isEmpty();
    }
}

