/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.sdk.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.jaxrs.marshalling.GroupResponse;
import org.nuxeo.scim.server.jaxrs.usermanager.BaseUMEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebObject(type="groups")
@Produces(value={"application/json", "application/xml"})
public class SCIMGroupEndpoint
extends BaseUMEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(SCIMGroupEndpoint.class);

    @Override
    protected String getPrefix() {
        return "/Groups";
    }

    protected GroupResource resolveGroupRessource(String uid) {
        try {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            DocumentModel groupModel = um.getGroupModel(uid);
            if (groupModel != null) {
                return this.mapper.getGroupResourceFromGroupModel(groupModel);
            }
        }
        catch (Exception e) {
            logger.error("Error while resolving User", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public Resources<GroupResource> getGroups(@Context UriInfo uriInfo) {
        String[] filterParts;
        MultivaluedMap params = uriInfo.getQueryParameters();
        HashMap<String, String> filter = new HashMap<String, String>();
        List filters = (List)params.get("filter");
        if (filters != null && filters.size() > 0 && (filterParts = ((String)filters.get(0)).split(" "))[1].equals("eq")) {
            String value;
            String key = filterParts[0];
            if (key.equals("userName")) {
                key = "username";
            }
            if ((value = filterParts[2]).startsWith("\"")) {
                value = value.substring(1, value.length() - 2);
            }
            filter.put(key, value);
        }
        List sortCol = (List)params.get("sortBy");
        List sortType = (List)params.get("sortOrder");
        HashMap<String, String> orderBy = new HashMap<String, String>();
        if (sortCol != null && sortCol.size() > 0) {
            String order = "asc";
            if (sortType != null && sortType.size() > 0) {
                if (((String)sortType.get(0)).equalsIgnoreCase("descending")) {
                    order = "desc";
                }
                orderBy.put((String)sortCol.get(0), order);
            }
        }
        int startIndex = 1;
        if (params.get("startIndex") != null) {
            startIndex = Integer.parseInt((String)((List)params.get("startIndex")).get(0));
        }
        int count = 10;
        if (params.get("count") != null) {
            count = Integer.parseInt((String)((List)params.get("count")).get(0));
        }
        try {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            String directoryName = um.getGroupDirectoryName();
            DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            DocumentModelList groupModels = null;
            try (Session dSession = null;){
                dSession = ds.open(directoryName);
                groupModels = dSession.query(filter, null, orderBy, true, count, startIndex - 1);
            }
            ArrayList<GroupResource> groupResources = new ArrayList<GroupResource>();
            for (DocumentModel groupModel : groupModels) {
                groupResources.add(this.mapper.getGroupResourceFromGroupModel(groupModel));
            }
            return new Resources(groupResources, groupResources.size(), startIndex);
        }
        catch (Exception e) {
            logger.error("Error while getting Groups", (Throwable)e);
            return null;
        }
    }

    @Path(value="{uid}")
    @GET
    @Produces(value={"application/xml", "application/json"})
    public GroupResource getGroupResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.resolveGroupRessource(uid);
    }

    @Path(value="{uid}.xml")
    @GET
    @Produces(value={"application/xml"})
    public GroupResource getGroupResourceAsXml(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getGroupResource(uriInfo, uid);
    }

    @Path(value="{uid}.json")
    @GET
    @Produces(value={"application/json"})
    public GroupResource getUserResourceAsJSON(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getGroupResource(uriInfo, uid);
    }

    @POST
    @Consumes(value={"application/xml", "application/json", "application/scim+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createGroup(@Context UriInfo uriInfo, GroupResource group, @Context HttpServletResponse response) {
        try {
            this.checkUpdateGuardPreconditions();
            return this.doCreateGroup(group, this.fixeMediaType);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)((Object)e));
        }
    }

    @PUT
    @Path(value="{uid}")
    @Consumes(value={"application/xml", "application/json", "application/scim+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateGroup(@Context UriInfo uriInfo, @PathParam(value="uid") String uid, GroupResource user) {
        try {
            this.checkUpdateGuardPreconditions();
            return this.doUpdateGroup(uid, user, this.fixeMediaType);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)((Object)e));
        }
    }

    protected Response doUpdateGroup(String uid, GroupResource group, MediaType mt) {
        try {
            DocumentModel groupModel = this.mapper.updateGroupModelFromGroupResource(uid, group);
            if (groupModel != null) {
                GroupResource groupResource = this.mapper.getGroupResourceFromGroupModel(groupModel);
                return GroupResponse.updated(groupResource, mt);
            }
        }
        catch (Exception e) {
            logger.error("Unable to update Group", (Throwable)e);
        }
        return null;
    }

    protected Response doCreateGroup(GroupResource group, MediaType mt) {
        try {
            DocumentModel newGroup = this.mapper.createGroupModelFromGroupResource(group);
            GroupResource groupResource = this.mapper.getGroupResourceFromGroupModel(newGroup);
            return GroupResponse.created(groupResource, mt);
        }
        catch (Exception e) {
            logger.error("Unable to create Group", (Throwable)e);
            return null;
        }
    }

    @Path(value="{uid}")
    @DELETE
    public Response deleteGroupResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            um.deleteGroup(uid);
            return Response.ok().build();
        }
        catch (DirectoryException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

