/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import javax.servlet.ServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.jaxrs.usermanager.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUMEndpoint
extends DefaultObject {
    private static final Logger logger = LoggerFactory.getLogger(BaseUMEndpoint.class);
    protected UserMapper mapper;
    protected String baseUrl;
    protected MediaType fixeMediaType = null;

    protected abstract String getPrefix();

    protected void initialize(Object ... args) {
        this.baseUrl = VirtualHostHelper.getServerURL((ServletRequest)WebEngine.getActiveContext().getRequest());
        while (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.baseUrl = this.baseUrl + WebEngine.getActiveContext().getUrlPath();
        int idx = this.baseUrl.lastIndexOf(this.getPrefix());
        if (idx > 0) {
            this.baseUrl = this.baseUrl.substring(0, idx + this.getPrefix().length());
        }
        logger.debug("initialize. User base URL {}", (Object)this.baseUrl);
        this.mapper = (UserMapper)Framework.getService(UserMapper.class);
        if (this.mapper != null) {
            logger.debug("SCIM mapper overwrite found - do not use default");
        } else {
            logger.warn("SCIM mapper overwrite not found - use default");
            this.mapper = new UserMapper(this.baseUrl);
        }
        if (args != null && args.length > 0) {
            this.fixeMediaType = (MediaType)args[0];
        }
        if (this.fixeMediaType == null) {
            String accept = WebEngine.getActiveContext().getRequest().getHeader("Accept");
            this.fixeMediaType = accept != null && accept.toLowerCase().contains("application/xml") ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
        }
    }

    protected void checkUpdateGuardPreconditions() throws ClientException {
        NuxeoPrincipal principal = this.getContext().getCoreSession().getPrincipal();
        if (!(principal.isAdministrator() || principal.isMemberOf("powerusers") && this.isAPowerUserEditableArtifact())) {
            throw new WebSecurityException("User is not allowed to edit users");
        }
    }

    protected boolean isAPowerUserEditableArtifact() {
        return false;
    }

    protected static Response returnError(Throwable err) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)err).build();
    }
}

