/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.utils;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    private static final char[] symbols = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final Map<Class, Map<String, Method>> INTERSECT_MAP = new HashMap<Class, Map<String, Method>>();
    private static final char[] symbols2 = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String toString(Object obj) {
        return CommonUtils.toStringWithLevel(obj, 0);
    }

    protected static String toStringWithLevel(Object obj, int level) {
        int newLevel = level + 1;
        if (newLevel > 5) {
            return "";
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof Collection) {
            return "[" + CommonUtils.join((Collection)obj, ";", x -> CommonUtils.toStringWithLevel(x, newLevel)) + "]";
        }
        if (obj.getClass().isArray()) {
            return "[" + CommonUtils.join(Arrays.asList((Object[])obj), ";", x -> CommonUtils.toStringWithLevel(x, newLevel)) + "]";
        }
        if (obj instanceof String || ClassUtils.isPrimitiveOrWrapper(obj.getClass())) {
            return String.valueOf(obj);
        }
        try {
            Map<String, Object> properties = CommonUtils.introspect(obj);
            return "[" + CommonUtils.join(properties.keySet(), ",", x -> x + "=" + CommonUtils.toStringWithLevel(properties.get(x), newLevel)) + "]";
        }
        catch (Throwable e) {
            logger.error("Could not intersect object", e);
            return obj.toString();
        }
    }

    public static Map<String, Object> introspect(Object obj) throws Exception {
        Map<String, Method> readers = CommonUtils.getGetters(obj);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (String property : readers.keySet()) {
            try {
                result.put(property, readers.get(property).invoke(obj, new Object[0]));
            }
            catch (Throwable e) {
                logger.error("Can not figure out value of property [" + property + "], skipping", e);
            }
        }
        return result;
    }

    private static Map<String, Method> getGetters(Object obj) throws Exception {
        Class<?> clazz = obj.getClass();
        Map<String, Method> readers = INTERSECT_MAP.get(clazz);
        LinkedList<String> badFields = new LinkedList<String>();
        badFields.add("class");
        badFields.add("declaringClass");
        badFields.add("field");
        badFields.add("majorVersion");
        badFields.add("versionSeriesCheckedOut");
        badFields.add("checkinComment");
        badFields.add("versionSeriesId");
        if (readers == null) {
            try {
                PropertyDescriptor[] fields = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                readers = Arrays.stream(fields).filter(field -> !badFields.contains(field.getName())).filter(field -> field.getReadMethod() != null && field.getReadMethod().canAccess(obj)).collect(Collectors.toMap(FeatureDescriptor::getName, PropertyDescriptor::getReadMethod));
                INTERSECT_MAP.put(clazz, readers);
            }
            catch (Throwable e) {
                logger.debug("Can not get readers for class " + clazz.getName(), e);
                INTERSECT_MAP.put(clazz, Collections.EMPTY_MAP);
            }
        }
        return readers;
    }

    public static String randomKey(int length) {
        Random random = new Random();
        char[] buf = new char[length];
        for (int idx = 0; idx < length; ++idx) {
            buf[idx] = symbols2[random.nextInt(symbols2.length)];
        }
        return new String(buf);
    }

    public static String randomLargeKey(int length) {
        Random random = new Random();
        char[] buf = new char[length];
        for (int idx = 0; idx < length; ++idx) {
            buf[idx] = symbols[random.nextInt(symbols.length)];
        }
        return new String(buf);
    }

    public static String toString(DocumentModelList list) {
        if (list == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        list.forEach(item -> b.append(item.getName()).append(","));
        return b.toString();
    }

    public static boolean arrayHasValue(String[] values, String v) {
        return Arrays.asList(values).contains(v);
    }

    public static Calendar time() {
        return new GregorianCalendar();
    }

    public static Calendar time(long ms) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(ms);
        return c;
    }

    public static Calendar time(String time) throws ParseException {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sd.setTimeZone(TimeZone.getTimeZone("UTC"));
        return CommonUtils.time(sd.parse(time).getTime());
    }

    public static Calendar currenttime() {
        Date d = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    public static Calendar date() {
        return CommonUtils.date(new GregorianCalendar());
    }

    public static Calendar date(int year, int month, int date) {
        GregorianCalendar now = new GregorianCalendar(year, month, date);
        now.clear(15);
        now.set(10, 0);
        now.set(14, 0);
        now.set(13, 0);
        now.set(12, 0);
        return now;
    }

    public static Calendar date(int year, int month, int date, int hour, int minute, int second) {
        GregorianCalendar now = new GregorianCalendar(year, month, date, hour, minute, second);
        now.clear(15);
        return now;
    }

    public static Calendar date(Calendar i) {
        if (i == null) {
            return null;
        }
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(i.getTime());
        now.clear(15);
        now.set(10, 0);
        now.set(14, 0);
        now.set(13, 0);
        now.set(12, 0);
        return now;
    }

    public static Calendar date(int offsetDays) {
        Calendar now = CommonUtils.date();
        now.add(5, offsetDays);
        return now;
    }

    public static Calendar date(Calendar i, int offsetDays) {
        Calendar now = CommonUtils.date(i);
        now.add(5, offsetDays);
        return now;
    }

    public static Calendar dateMinutes(Calendar i, int offsetMinutes) {
        i.add(12, offsetMinutes);
        return i;
    }

    public static long daysBetween(Calendar startDate, Calendar endDate) {
        long end = endDate.getTimeInMillis();
        long start = startDate.getTimeInMillis();
        return TimeUnit.MILLISECONDS.toDays(end - start);
    }

    public static long minutesBetween(Calendar startDate, Calendar endDate) {
        long end = endDate.getTimeInMillis();
        long start = startDate.getTimeInMillis();
        return TimeUnit.MILLISECONDS.toMinutes(end - start);
    }

    public static String tstr(Calendar c) {
        SimpleDateFormat sd = new SimpleDateFormat("YYYY-MM-dd HH:mm");
        return sd.format(c.getTime());
    }

    public static String isostr(Calendar c) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sd.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sd.format(c.getTime());
    }

    public static String dstr(Calendar c) {
        SimpleDateFormat sd = new SimpleDateFormat("YYYY-MM-dd");
        return sd.format(CommonUtils.date(c).getTime());
    }

    public static String resourceToString(String path) throws Exception {
        InputStream s = CommonUtils.class.getResourceAsStream(path);
        if (s == null) {
            return null;
        }
        return IOUtils.toString((InputStream)s, (String)StandardCharsets.UTF_8.name());
    }

    public static Map<String, String> convertResourceBundleToMap(ResourceBundle resource) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> keys = resource.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, resource.getString(key));
        }
        return map;
    }

    public static String escapeCsv(Object data) {
        String str;
        if (data == null || StringUtils.isEmpty((CharSequence)(str = data.toString()))) {
            return "";
        }
        Object escapedData = str.replaceAll("\\R", " ");
        if (str.contains(",") || str.contains("\"") || str.contains("'")) {
            data = str.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }

    public static String convertToCSV(Object ... data) {
        return Stream.of(data).map(CommonUtils::escapeCsv).collect(Collectors.joining(","));
    }

    public static int random(int high) {
        Random r = new Random();
        int low = 0;
        return r.nextInt(high - low) + low;
    }

    public static Map<String, Object> mapOf(Object ... values) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < values.length / 2 * 2 - 1; i += 2) {
            Object key = values[i];
            Object value = values[i + 1];
            map.put(key.toString(), value);
        }
        return Collections.unmodifiableMap(map);
    }

    public static String checkNull(Object obj, String def) {
        return obj == null ? def : String.valueOf(obj);
    }

    public static <T> String join(Collection<T> collection, String separator, Function<T, String> function) {
        String currentSeparator = CommonUtils.checkNull(separator, "");
        return collection.stream().filter(Objects::nonNull).map(function).collect(Collectors.joining(currentSeparator));
    }

    public static <T> String join(Collection<T> collection, String separator) {
        return CommonUtils.join(collection, separator, Object::toString);
    }

    public static <T> String join(Collection<T> collection) {
        return CommonUtils.join(collection, ",", Object::toString);
    }

    public static LocalDateTime getLocalTimeFromCalendar(Calendar cal) {
        if (cal == null) {
            return LocalDateTime.now();
        }
        TimeZone tz = cal.getTimeZone();
        ZoneId zoneId = tz.toZoneId();
        return LocalDateTime.ofInstant(cal.toInstant(), zoneId);
    }

    public static Calendar getCalendarFromLocalDate(LocalDate localDate) {
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        Instant instant = zonedDateTime.toInstant();
        Date date = Date.from(instant);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

