/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.sdk.Resources;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.jaxrs.marshalling.UserResponse;
import org.nuxeo.scim.server.jaxrs.usermanager.BaseUMEndpoint;
import org.nuxeo.scim.server.jaxrs.usermanager.ReqContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebObject(type="users")
@Produces(value={"application/json", "application/xml"})
public class SCIMUserEndpoint
extends BaseUMEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(SCIMUserEndpoint.class);

    @Override
    protected String getPrefix() {
        return "/Users";
    }

    @GET
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public Resources<UserResource> getUsers(@Context UriInfo uriInfo) {
        logger.debug("getUsers");
        ReqContext context = new ReqContext(uriInfo);
        try {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            String directoryName = um.getUserDirectoryName();
            DocumentModelList userModels = this.query(directoryName, context);
            logger.debug("Users found: {}", (Object)userModels.size());
            ArrayList<UserResource> userResources = new ArrayList<UserResource>(userModels.size());
            for (DocumentModel userModel : userModels) {
                userResources.add(this.mapper.getUserResourceFromUserModel(userModel));
            }
            return new Resources(userResources, userResources.size(), context.startIndex);
        }
        catch (Throwable e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Path(value="{uid}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public UserResource getUserResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            return this.resolveUserResource(uid);
        }
        catch (Exception e) {
            logger.error("Error while getting Users", (Throwable)e);
            throw WebException.wrap((Throwable)e);
        }
    }

    @Path(value="{uid}.xml")
    @GET
    @Produces(value={"application/xml"})
    public UserResource getUserResourceAsXml(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getUserResource(uriInfo, uid);
    }

    @Path(value="{uid}.json")
    @GET
    @Produces(value={"application/json"})
    public UserResource getUserResourceAsJSON(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getUserResource(uriInfo, uid);
    }

    @POST
    @Consumes(value={"application/xml", "application/json", "application/scim+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createUser(UserResource user) {
        logger.debug("Create user {}, fixeMediaType={}", (Object)user, (Object)this.fixeMediaType);
        if (user == null) {
            logger.warn("Input user is not submitted or incorrect format to create user");
            throw new NuxeoException("Input user is not submitted or incorrect format to create user");
        }
        return this.doCreateUserResponse(user, this.fixeMediaType);
    }

    protected Response doCreateUserResponse(UserResource user, MediaType mt) {
        logger.debug("doCreateUserResponse");
        try {
            this.checkUpdateGuardPreconditions();
            return UserResponse.created(this.doCreateUser(user), mt);
        }
        catch (Throwable e) {
            logger.error("Can not create user", e);
            throw WebException.wrap((Throwable)e);
        }
    }

    @PUT
    @Path(value="{uid}")
    @Consumes(value={"application/xml", "application/json", "application/scim+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateUser(@Context UriInfo uriInfo, @PathParam(value="uid") String uid, UserResource user) {
        logger.debug("updateUser {}/{}", (Object)uid, (Object)this.fixeMediaType);
        if (user == null) {
            logger.warn("Input user is not submitted or incorrect format to update user");
            throw new NuxeoException("Input user is not submitted or incorrect format to update user");
        }
        try {
            this.checkUpdateGuardPreconditions();
            return this.doUpdateUser(uid, user, this.fixeMediaType);
        }
        catch (Throwable e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected Response doUpdateUser(String uid, UserResource user, MediaType mt) throws Exception {
        logger.debug("doUpdateUser");
        DocumentModel userModel = this.mapper.updateUserModelFromUserResource(uid, user);
        if (userModel != null) {
            UserResource userResource = this.mapper.getUserResourceFromUserModel(userModel);
            return UserResponse.updated(userResource, mt);
        }
        return Response.status((int)400).entity((Object)("User not found " + uid)).build();
    }

    @Path(value="{uid}")
    @DELETE
    public Response deleteUserResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            um.deleteUser(uid);
            return Response.ok().build();
        }
        catch (DirectoryException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    protected UserResource doCreateUser(UserResource user) throws Exception {
        logger.debug("doCreateUser");
        DocumentModel newUser = this.mapper.createUserModelFromUserResource(user);
        UserResource resource = this.mapper.getUserResourceFromUserModel(newUser);
        return resource;
    }

    protected UserResource resolveUserResource(String uid) throws Exception {
        logger.debug("resolveUserResource {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel != null) {
            logger.debug("User found {} by uid {}", (Object)userModel.getName(), (Object)uid);
            return this.mapper.getUserResourceFromUserModel(userModel);
        }
        logger.warn("User not found by uid {}", (Object)uid);
        return null;
    }
}

