/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk.examples;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.Manager;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.PreemptiveAuthInterceptor;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMService;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.httpclient.ApacheHttpClientConfig;

public class ClientExample {
    public static final ResourceFactory<DeviceResource> DEVICE_RESOURCE_FACTORY = new ResourceFactory<DeviceResource>(){

        @Override
        public DeviceResource createResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            return new DeviceResource(resourceDescriptor, scimObject);
        }
    };

    public static void main(String[] args) throws Exception {
        Manager manager;
        Collection<Entry<String>> phoneNumbers;
        URI uri = URI.create("https://localhost:8443");
        ClientConfig clientConfig = ClientExample.createHttpBasicClientConfig("bjensen", "password");
        SCIMService scimService = new SCIMService(uri, clientConfig);
        scimService.setAcceptType(MediaType.APPLICATION_JSON_TYPE);
        SCIMEndpoint<UserResource> endpoint = scimService.getUserEndpoint();
        Resources<UserResource> resources = endpoint.query("userName eq \"bjensen\"");
        if (resources.getItemsPerPage() == 0) {
            System.out.println("User bjensen not found");
            return;
        }
        UserResource user = resources.iterator().next();
        Name name = user.getName();
        if (name != null) {
            System.out.println(name);
        }
        if ((phoneNumbers = user.getPhoneNumbers()) != null) {
            for (Entry<String> phoneNumber : phoneNumbers) {
                System.out.println(phoneNumber);
            }
        }
        if ((manager = user.getSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "manager", Manager.MANAGER_RESOLVER)) == null) {
            resources = endpoint.query("userName eq \"jsmith\"");
            if (resources.getItemsPerPage() > 0) {
                UserResource boss = resources.iterator().next();
                manager = new Manager(boss.getId(), null);
            } else {
                System.out.println("User jsmith not found");
            }
        }
        user.setSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "manager", Manager.MANAGER_RESOLVER, manager);
        String employeeNumber = user.getSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "employeeNumber", AttributeValueResolver.STRING_RESOLVER);
        if (employeeNumber != null) {
            System.out.println("employeeNumber: " + employeeNumber);
        }
        user.setSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "department", AttributeValueResolver.STRING_RESOLVER, "sales");
        user.setTitle("Vice President");
        endpoint.update(user);
        user = endpoint.get(user.getId());
        ResourceDescriptor deviceDescriptor = scimService.getResourceDescriptor("Device", null);
        SCIMEndpoint<DeviceResource> deviceEndpoint = scimService.getEndpoint(deviceDescriptor, DEVICE_RESOURCE_FACTORY);
    }

    public static ClientConfig createHttpBasicClientConfig(String userName, String password) {
        SSLSocketFactory sslSocketFactory;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new BlindTrustManager()}, new SecureRandom());
            sslSocketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        BasicHttpParams params = new BasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        params.setBooleanParameter("http.socket.reuseaddr", true);
        params.setBooleanParameter("http.protocol.expect-continue", true);
        params.setBooleanParameter("http.connection.stalecheck", true);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory));
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(schemeRegistry);
        mgr.setMaxTotal(200);
        mgr.setDefaultMaxPerRoute(20);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
        ApacheHttpClientConfig clientConfig = new ApacheHttpClientConfig((HttpClient)httpClient);
        clientConfig.setBypassHostnameVerification(true);
        return clientConfig;
    }

    static class BlindTrustManager
    implements X509TrustManager {
        BlindTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    public static class DeviceResource
    extends BaseResource {
        public DeviceResource(ResourceDescriptor resourceDescriptor) {
            super(resourceDescriptor);
        }

        public DeviceResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            super(resourceDescriptor, scimObject);
        }

        public String getVendorName() {
            return this.getSingularAttributeValue("urn:com:example:device:1.0", "vendorName", AttributeValueResolver.STRING_RESOLVER);
        }
    }
}

