/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.BulkException;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.BulkStreamResponse;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.DeleteResourceRequest;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.OAuthTokenHandler;
import com.unboundid.scim.sdk.PatchResourceRequest;
import com.unboundid.scim.sdk.PostResourceRequest;
import com.unboundid.scim.sdk.PreconditionFailedException;
import com.unboundid.scim.sdk.PutResourceRequest;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMQueryAttributes;
import com.unboundid.scim.sdk.ServerErrorException;
import com.unboundid.scim.sdk.Status;
import com.unboundid.scim.sdk.UnauthorizedException;
import com.unboundid.scim.wink.AbstractSCIMResource;
import com.unboundid.scim.wink.RequestContext;
import com.unboundid.scim.wink.ResourceStats;
import com.unboundid.scim.wink.SCIMApplication;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class BulkContentRequestHandler
extends BulkContentHandler {
    private final SCIMApplication application;
    private final RequestContext requestContext;
    private final SCIMBackend backend;
    private final OAuthTokenHandler tokenHandler;
    private final BulkStreamResponse bulkStreamResponse;
    private final Map<String, String> resourceIDs;
    private final Set<String> unresolvedBulkIdRefs;
    private int errorCount = 0;
    private final Set<String> bulkIds;
    private int failOnErrors = Integer.MAX_VALUE;

    public BulkContentRequestHandler(SCIMApplication application, RequestContext requestContext, SCIMBackend backend, BulkStreamResponse bulkStreamResponse, OAuthTokenHandler tokenHandler) {
        this.application = application;
        this.requestContext = requestContext;
        this.backend = backend;
        this.tokenHandler = tokenHandler;
        this.bulkStreamResponse = bulkStreamResponse;
        this.resourceIDs = new HashMap<String, String>();
        this.unresolvedBulkIdRefs = new HashSet<String>();
        this.bulkIds = new HashSet<String>();
    }

    @Override
    public void handleFailOnErrors(int failOnErrors) {
        this.failOnErrors = failOnErrors;
    }

    @Override
    public String transformValue(int opIndex, String value) {
        if (value.startsWith("bulkId:")) {
            String bulkId = value.substring(7);
            String resourceID = this.resourceIDs.get(bulkId);
            if (resourceID != null) {
                return resourceID;
            }
            this.unresolvedBulkIdRefs.add(bulkId);
        }
        return value;
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(String endpoint) {
        return this.backend.getResourceDescriptor(endpoint);
    }

    @Override
    public void handleOperation(int opIndex, BulkOperation bulkOperation) throws BulkException, SCIMException {
        if (this.errorCount < this.failOnErrors) {
            BulkOperation response = this.processOperation(bulkOperation);
            this.unresolvedBulkIdRefs.clear();
            this.bulkStreamResponse.writeBulkOperation(response);
        }
    }

    @Override
    public boolean handleException(int opIndex, BulkException bulkException) throws SCIMException {
        Debug.debugException(bulkException);
        if (this.errorCount < this.failOnErrors) {
            int statusCode = bulkException.getCause().getStatusCode();
            String statusMessage = bulkException.getCause().getMessage();
            Status status = new Status(String.valueOf(statusCode), statusMessage);
            BulkOperation.Method method = bulkException.getMethod();
            String location = null;
            if (method != BulkOperation.Method.POST) {
                UriBuilder locationBuilder = UriBuilder.fromUri((URI)this.requestContext.getUriInfo().getBaseUri());
                if (bulkException.getPath() != null) {
                    locationBuilder.path(bulkException.getPath());
                }
                location = locationBuilder.build(new Object[0]).toString();
            }
            String version = null;
            if (bulkException.getCause() instanceof PreconditionFailedException) {
                version = ((PreconditionFailedException)bulkException.getCause()).getVersion();
            }
            BulkOperation response = BulkOperation.createResponse(method, bulkException.getBulkId(), version, location, status);
            this.bulkStreamResponse.writeBulkOperation(response);
            ++this.errorCount;
            return this.errorCount != this.failOnErrors;
        }
        return false;
    }

    private BulkOperation processOperation(BulkOperation operation) throws BulkException {
        ResourceStats resourceStats;
        ResourceDescriptor descriptor;
        BulkOperation.Method method = operation.getMethod();
        String bulkId = operation.getBulkId();
        String path = operation.getPath();
        String etag = operation.getVersion();
        BaseResource resource = operation.getData();
        int statusCode = 200;
        String location = null;
        String endpoint = null;
        String resourceID = null;
        String responseVersion = null;
        try {
            if (method == null) {
                throw new InvalidResourceException("The bulk operation does not specify a HTTP method");
            }
            try {
                BulkOperation.Method.valueOf(method.name());
            }
            catch (IllegalArgumentException e) {
                throw new BulkException(SCIMException.createException(405, "The bulk operation specifies an invalid HTTP method '" + method + "'. Allowed methods are " + Arrays.asList(BulkOperation.Method.values())), method, bulkId, path);
            }
            if (path == null) {
                throw new InvalidResourceException("The bulk operation does not specify a path");
            }
            if (path != null) {
                int endPos;
                int startPos = 0;
                if (path.charAt(startPos) == '/') {
                    ++startPos;
                }
                if ((endPos = path.indexOf(47, startPos)) == -1) {
                    endPos = path.length();
                }
                endpoint = path.substring(startPos, endPos);
                if (endPos < path.length() - 1) {
                    resourceID = path.substring(endPos + 1);
                }
                if (method == BulkOperation.Method.POST) {
                    if (resourceID != null) {
                        throw new InvalidResourceException("The bulk operation has method POST but the path includesa resource ID");
                    }
                } else {
                    String ref;
                    if (resourceID == null) {
                        throw new InvalidResourceException("The bulk operation does not have a resource ID in the path");
                    }
                    if (resourceID.startsWith("bulkId:") && (resourceID = this.resourceIDs.get(ref = resourceID.substring(7))) == null) {
                        throw SCIMException.createException(409, "Cannot resolve bulkId reference '" + ref + "'");
                    }
                }
            }
            if ((descriptor = this.getResourceDescriptor(endpoint)) == null) {
                throw new InvalidResourceException("The bulk operation specifies an unknown resource endpoint '" + endpoint + "'");
            }
            resourceStats = this.application.getStatsForResource(descriptor.getName());
            if (resourceStats == null) {
                throw new ServerErrorException("Cannot find resource stats for resource '" + descriptor.getName() + "'");
            }
        }
        catch (SCIMException e) {
            throw new BulkException(e, method, bulkId, path);
        }
        UriBuilder locationBuilder = UriBuilder.fromUri((URI)this.requestContext.getUriInfo().getBaseUri());
        locationBuilder.path(path);
        try {
            if (method == BulkOperation.Method.POST && bulkId == null) {
                throw new InvalidResourceException("The bulk operation has method POST but does not specify a bulkId");
            }
            if (bulkId != null && !this.bulkIds.add(bulkId)) {
                throw new InvalidResourceException("The bulk operation defines a duplicate bulkId '" + bulkId + "'");
            }
            if (method != BulkOperation.Method.DELETE && resource == null) {
                throw new InvalidResourceException("The bulk operation does not have any resource data");
            }
            if (!this.unresolvedBulkIdRefs.isEmpty()) {
                throw SCIMException.createException(409, "Cannot resolve bulkId references " + this.unresolvedBulkIdRefs);
            }
            if (this.requestContext.getConsumeMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                switch (method) {
                    case POST: {
                        resourceStats.incrementStat("post-content-json");
                        break;
                    }
                    case PUT: {
                        resourceStats.incrementStat("put-content-json");
                        break;
                    }
                    case PATCH: {
                        resourceStats.incrementStat("patch-content-json");
                    }
                }
            } else {
                switch (method) {
                    case POST: {
                        resourceStats.incrementStat("post-content-xml");
                        break;
                    }
                    case PUT: {
                        resourceStats.incrementStat("put-content-xml");
                        break;
                    }
                    case PATCH: {
                        resourceStats.incrementStat("patch-content-xml");
                    }
                }
            }
            SCIMQueryAttributes queryAttributes = new SCIMQueryAttributes(descriptor, "");
            switch (method) {
                case POST: {
                    PostResourceRequest postResourceRequest = new PostResourceRequest(this.requestContext.getUriInfo().getBaseUri(), this.requestContext.getAuthID(), descriptor, resource.getScimObject(), queryAttributes, this.requestContext.getRequest());
                    if (this.requestContext.getAuthID() == null) {
                        AtomicReference<String> authIDRef = new AtomicReference<String>();
                        Response response = AbstractSCIMResource.validateOAuthToken(this.requestContext, postResourceRequest, authIDRef, this.tokenHandler);
                        if (response != null) {
                            throw new UnauthorizedException("Invalid credentials");
                        }
                        String authID = authIDRef.get();
                        postResourceRequest = new PostResourceRequest(this.requestContext.getUriInfo().getBaseUri(), authID, descriptor, resource.getScimObject(), queryAttributes, this.requestContext.getRequest());
                    }
                    BaseResource postedResource = this.backend.postResource(postResourceRequest);
                    resourceID = postedResource.getId();
                    responseVersion = postedResource.getMeta().getVersion();
                    locationBuilder.path(resourceID);
                    statusCode = 201;
                    resourceStats.incrementStat("post-successful");
                    break;
                }
                case PUT: {
                    PutResourceRequest putResourceRequest = new PutResourceRequest(this.requestContext.getUriInfo().getBaseUri(), this.requestContext.getAuthID(), descriptor, resourceID, resource.getScimObject(), queryAttributes, this.requestContext.getRequest(), etag, null);
                    if (this.requestContext.getAuthID() == null) {
                        AtomicReference<String> authIDRef = new AtomicReference<String>();
                        Response response = AbstractSCIMResource.validateOAuthToken(this.requestContext, putResourceRequest, authIDRef, this.tokenHandler);
                        if (response != null) {
                            throw new UnauthorizedException("Invalid credentials");
                        }
                        String authID = authIDRef.get();
                        putResourceRequest = new PutResourceRequest(this.requestContext.getUriInfo().getBaseUri(), authID, descriptor, resourceID, resource.getScimObject(), queryAttributes, this.requestContext.getRequest(), etag, null);
                    }
                    responseVersion = this.backend.putResource(putResourceRequest).getMeta().getVersion();
                    resourceStats.incrementStat("put-successful");
                    break;
                }
                case PATCH: {
                    PatchResourceRequest patchResourceRequest = new PatchResourceRequest(this.requestContext.getUriInfo().getBaseUri(), this.requestContext.getAuthID(), descriptor, resourceID, resource.getScimObject(), queryAttributes, this.requestContext.getRequest(), etag, null);
                    if (this.requestContext.getAuthID() == null) {
                        AtomicReference<String> authIDRef = new AtomicReference<String>();
                        Response response = AbstractSCIMResource.validateOAuthToken(this.requestContext, patchResourceRequest, authIDRef, this.tokenHandler);
                        if (response != null) {
                            throw new UnauthorizedException("Invalid credentials");
                        }
                        String authID = authIDRef.get();
                        patchResourceRequest = new PatchResourceRequest(this.requestContext.getUriInfo().getBaseUri(), authID, descriptor, resourceID, resource.getScimObject(), queryAttributes, this.requestContext.getRequest(), etag, null);
                    }
                    responseVersion = this.backend.patchResource(patchResourceRequest).getMeta().getVersion();
                    resourceStats.incrementStat("patch-successful");
                    break;
                }
                case DELETE: {
                    DeleteResourceRequest deleteResourceRequest = new DeleteResourceRequest(this.requestContext.getUriInfo().getBaseUri(), this.requestContext.getAuthID(), descriptor, resourceID, this.requestContext.getRequest(), etag, null);
                    if (this.requestContext.getAuthID() == null) {
                        AtomicReference<String> authIDRef = new AtomicReference<String>();
                        Response response = AbstractSCIMResource.validateOAuthToken(this.requestContext, deleteResourceRequest, authIDRef, this.tokenHandler);
                        if (response != null) {
                            throw new UnauthorizedException("Invalid credentials");
                        }
                        String authID = authIDRef.get();
                        deleteResourceRequest = new DeleteResourceRequest(this.requestContext.getUriInfo().getBaseUri(), authID, descriptor, resourceID, this.requestContext.getRequest(), etag, null);
                    }
                    this.backend.deleteResource(deleteResourceRequest);
                    resourceStats.incrementStat("delete-successful");
                }
            }
            if (bulkId != null) {
                this.resourceIDs.put(bulkId, resourceID);
            }
        }
        catch (SCIMException e) {
            switch (method) {
                case POST: {
                    resourceStats.incrementStat("post-" + e.getStatusCode());
                    break;
                }
                case PUT: {
                    resourceStats.incrementStat("put-" + e.getStatusCode());
                    break;
                }
                case PATCH: {
                    resourceStats.incrementStat("patch-" + e.getStatusCode());
                    break;
                }
                case DELETE: {
                    resourceStats.incrementStat("delete-" + e.getStatusCode());
                }
            }
            throw new BulkException(e, method, bulkId, path);
        }
        if (this.requestContext.getProduceMediaType() == MediaType.APPLICATION_JSON_TYPE) {
            switch (method) {
                case POST: {
                    resourceStats.incrementStat("post-response-json");
                    break;
                }
                case PUT: {
                    resourceStats.incrementStat("put-response-json");
                    break;
                }
                case PATCH: {
                    resourceStats.incrementStat("patch-response-json");
                }
            }
        } else if (this.requestContext.getProduceMediaType() == MediaType.APPLICATION_XML_TYPE) {
            switch (method) {
                case POST: {
                    resourceStats.incrementStat("post-response-xml");
                    break;
                }
                case PUT: {
                    resourceStats.incrementStat("put-response-xml");
                    break;
                }
                case PATCH: {
                    resourceStats.incrementStat("patch-response-xml");
                }
            }
        }
        if (method != BulkOperation.Method.POST || statusCode == 201) {
            location = locationBuilder.build(new Object[0]).toString();
        }
        Status status = new Status(String.valueOf(statusCode), null);
        return BulkOperation.createResponse(method, bulkId, responseVersion, location, status);
    }

    private BaseResource resolveBulkIds(BaseResource resource) throws SCIMException {
        SCIMObject src = resource.getScimObject();
        SCIMObject dst = new SCIMObject();
        for (String schema : src.getSchemas()) {
            for (SCIMAttribute a : src.getAttributes(schema)) {
                dst.setAttribute(this.resolveBulkIds(a));
            }
        }
        return new BaseResource(resource.getResourceDescriptor(), dst);
    }

    private SCIMAttribute resolveBulkIds(SCIMAttribute a) throws SCIMException {
        SCIMAttributeValue[] srcValues = a.getValues();
        SCIMAttributeValue[] dstValues = new SCIMAttributeValue[a.getValues().length];
        for (int i = 0; i < srcValues.length; ++i) {
            dstValues[i] = this.resolveBulkIds(srcValues[i]);
        }
        return SCIMAttribute.create(a.getAttributeDescriptor(), dstValues);
    }

    private SCIMAttributeValue resolveBulkIds(SCIMAttributeValue v) throws SCIMException {
        if (v.isComplex()) {
            Collection<SCIMAttribute> srcAttrs = v.getAttributes().values();
            ArrayList<SCIMAttribute> dstAttrs = new ArrayList<SCIMAttribute>(srcAttrs.size());
            for (SCIMAttribute a : srcAttrs) {
                dstAttrs.add(this.resolveBulkIds(a));
            }
            return SCIMAttributeValue.createComplexValue(dstAttrs);
        }
        String s = v.getStringValue();
        if (s.startsWith("bulkId:")) {
            String bulkId = s.substring(7);
            String resourceID = this.resourceIDs.get(bulkId);
            if (resourceID != null) {
                return SCIMAttributeValue.createStringValue(resourceID);
            }
            throw SCIMException.createException(409, "Cannot resolve bulkId reference '" + bulkId + "'");
        }
        return v;
    }
}

