/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.Address;
import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.nuxeo.ecm.ScimNuxeoUserUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMapper {
    private static final Logger log = LoggerFactory.getLogger(UserMapper.class);
    protected final String baseUrl;

    public UserMapper(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public GroupResource getGroupResourceFromGroupModel(DocumentModel groupModel) throws Exception {
        log.debug("getGroupResourceFromGroupModel | {}", (Object)groupModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        GroupResource groupResource = new GroupResource(CoreSchema.GROUP_DESCRIPTOR);
        String groupId = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupIdField());
        String groupLabel = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupLabelField());
        groupResource.setDisplayName(groupLabel);
        groupResource.setId(groupId);
        groupResource.setExternalId(groupId);
        URI location = new URI(this.baseUrl + "/" + groupId);
        Meta meta = new Meta(null, null, location, "1");
        groupResource.setMeta(meta);
        return groupResource;
    }

    public UserResource getUserResourceFromUserModel(DocumentModel userModel) throws Exception {
        log.debug("getUserResourceFromUserModel {}", (Object)userModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        UserResource userResource = new UserResource(CoreSchema.USER_DESCRIPTOR);
        String userId = (String)userModel.getProperty(um.getUserSchemaName(), um.getUserIdField());
        userResource.setUserName(userId);
        userResource.setId(userId);
        userResource.setExternalId(userId);
        String fname = (String)userModel.getProperty(um.getUserSchemaName(), "firstName");
        String lname = (String)userModel.getProperty(um.getUserSchemaName(), "lastName");
        String email = (String)userModel.getProperty(um.getUserSchemaName(), "email");
        String company = (String)userModel.getProperty(um.getUserSchemaName(), "company");
        Object displayName = fname + " " + lname;
        displayName = ((String)displayName).trim();
        userResource.setDisplayName((String)displayName);
        ArrayList<Entry> emails = new ArrayList<Entry>();
        if (email != null) {
            emails.add(new Entry((Object)email, "string"));
            userResource.setEmails(emails);
        }
        Name fullName = new Name((String)displayName, lname, "", fname, "", "");
        userResource.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", Name.NAME_RESOLVER, (Object)fullName);
        URI location = new URI(this.baseUrl + "/" + userId);
        Meta meta = new Meta(null, null, location, "1");
        userResource.setMeta(meta);
        List groupIds = um.getPrincipal(userId).getAllGroups();
        ArrayList<Entry> groups = new ArrayList<Entry>();
        for (String groupId : groupIds) {
            groups.add(new Entry((Object)groupId, "string"));
        }
        userResource.setGroups(groups);
        userResource.setActive(Boolean.valueOf(true));
        return userResource;
    }

    public DocumentModel createUserModelFromUserResource(UserResource user) throws ClientException {
        String userId = user.getId();
        if (userId == null || userId.isEmpty()) {
            userId = user.getUserName();
        }
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel newUser = um.getBareUserModel();
        log.debug("createUserModelFromUserResource | {}", (Object)user.getUserName());
        newUser.setProperty(um.getUserSchemaName(), um.getUserIdField(), (Object)userId);
        this.updateUserModel(newUser, user);
        DocumentModel userModel = (DocumentModel)Framework.doPrivileged(() -> um.createUser(newUser));
        UserManager um2 = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel2 = um2.getUserModel(userModel.getId());
        log.debug("User {} created with ID {}", (Object)userId, (Object)userModel2.getId());
        return userModel;
    }

    public DocumentModel updateUserModelFromUserResource(String uid, UserResource user) throws ClientException {
        log.debug("updateUserModelFromUserResource {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel == null) {
            log.warn("User not found {}", (Object)uid);
            return null;
        }
        this.updateUserModel(userModel, user);
        um.updateUser(userModel);
        if (user.getGroups() != null) {
            Set<String> groups = user.getGroups().stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getValue())).map(Entry::getValue).collect(Collectors.toSet());
            ScimNuxeoUserUtils.addUserToGroups(userModel.getId(), groups);
        }
        return userModel;
    }

    protected void updateUserModel(DocumentModel userModel, UserResource userResource) throws ClientException {
        log.debug("updateUserModel {}", (Object)userResource.getUserName());
        log.debug("user attributes from the request");
        log.debug("-----------------------------------------------------------------------");
        String preferredLanguage = userResource.getPreferredLanguage();
        log.debug("preferredLanguage={}", (Object)preferredLanguage);
        String id = userResource.getId();
        log.debug("id={}", (Object)id);
        String userName = userResource.getUserName();
        log.debug("userName={}", (Object)userName);
        String displayName = userResource.getDisplayName();
        log.debug("displayName={}", (Object)displayName);
        String locale = userResource.getLocale();
        log.debug("locale={}", (Object)locale);
        String nickname = userResource.getNickName();
        log.debug("nickname={}", (Object)nickname);
        String title = userResource.getTitle();
        log.debug("title={}", (Object)title);
        String timezone = userResource.getTimeZone();
        log.debug("timezone={}", (Object)timezone);
        String userType = userResource.getUserType();
        log.debug("userType={}", (Object)userType);
        Name name = userResource.getName();
        log.debug("name={}", (Object)name);
        String profileUrl = userResource.getProfileUrl();
        log.debug("profileUrl={}", (Object)name);
        Collection roles = userResource.getRoles();
        UserMapper.reportArray("roles", roles);
        Collection phoneNumbers = userResource.getPhoneNumbers();
        UserMapper.reportArray("phones", phoneNumbers);
        Collection photos = userResource.getPhotos();
        UserMapper.reportArray("photos", photos);
        Collection emails = userResource.getEmails();
        UserMapper.reportArray("emails", emails);
        Collection groups = userResource.getGroups();
        UserMapper.reportArray("groups", groups);
        Collection addresses = userResource.getAddresses();
        if (addresses != null && !addresses.isEmpty()) {
            log.debug("user addresses");
            log.debug("-----------------------------------------------------------------------");
            for (Address obj : addresses) {
                log.debug("type:{}, street:{}, country:{}, formatted:{},,locality:{}, postal:{}, region:{}", new Object[]{obj.getType(), obj.getStreetAddress(), obj.getCountry(), obj.getFormatted(), obj.getLocality(), obj.getPostalCode(), obj.getRegion()});
            }
        }
        Collection entitlements = userResource.getEntitlements();
        UserMapper.reportArray("entitlements", entitlements);
        Collection ims = userResource.getIms();
        UserMapper.reportArray("ims", ims);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (emails != null && !emails.isEmpty()) {
            userModel.setProperty(um.getUserSchemaName(), "email", ((Entry)userResource.getEmails().iterator().next()).getValue());
        }
        if (displayName != null && !displayName.isEmpty()) {
            int idx = displayName.indexOf(" ");
            if (idx > 0) {
                userModel.setProperty(um.getUserSchemaName(), "firstName", (Object)displayName.substring(0, idx).trim());
                userModel.setProperty(um.getUserSchemaName(), "lastName", (Object)displayName.substring(idx + 1).trim());
            } else {
                userModel.setProperty(um.getUserSchemaName(), "firstName", (Object)displayName);
                userModel.setProperty(um.getUserSchemaName(), "lastName", (Object)"");
            }
        }
    }

    protected static void reportArray(String title, Collection<Entry<String>> objects) {
        if (objects != null && !objects.isEmpty()) {
            log.debug(title);
            log.debug("-----------------------------------------------------------------------");
            for (Entry<String> member : objects) {
                log.debug("value:{}, display:{}, operation:{}, type:{}", new Object[]{member.getValue(), member.getDisplay(), member.getOperation(), member.getType()});
            }
        }
    }

    public DocumentModel createGroupModelFromGroupResource(GroupResource group) throws ClientException {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (um.getGroup(group.getId()) == null) {
            DocumentModel newGroup = um.getBareGroupModel();
            String groupId = group.getId();
            if (groupId == null || groupId.isEmpty()) {
                groupId = group.getDisplayName();
            }
            newGroup.setProperty(um.getGroupSchemaName(), um.getGroupIdField(), (Object)groupId);
            this.updateGroupModel(newGroup, group);
            return um.createGroup(newGroup);
        }
        log.warn("Group already exists {}", (Object)group.getId());
        return this.updateGroupModelFromGroupResource(group.getId(), group);
    }

    public DocumentModel updateGroupModelFromGroupResource(String uid, GroupResource group) throws ClientException {
        log.debug("updateGroupModelFromGroupResource | {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupModel = um.getGroupModel(uid);
        if (groupModel == null) {
            log.warn("Group not found {}", (Object)uid);
            return null;
        }
        this.updateGroupModel(groupModel, group);
        um.updateGroup(groupModel);
        return groupModel;
    }

    protected void updateGroupModel(DocumentModel userModel, GroupResource groupResouce) throws ClientException {
        log.debug("updateGroupModel");
        log.debug("group attributes from the request");
        log.debug("-----------------------------------------------------------------------");
        String displayName = groupResouce.getDisplayName();
        String id = groupResouce.getId();
        log.debug("displayName={}", (Object)displayName);
        log.debug("id={}", (Object)id);
        Collection members = groupResouce.getMembers();
        UserMapper.reportArray("group members", members);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (displayName != null && !displayName.isEmpty()) {
            userModel.setProperty(um.getGroupSchemaName(), um.getGroupLabelField(), (Object)displayName);
        }
    }
}

