/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;
import java.util.Date;

public final class Entry<T> {
    public static final AttributeValueResolver<Entry<String>> STRINGS_RESOLVER = new AttributeValueResolver<Entry<String>>(){

        @Override
        public Entry<String> toInstance(SCIMAttributeValue value) {
            String v = (String)value.getSubAttributeValue("value", STRING_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            String o = (String)value.getSubAttributeValue("operation", STRING_RESOLVER);
            return new Entry<String>(v, t, p == null ? false : p, d, o);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<String> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(5);
            if (value.value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createStringValue((String)value.value)));
            }
            if (value.primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(value.primary)));
            }
            if (value.type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.type)));
            }
            if (value.display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(value.display)));
            }
            if (value.operation != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("operation"), SCIMAttributeValue.createStringValue(value.operation)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    public static final AttributeValueResolver<Entry<Boolean>> BOOLEANS_RESOLVER = new AttributeValueResolver<Entry<Boolean>>(){

        @Override
        public Entry<Boolean> toInstance(SCIMAttributeValue value) {
            Boolean v = (Boolean)value.getSubAttributeValue("value", BOOLEAN_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            String o = (String)value.getSubAttributeValue("operation", STRING_RESOLVER);
            return new Entry<Boolean>(v, t, p == null ? false : p, d, o);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<Boolean> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(5);
            if (value.value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createBooleanValue((Boolean)value.value)));
            }
            if (value.primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(value.primary)));
            }
            if (value.type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.type)));
            }
            if (value.display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(value.display)));
            }
            if (value.operation != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("operation"), SCIMAttributeValue.createStringValue(value.operation)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    public static final AttributeValueResolver<Entry<byte[]>> BINARIES_RESOLVER = new AttributeValueResolver<Entry<byte[]>>(){

        @Override
        public Entry<byte[]> toInstance(SCIMAttributeValue value) {
            byte[] v = (byte[])value.getSubAttributeValue("value", BINARY_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            String o = (String)value.getSubAttributeValue("operation", STRING_RESOLVER);
            return new Entry<byte[]>(v, t, p == null ? false : p, d, o);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<byte[]> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(5);
            if (value.value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createBinaryValue((byte[])value.value)));
            }
            if (value.primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(value.primary)));
            }
            if (value.type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.type)));
            }
            if (value.display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(value.display)));
            }
            if (value.operation != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("operation"), SCIMAttributeValue.createStringValue(value.operation)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    public static final AttributeValueResolver<Entry<Date>> DATES_RESOLVER = new AttributeValueResolver<Entry<Date>>(){

        @Override
        public Entry<Date> toInstance(SCIMAttributeValue value) {
            Date v = (Date)value.getSubAttributeValue("value", DATE_RESOLVER);
            String t = (String)value.getSubAttributeValue("type", STRING_RESOLVER);
            Boolean p = (Boolean)value.getSubAttributeValue("primary", BOOLEAN_RESOLVER);
            String d = (String)value.getSubAttributeValue("display", STRING_RESOLVER);
            String o = (String)value.getSubAttributeValue("operation", STRING_RESOLVER);
            return new Entry<Date>(v, t, p == null ? false : p, d, o);
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, Entry<Date> value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(5);
            if (value.value != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createDateValue((Date)value.value)));
            }
            if (value.primary) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("primary"), SCIMAttributeValue.createBooleanValue(value.primary)));
            }
            if (value.type != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("type"), SCIMAttributeValue.createStringValue(value.type)));
            }
            if (value.display != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("display"), SCIMAttributeValue.createStringValue(value.display)));
            }
            if (value.operation != null) {
                subAttributes.add(SCIMAttribute.create(attributeDescriptor.getSubAttribute("operation"), SCIMAttributeValue.createStringValue(value.operation)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    private T value;
    private boolean primary;
    private String type;
    private String display;
    private String operation;

    public Entry(T value, String type) {
        this(value, type, false, null, null);
    }

    public Entry(T value, String type, boolean primary) {
        this(value, type, primary, null, null);
    }

    public Entry(T value, String type, boolean primary, String display) {
        this(value, type, primary, display, null);
    }

    public Entry(T value, String type, boolean primary, String display, String operation) {
        this.value = value;
        this.type = type;
        this.primary = primary;
        this.display = display;
        this.operation = operation;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entry entry = (Entry)o;
        if (this.primary != entry.primary) {
            return false;
        }
        if (this.type != null ? !this.type.equals(entry.type) : entry.type != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(entry.value) : entry.value != null) {
            return false;
        }
        if (this.display != null ? !this.display.equals(entry.display) : entry.display != null) {
            return false;
        }
        return !(this.operation != null ? !this.operation.equals(entry.operation) : entry.operation != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.primary ? 1 : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Entry{value=" + this.value + ", type='" + this.type + "', primary=" + this.primary + ", display=" + this.display + ", operation=" + this.operation + "}";
    }
}

