/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;

public class FilterConfig {
    private final boolean supported;
    private final long maxResults;
    public static final AttributeValueResolver<FilterConfig> FILTER_CONFIG_RESOLVER = new AttributeValueResolver<FilterConfig>(){

        @Override
        public FilterConfig toInstance(SCIMAttributeValue value) {
            return new FilterConfig((Boolean)value.getSubAttributeValue("supported", BOOLEAN_RESOLVER), (Long)value.getSubAttributeValue("maxResults", INTEGER_RESOLVER));
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor attributeDescriptor, FilterConfig value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(2);
            AttributeDescriptor supportedDescriptor = attributeDescriptor.getSubAttribute("supported");
            subAttributes.add(SCIMAttribute.create(supportedDescriptor, BOOLEAN_RESOLVER.fromInstance(supportedDescriptor, value.supported)));
            AttributeDescriptor maxResultsDescriptor = attributeDescriptor.getSubAttribute("maxResults");
            subAttributes.add(SCIMAttribute.create(maxResultsDescriptor, INTEGER_RESOLVER.fromInstance(maxResultsDescriptor, value.maxResults)));
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };

    public FilterConfig(boolean supported, long maxResults) {
        this.supported = supported;
        this.maxResults = maxResults;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterConfig that = (FilterConfig)o;
        if (this.maxResults != that.maxResults) {
            return false;
        }
        return this.supported == that.supported;
    }

    public int hashCode() {
        int result = this.supported ? 1 : 0;
        result = 31 * result + (int)(this.maxResults ^ this.maxResults >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FilterConfig");
        sb.append("{supported=").append(this.supported);
        sb.append(", maxResults=").append(this.maxResults);
        sb.append('}');
        return sb.toString();
    }
}

