/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ScimNuxeoUserUtils {
    private static final Logger logger = LogManager.getLogger(ScimNuxeoUserUtils.class);
    private static final String docLabelTemplate = "%s %s/\"%s\"";

    public static DocumentModel createUser(String nuxeoLogin) {
        return ScimNuxeoUserUtils.createUser(nuxeoLogin, null);
    }

    public static DocumentModel createUser(String nuxeoLogin, Map<String, Object> propertyMap) {
        DocumentModel userDoc;
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        DocumentModel user = userManager.getBareUserModel();
        user.setPropertyValue(userManager.getUserIdField(), (Serializable)((Object)nuxeoLogin));
        if (propertyMap != null) {
            for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
                user.setPropertyValue(entry.getKey(), (Serializable)entry.getValue());
            }
        }
        try {
            userDoc = (DocumentModel)Framework.doPrivileged(() -> userManager.createUser(user));
        }
        catch (NuxeoException e) {
            logger.error("Error while creating user " + nuxeoLogin + "in UserManager", (Throwable)e);
            return null;
        }
        return userDoc;
    }

    public static DocumentModel createGroup(String name, List<String> users) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupDoc = userManager.getBareGroupModel();
        groupDoc.setPropertyValue("groupname", (Serializable)((Object)name));
        if (users != null) {
            groupDoc.setProperty(userManager.getGroupSchemaName(), userManager.getGroupMembersField(), users);
        }
        return (DocumentModel)Framework.doPrivileged(() -> userManager.createGroup(groupDoc));
    }

    public static void addUserToGroups(String user, Collection<String> groups) {
        logger.debug("add user {} to the following groups {}", (Object)user, groups);
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal userPrincipal = (NuxeoPrincipal)Framework.doPrivileged(() -> userManager.getPrincipal(user));
        if (userPrincipal == null) {
            logger.error("User does not exist {}. Can not add to group", (Object)user);
            return;
        }
        List existing = userPrincipal.getAllGroups();
        for (String group : groups) {
            if (!existing.contains(group)) {
                NuxeoGroup nuxeoGroup = (NuxeoGroup)Framework.doPrivileged(() -> userManager.getGroup(group));
                if (nuxeoGroup != null) {
                    logger.debug("Add user {} to group {}", (Object)user, (Object)group);
                    ScimNuxeoUserUtils.addUserToGroup(nuxeoGroup, user);
                    continue;
                }
                logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)user, (Object)group);
                continue;
            }
            logger.trace("User {} is already part of group {}. Skipping", (Object)user, (Object)group);
        }
    }

    public static void removeUserFromGroups(List<String> groups, String userNameId) {
        if (!groups.isEmpty()) {
            for (String group : groups) {
                ScimNuxeoUserUtils.removeUserFromGroup(group, userNameId);
            }
        }
    }

    public static NuxeoGroup removeUserFromGroup(String group, String userNameId) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoGroup nuxeoGroup = (NuxeoGroup)Framework.doPrivileged(() -> userManager.getGroup(group));
        if (nuxeoGroup != null) {
            ScimNuxeoUserUtils.removeUserFromGroup(nuxeoGroup, userNameId);
        } else {
            logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)userNameId, (Object)group);
        }
        return nuxeoGroup;
    }

    public static void addUserToGroups(String user, String ... groupNames) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        List existing = userManager.getPrincipal(user).getAllGroups();
        for (String group : groupNames) {
            if (existing.contains(group)) continue;
            NuxeoGroup nuxeoGroup = (NuxeoGroup)Framework.doPrivileged(() -> userManager.getGroup(group));
            if (nuxeoGroup != null) {
                ScimNuxeoUserUtils.addUserToGroup(nuxeoGroup, user);
                continue;
            }
            logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)user, (Object)group);
        }
    }

    public static NuxeoGroup addUserToGroup(String group, String ... userNames) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoGroup nuxeoGroup = (NuxeoGroup)Framework.doPrivileged(() -> userManager.getGroup(group));
        if (nuxeoGroup != null) {
            for (String user : userNames) {
                ScimNuxeoUserUtils.addUserToGroup(nuxeoGroup, user);
            }
        } else {
            logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)userNames, (Object)group);
        }
        return nuxeoGroup;
    }

    public static List<String> getGroupMembers(String group) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        return (List)Framework.doPrivileged(() -> userManager.getUsersInGroupAndSubGroups(group));
    }

    public static List<String> getSubGroups(String group) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        return (List)Framework.doPrivileged(() -> userManager.getDescendantGroups(group));
    }

    public static List<String> getParentGroups(String group) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        return (List)Framework.doPrivileged(() -> userManager.getGroup(group).getParentGroups());
    }

    public static List<String> getUserGroups(String user) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        return (List)Framework.doPrivileged(() -> {
            NuxeoPrincipal user1 = userManager.getPrincipal(user);
            if (user1 == null) {
                logger.error("user {} does not exist", (Object)user);
            }
            return user1.getGroups();
        });
    }

    public static void addUserToGroup(NuxeoGroup group, String userNameId) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        List users = (List)Framework.doPrivileged(() -> userManager.getUsersInGroupAndSubGroups(group.getName()));
        if (!users.contains(userNameId)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding user " + userNameId + " to group " + group.getName());
            }
            users.add(userNameId);
            ScimNuxeoUserUtils.updateGroup(group, users);
        } else {
            logger.debug("User " + userNameId + " is already in group " + group.getName());
        }
    }

    public static void removeUserFromGroup(NuxeoGroup group, String userNameId) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        List users = (List)Framework.doPrivileged(() -> userManager.getUsersInGroupAndSubGroups(group.getName()));
        if (users.contains(userNameId)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Removing user " + userNameId + " from group " + group.getName());
            }
            users.remove(userNameId);
            ScimNuxeoUserUtils.updateGroup(group, users);
        } else {
            logger.debug("User " + userNameId + " is not in group " + group.getName());
        }
    }

    public static void updateGroup(NuxeoGroup group, List<String> users) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupDoc = group.getModel();
        groupDoc.setProperty(userManager.getGroupSchemaName(), userManager.getGroupMembersField(), users);
        Framework.doPrivileged(() -> userManager.updateGroup(groupDoc));
    }

    public static void addSubGroups(NuxeoGroup group, List<String> subgroups) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupDoc = group.getModel();
        List existingSubGroups = group.getMemberGroups();
        existingSubGroups.addAll(subgroups);
        groupDoc.setProperty(userManager.getGroupSchemaName(), userManager.getGroupSubGroupsField(), (Object)existingSubGroups);
        Framework.doPrivileged(() -> userManager.updateGroup(groupDoc));
    }

    public static DocumentModel getUserById(String userId) {
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            HashMap<String, String> query = new HashMap<String, String>();
            query.put(userManager.getUserIdField(), userId);
            DocumentModelList users = (DocumentModelList)Framework.doPrivileged(() -> userManager.searchUsers(query, null));
            if (users.isEmpty()) {
                return null;
            }
            return (DocumentModel)users.get(0);
        }
        catch (NuxeoException e) {
            logger.error("Error while search user in UserManager using ID " + userId, (Throwable)e);
            return null;
        }
    }

    public static void raiseException(String errMsg) {
        logger.error(errMsg);
        TransactionHelper.setTransactionRollbackOnly();
        throw new NuxeoException(errMsg);
    }

    public static String getConfigProperty(String name) {
        return Framework.getProperty((String)name);
    }

    public static boolean booleanConfig(String name) {
        String prop = Framework.getProperty((String)name);
        if (prop == null) {
            return false;
        }
        return (prop = prop.trim().toLowerCase()).equals("true") || prop.equals("1") || prop.equals("yes") || prop.equals("da") || prop.equals("oui");
    }

    public static void sendEvent(CoreSession session, String name) {
        EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        EventContextImpl ctx = new EventContextImpl(session, session.getPrincipal());
        Event event = ctx.newEvent(name);
        eventProducer.fireEvent(event);
    }

    public static String docLabel(DocumentModel doc) {
        if (doc == null) {
            return "n/a";
        }
        return String.format(docLabelTemplate, doc.getType(), doc.getId(), doc.getName());
    }
}

