/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqContext {
    private static final Logger logger = LoggerFactory.getLogger(ReqContext.class);
    Map<String, Serializable> filter = new HashMap<String, Serializable>();
    Map<String, String> orderBy = new HashMap<String, String>();
    int count = 9999;
    int startIndex = 1;

    public ReqContext(UriInfo uriInfo) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        this.applyFilters((Map<String, List<String>>)params);
        this.applySort((Map<String, List<String>>)params);
        if (params.get((Object)"startIndex") != null) {
            this.startIndex = Integer.parseInt((String)((List)params.get((Object)"startIndex")).get(0));
        }
        if (params.get((Object)"count") != null) {
            this.count = ReqContext.getCount((Map<String, List<String>>)params);
        }
    }

    private void applyFilters(Map<String, List<String>> params) {
        List<String> filters = params.get("filter");
        if (filters != null && filters.size() > 0) {
            for (String srcFilter : filters) {
                String key;
                String[] filterParts = srcFilter.split(" ");
                if (!filterParts[1].equals("eq")) continue;
                switch (key = filterParts[0].trim()) {
                    case "userName": {
                        key = "username";
                        break;
                    }
                    case "displayName": {
                        key = "groupname";
                    }
                }
                String value = filterParts[2].trim();
                if (value.charAt(0) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                logger.debug("Add query filter {}=>{}", (Object)key, (Object)value);
                this.filter.put(key, (Serializable)((Object)value));
            }
        }
    }

    protected void applySort(Map<String, List<String>> params) {
        List<String> sortCol = params.get("sortBy");
        List<String> sortType = params.get("sortOrder");
        if (sortCol != null && sortCol.size() > 0) {
            String order = "asc";
            if (sortType != null && sortType.size() > 0) {
                if (sortType.get(0).equalsIgnoreCase("descending")) {
                    order = "desc";
                }
                this.orderBy.put(sortCol.get(0), order);
            }
        }
    }

    private static int getCount(Map<String, List<String>> params) {
        return Integer.parseInt(params.get("count").get(0));
    }
}

