/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.Operation;
import com.unboundid.scim.data.PatchResource;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.nuxeo.ecm.ScimNuxeoUserUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMapper {
    private static final Logger log = LoggerFactory.getLogger(UserMapper.class);
    protected final String baseUrl;

    public UserMapper(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public GroupResource getGroupResourceFromGroupModel(DocumentModel groupModel) throws Exception {
        log.debug("getGroupResourceFromGroupModel | {}", (Object)groupModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        GroupResource groupResource = new GroupResource(CoreSchema.GROUP_DESCRIPTOR);
        String groupId = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupIdField());
        String groupLabel = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupLabelField());
        groupResource.setDisplayName(groupLabel);
        groupResource.setId(groupId);
        groupResource.setExternalId(groupId);
        URI location = new URI(this.baseUrl + "/" + groupId);
        Meta meta = new Meta(null, null, location, "1");
        groupResource.setMeta(meta);
        return groupResource;
    }

    public UserResource getUserResourceFromUserModel(DocumentModel userModel) {
        log.debug("getUserResourceFromUserModel {}", (Object)userModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        UserResource userResource = new UserResource(CoreSchema.USER_DESCRIPTOR);
        String userId = (String)userModel.getProperty(um.getUserSchemaName(), um.getUserIdField());
        userResource.setUserName(userId);
        userResource.setId(userId);
        userResource.setExternalId(userId);
        String fname = (String)userModel.getProperty(um.getUserSchemaName(), "firstName");
        String lname = (String)userModel.getProperty(um.getUserSchemaName(), "lastName");
        String email = (String)userModel.getProperty(um.getUserSchemaName(), "email");
        String company = (String)userModel.getProperty(um.getUserSchemaName(), "company");
        String displayName = String.format("%s %s", fname, lname);
        displayName = displayName.trim();
        userResource.setDisplayName(displayName);
        ArrayList<Entry> emails = new ArrayList<Entry>();
        if (email != null) {
            emails.add(new Entry((Object)email, "string"));
            userResource.setEmails(emails);
        }
        Name fullName = new Name(displayName, lname, "", fname, "", "");
        userResource.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", Name.NAME_RESOLVER, (Object)fullName);
        URI location = new URI(this.baseUrl + "/" + userId);
        Meta meta = new Meta(null, null, location, "1");
        userResource.setMeta(meta);
        List groupIds = um.getPrincipal(userId).getAllGroups();
        ArrayList<Entry> groups = new ArrayList<Entry>();
        for (String groupId : groupIds) {
            groups.add(new Entry((Object)groupId, "string"));
        }
        userResource.setGroups(groups);
        userResource.setActive(Boolean.valueOf(true));
        return userResource;
    }

    public DocumentModel createUserModelFromUserResource(UserResource user) throws ClientException {
        String userId = user.getId();
        if (userId == null || userId.isEmpty()) {
            userId = user.getUserName();
        }
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel newUser = um.getBareUserModel();
        log.debug("createUserModelFromUserResource | {}", (Object)user.getUserName());
        newUser.setProperty(um.getUserSchemaName(), um.getUserIdField(), (Object)userId);
        this.updateUserModel(newUser, user);
        DocumentModel userModel = (DocumentModel)Framework.doPrivileged(() -> um.createUser(newUser));
        UserManager um2 = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel2 = um2.getUserModel(userModel.getId());
        log.debug("User {} created with ID {}", (Object)userId, (Object)userModel2.getId());
        return userModel;
    }

    public DocumentModel updateUserModelFromPatchResource(String uid, PatchResource patch) throws ClientException {
        int countOfOperations;
        log.debug("updateUserModelFromPatchResource {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel == null) {
            log.warn("User not found {}", (Object)uid);
            return null;
        }
        int n = countOfOperations = patch.getOperations() != null ? patch.getOperations().size() : 0;
        if (countOfOperations == 0) {
            log.warn("No operations submitted for PATCH request for user {}", (Object)uid);
            return userModel;
        }
        log.debug("");
        log.debug("Perform {} user patch operations", (Object)countOfOperations);
        log.debug("------------------------------------------------------------------");
        for (Operation op : patch.getOperations()) {
            String opType = op.getOp();
            String field = op.getPath();
            String value = op.getValue();
            log.debug("{} {} {}", new Object[]{opType, field, value});
            if ("displayName".equalsIgnoreCase(field)) {
                if ("Replace".equals(opType)) {
                    this.replaceDisplayName(um, userModel, value);
                    continue;
                }
                log.debug("Operation {} is not supported for {}", (Object)opType, (Object)field);
                continue;
            }
            log.warn("Property [{}] is not supported for PATCH ", (Object)field);
        }
        um.updateUser(userModel);
        return userModel;
    }

    public DocumentModel updateUserModelFromUserResource(String uid, UserResource user) throws ClientException {
        log.debug("updateUserModelFromUserResource {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel == null) {
            log.warn("User not found {}", (Object)uid);
            return null;
        }
        this.updateUserModel(userModel, user);
        um.updateUser(userModel);
        if (user.getGroups() != null) {
            Set<String> groups = user.getGroups().stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getValue())).map(Entry::getValue).collect(Collectors.toSet());
            ScimNuxeoUserUtils.addUserToGroups(userModel.getId(), groups);
        }
        return userModel;
    }

    protected void updateUserModel(DocumentModel userModel, UserResource userResource) throws ClientException {
        log.debug("updateUserModel {}", (Object)userResource.getUserName());
        CommonUtils.logUserResource(userResource);
        String displayName = userResource.getDisplayName();
        Collection emails = userResource.getEmails();
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (emails != null && !emails.isEmpty()) {
            userModel.setProperty(um.getUserSchemaName(), "email", ((Entry)userResource.getEmails().iterator().next()).getValue());
        }
        this.replaceDisplayName(um, userModel, displayName);
    }

    private void replaceDisplayName(UserManager um, DocumentModel userModel, String displayName) {
        if (displayName != null && !displayName.isEmpty()) {
            int idxSpace = displayName.indexOf(" ");
            int idxComma = displayName.indexOf(",");
            if (idxComma > 0) {
                userModel.setProperty(um.getUserSchemaName(), "lastName", (Object)displayName.substring(0, idxComma).trim());
                userModel.setProperty(um.getUserSchemaName(), "firstName", (Object)displayName.substring(idxComma + 1).trim());
            } else if (idxSpace > 0) {
                userModel.setProperty(um.getUserSchemaName(), "firstName", (Object)displayName.substring(0, idxSpace).trim());
                userModel.setProperty(um.getUserSchemaName(), "lastName", (Object)displayName.substring(idxSpace + 1).trim());
            } else {
                userModel.setProperty(um.getUserSchemaName(), "firstName", (Object)displayName);
                userModel.setProperty(um.getUserSchemaName(), "lastName", (Object)"");
            }
        }
    }

    public DocumentModel createGroupModelFromGroupResource(GroupResource group) throws ClientException {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (um.getGroup(group.getId()) == null) {
            DocumentModel newGroup = um.getBareGroupModel();
            String groupId = group.getId();
            if (groupId == null || groupId.isEmpty()) {
                groupId = group.getDisplayName();
            }
            newGroup.setProperty(um.getGroupSchemaName(), um.getGroupIdField(), (Object)groupId);
            this.updateGroupModel(newGroup, group);
            return um.createGroup(newGroup);
        }
        log.warn("Group already exists {}", (Object)group.getId());
        return this.updateGroupModelFromGroupResource(group.getId(), group);
    }

    public DocumentModel updateGroupModelFromGroupResource(String uid, GroupResource group) throws ClientException {
        log.debug("updateGroupModelFromGroupResource | {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupModel = um.getGroupModel(uid);
        if (groupModel == null) {
            log.warn("Group not found {}", (Object)uid);
            return null;
        }
        this.updateGroupModel(groupModel, group);
        um.updateGroup(groupModel);
        return groupModel;
    }

    protected void updateGroupModel(DocumentModel userModel, GroupResource groupResource) throws ClientException {
        log.debug("updateGroupModel");
        CommonUtils.logGroupResource(groupResource);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        String displayName = groupResource.getDisplayName();
        String id = groupResource.getId();
        String externalId = groupResource.getExternalId();
        if (displayName != null && !displayName.isEmpty()) {
            userModel.setProperty(um.getGroupSchemaName(), um.getGroupLabelField(), (Object)displayName);
        }
    }
}

