/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.uritemplate;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.common.internal.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitWorkingUriTemplateProcessor
extends UriTemplateProcessor {
    private static final String HEX = "[0-9A-Fa-f]";
    private static final String RESERVED = "[;/?:@&=+$,]";
    private static final String UNRESERVED = "[\\w\\.!~*'()-]";
    private static final String PCT_ENCONDED = "(?:%[0-9A-Fa-f][0-9A-Fa-f])";
    private static final String ALPHA = "[a-zA-Z]";
    private static final String BITWORKING_OP = "([a-zA-Z]+)";
    private static final String BITWORKING_ARG = "((?:[;/?:@&=+$,]|[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*)";
    private static final String BITWORKING_VARNAME = "\\w[\\w\\.-]*";
    private static final String BITWORKING_VARDEFAULT = "((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*)";
    private static final String BITWORKING_VAR = "(\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?";
    private static final String BITWORKING_VARS = "((\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?(?:,(\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?)*)";
    private static final String BITWORKING_OPERATOR = "(?:-([a-zA-Z]+)[|]((?:[;/?:@&=+$,]|[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*)[|]((\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?(?:,(\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?)*))";
    private static final String BITWORKING_EXPANSION = "\\{(?:(\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?|(?:-([a-zA-Z]+)[|]((?:[;/?:@&=+$,]|[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*)[|]((\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?(?:,(\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?)*)))\\}";
    private static final Pattern BITWORKING_VARIABLE_PATTERN = Pattern.compile("\\{(?:(\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?|(?:-([a-zA-Z]+)[|]((?:[;/?:@&=+$,]|[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*)[|]((\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?(?:,(\\w[\\w\\.-]*)(?:=((?:[\\w\\.!~*'()-]|(?:%[0-9A-Fa-f][0-9A-Fa-f]))*))?)*)))\\}");

    public BitWorkingUriTemplateProcessor() {
    }

    public BitWorkingUriTemplateProcessor(String template) {
        this();
        this.compile(template);
    }

    @Override
    public final void compile(String uriTemplate) {
        BitWorkingUriTemplateProcessor.compile(uriTemplate, new BitWorkingPatternBuilder(this));
    }

    public static void compile(String template, BitWorkingCompilationHandler handler) {
        if (template == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "template"));
        }
        if (handler == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "handler"));
        }
        int start = 0;
        String literal = "";
        handler.startCompile(template);
        Matcher matcher = BITWORKING_VARIABLE_PATTERN.matcher(template);
        while (matcher.find()) {
            literal = template.substring(start, matcher.start());
            start = matcher.end();
            handler.literal(literal);
            String variable = matcher.group(1);
            if (variable != null) {
                String defaultValue = matcher.group(2);
                handler.variable(variable, defaultValue);
                continue;
            }
            String operator = matcher.group(3);
            String arg = matcher.group(4);
            String vars = matcher.group(5);
            String[] arrayVars = StringUtils.fastSplit(vars, ",");
            LinkedHashMap<String, String> varsMap = new LinkedHashMap<String, String>();
            for (String var : arrayVars) {
                String defaultValue = null;
                int index = var.indexOf(61);
                if (index != -1) {
                    defaultValue = var.substring(index + 1);
                    var = var.substring(0, index);
                }
                varsMap.put(var, defaultValue);
            }
            handler.operator(operator, arg, varsMap);
        }
        literal = template.substring(start);
        handler.endCompile(literal);
    }

    public static String expand(String template, MultivaluedMap<String, String> values) {
        if (template == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        BitWorkingUriTemplateProcessor.expand(template, values, result);
        return result.toString();
    }

    public static void expand(String template, MultivaluedMap<String, String> values, StringBuilder out) {
        if (template == null) {
            return;
        }
        BitWorkingTemplateExpander expander = new BitWorkingTemplateExpander(values, out);
        BitWorkingUriTemplateProcessor.compile(template, expander);
    }

    public static UriTemplateProcessor newNormalizedInstance(String uriTemplate) {
        return new BitWorkingUriTemplateProcessor(UriTemplateProcessor.normalizeUri(uriTemplate));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BitWorkingTemplateExpander
    extends UriTemplateProcessor.AbstractTemplateExpander
    implements BitWorkingCompilationHandler {
        public BitWorkingTemplateExpander(MultivaluedMap<String, String> values, StringBuilder out) {
            super(values, out);
        }

        @Override
        public void variable(String name, String defaultValue) {
            if (this.values == null) {
                throw new NullPointerException(Messages.getMessage("variableIsNull", name));
            }
            UriTemplateProcessor.Variable expander = new UriTemplateProcessor.Variable(name, null, defaultValue);
            expander.expand((MultivaluedMap<String, String>)this.values, false, this.out);
        }

        @Override
        public void operator(String name, String arg, Map<String, String> vars) {
            if (this.values == null) {
                throw new NullPointerException(Messages.getMessage("variableIsNull", name));
            }
            BitWorkingOperator expander = BitWorkingOperator.forName(name);
            if (expander == null) {
                throw new IllegalArgumentException(Messages.getMessage("unsupportedOperator", name));
            }
            expander.expand((MultivaluedMap<String, String>)this.values, false, this.out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BitWorkingOperator
    extends UriTemplateProcessor.CapturingGroup {
        protected String name;
        protected String arg;
        protected Map<String, String> vars;

        protected BitWorkingOperator(String name) {
            this.name = name;
            this.arg = null;
            this.vars = null;
        }

        public String getName() {
            return this.name;
        }

        public String getArg() {
            return this.arg;
        }

        public void setArg(String arg) {
            this.arg = arg;
        }

        public Map<String, String> getVars() {
            return this.vars;
        }

        public void setVars(Map<String, String> vars) {
            this.vars = vars;
        }

        public static BitWorkingOperator forName(String name) {
            if (name == null) {
                return null;
            }
            if (name.equals("neg")) {
                return new Neg();
            }
            if (name.equals("opt")) {
                return new Opt();
            }
            if (name.equals("prefix")) {
                return new Prefix();
            }
            if (name.equals("suffix")) {
                return new Suffix();
            }
            if (name.equals("list")) {
                return new List();
            }
            if (name.equals("join")) {
                return new Join();
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Join
        extends BitWorkingOperator {
            public Join() {
                super("join");
            }

            @Override
            public void build(StringBuilder builder) {
                String orSign = "";
                StringBuilder keysAndValuesPattern = new StringBuilder();
                keysAndValuesPattern.append("(?:");
                for (String var : this.vars.keySet()) {
                    keysAndValuesPattern.append(orSign);
                    keysAndValuesPattern.append("(?:");
                    keysAndValuesPattern.append(var);
                    keysAndValuesPattern.append("=");
                    keysAndValuesPattern.append("[^/]*?");
                    keysAndValuesPattern.append(")");
                    orSign = "|";
                }
                keysAndValuesPattern.append(")");
                builder.append("(");
                builder.append(keysAndValuesPattern.toString());
                builder.append("(?:");
                builder.append(Pattern.quote(this.arg));
                builder.append(keysAndValuesPattern.toString());
                builder.append(")*)?");
            }

            @Override
            public void onMatch(String matched, MultivaluedMap<String, String> values, int startIndex, MultivaluedMap<String, Integer> indices) {
                HashMap<String, String> extractedValues = new HashMap<String, String>();
                if (matched != null) {
                    String[] array = StringUtils.fastSplit(matched, this.arg);
                    for (int i = 0; i < array.length; ++i) {
                        String var = array[i];
                        String value = "";
                        int index = var.indexOf(61);
                        if (index != -1) {
                            value = var.substring(index + 1);
                            var = var.substring(0, index);
                        }
                        extractedValues.put(var, value);
                    }
                }
                for (String key : this.vars.keySet()) {
                    values.putSingle((Object)key, extractedValues.get(key));
                    indices.putSingle((Object)key, (Object)startIndex);
                }
            }

            @Override
            public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
                String delim = "";
                for (String var : this.vars.keySet()) {
                    java.util.List varValues = (java.util.List)values.get((Object)var);
                    String value = "";
                    if (varValues == null) continue;
                    if (varValues.size() > 1) {
                        throw new IllegalArgumentException(Messages.getMessage("variableContainsMoreThanOneValueForJoinOperator", var));
                    }
                    if (varValues.size() != 1 || (value = (String)varValues.get(0)) == null) continue;
                    builder.append(delim);
                    builder.append(var);
                    builder.append("=");
                    if (encode) {
                        value = UriEncoder.encodeString(value);
                    }
                    builder.append(value);
                    delim = this.arg;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class List
        extends BitWorkingOperator {
            public List() {
                super("list");
            }

            @Override
            public void build(StringBuilder builder) {
                if (this.vars.size() != 1) {
                    throw new IllegalArgumentException(Messages.getMessage("listOperatorMustHaveOnlyOneVariable"));
                }
                builder.append("(");
                builder.append("[^/]*?");
                builder.append("(?:");
                builder.append(Pattern.quote(this.arg));
                builder.append("[^/]*?");
                builder.append(")*)");
            }

            @Override
            public void onMatch(String matched, MultivaluedMap<String, String> values, int startIndex, MultivaluedMap<String, Integer> indices) {
                String var = (String)this.vars.keySet().iterator().next();
                if (matched == null || matched.length() == 0) {
                    values.putSingle((Object)var, (Object)"");
                    indices.putSingle((Object)var, (Object)startIndex);
                    return;
                }
                values.put((Object)var, null);
                String[] array = StringUtils.fastSplit(matched, this.arg);
                for (int i = 0; i < array.length; ++i) {
                    values.add((Object)var, (Object)array[i]);
                    indices.add((Object)var, (Object)startIndex);
                }
            }

            @Override
            public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
                String var = (String)this.vars.keySet().iterator().next();
                String delim = "";
                java.util.List varValues = (java.util.List)values.get((Object)var);
                if (varValues != null) {
                    for (String value : varValues) {
                        builder.append(delim);
                        if (encode) {
                            value = UriEncoder.encodeString(value);
                        }
                        builder.append(value);
                        delim = this.arg;
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Suffix
        extends BitWorkingOperator {
            public Suffix() {
                super("suffix");
            }

            @Override
            public void build(StringBuilder builder) {
                if (this.vars.size() != 1) {
                    throw new IllegalArgumentException(Messages.getMessage("suffixOperatorMustOnlyHaveOneVariable"));
                }
                builder.append("((?:");
                builder.append("[^/]*?");
                builder.append(Pattern.quote(this.arg));
                builder.append(")*)");
            }

            @Override
            public void onMatch(String matched, MultivaluedMap<String, String> values, int startIndex, MultivaluedMap<String, Integer> indices) {
                String var = (String)this.vars.keySet().iterator().next();
                if (matched == null || matched.length() == 0) {
                    values.putSingle((Object)var, null);
                    indices.putSingle((Object)var, (Object)startIndex);
                    return;
                }
                if (!matched.endsWith(this.arg)) {
                    throw new IllegalArgumentException(Messages.getMessage("matchedSuffixMustEndWith", this.arg));
                }
                values.put((Object)var, null);
                String[] array = StringUtils.fastSplit(matched, this.arg);
                for (int i = 0; i < array.length - 1; ++i) {
                    values.add((Object)var, (Object)array[i]);
                    indices.add((Object)var, (Object)startIndex);
                }
            }

            @Override
            public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
                String var = (String)this.vars.keySet().iterator().next();
                java.util.List varValues = (java.util.List)values.get((Object)var);
                if (varValues != null) {
                    for (String value : varValues) {
                        if (encode) {
                            value = UriEncoder.encodeString(value);
                        }
                        builder.append(value);
                        builder.append(this.arg);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Prefix
        extends BitWorkingOperator {
            public Prefix() {
                super("prefix");
            }

            @Override
            public void build(StringBuilder builder) {
                if (this.vars.size() != 1) {
                    throw new IllegalArgumentException(Messages.getMessage("prefixOperatorMustHaveOnlyOneVariable"));
                }
                builder.append("((?:");
                builder.append(Pattern.quote(this.arg));
                builder.append("[^/]*?");
                builder.append(")*)");
            }

            @Override
            public void onMatch(String matched, MultivaluedMap<String, String> values, int startIndex, MultivaluedMap<String, Integer> indices) {
                String var = (String)this.vars.keySet().iterator().next();
                if (matched == null || matched.length() == 0) {
                    values.putSingle((Object)var, null);
                    indices.putSingle((Object)var, (Object)startIndex);
                    return;
                }
                if (!matched.startsWith(this.arg)) {
                    throw new IllegalArgumentException(Messages.getMessage("matchedSuffixMustStartWith", this.arg));
                }
                values.put((Object)var, null);
                String[] array = StringUtils.fastSplit(matched, this.arg);
                for (int i = 1; i < array.length; ++i) {
                    values.add((Object)var, (Object)array[i]);
                    indices.add((Object)var, (Object)startIndex);
                }
            }

            @Override
            public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
                String var = (String)this.vars.keySet().iterator().next();
                java.util.List varValues = (java.util.List)values.get((Object)var);
                if (varValues != null) {
                    for (String value : varValues) {
                        builder.append(this.arg);
                        if (encode) {
                            value = UriEncoder.encodeString(value);
                        }
                        builder.append(value);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Opt
        extends BitWorkingOperator {
            public Opt() {
                super("opt");
            }

            @Override
            public void build(StringBuilder builder) {
                builder.append("(");
                builder.append(Pattern.quote(this.arg));
                builder.append(")?");
            }

            @Override
            public void onMatch(String matched, MultivaluedMap<String, String> values, int startIndex, MultivaluedMap<String, Integer> indices) {
            }

            @Override
            public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
                for (String var : this.vars.keySet()) {
                    if (!values.containsKey((Object)var) || ((java.util.List)values.get((Object)var)).size() <= 0) continue;
                    builder.append(this.arg);
                    return;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Neg
        extends BitWorkingOperator {
            public Neg() {
                super("neg");
            }

            @Override
            public void build(StringBuilder builder) {
                builder.append("(");
                builder.append(Pattern.quote(this.arg));
                builder.append(")?");
            }

            @Override
            public void onMatch(String matched, MultivaluedMap<String, String> values, int startIndex, MultivaluedMap<String, Integer> indices) {
            }

            @Override
            public void expand(MultivaluedMap<String, String> values, boolean encode, StringBuilder builder) {
                for (String var : this.vars.keySet()) {
                    if (!values.containsKey((Object)var) || ((java.util.List)values.get((Object)var)).size() <= 0) continue;
                    return;
                }
                builder.append(this.arg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BitWorkingPatternBuilder
    extends UriTemplateProcessor.AbstractPatternBuilder
    implements BitWorkingCompilationHandler {
        public BitWorkingPatternBuilder(BitWorkingUriTemplateProcessor processor) {
            super(processor);
        }

        @Override
        public void variable(String name, String defaultValue) {
            UriTemplateProcessor.CapturingGroup variable = this.createVariable(name, null, defaultValue);
            this.processor.variables.add((Object)name, (Object)variable);
            this.processor.expanders.add(variable);
        }

        @Override
        public void operator(String name, String arg, Map<String, String> vars) {
            BitWorkingOperator operator = BitWorkingOperator.forName(name);
            if (operator == null) {
                throw new IllegalArgumentException(Messages.getMessage("unsupportedOperator", name));
            }
            operator.setArg(arg);
            operator.setVars(vars);
            operator.build(this.patternBuilder);
            ++this.capturingGroupId;
            operator.setCapturingGroupId(this.capturingGroupId);
            for (String var : vars.keySet()) {
                this.processor.variables.add((Object)var, (Object)operator);
            }
            this.processor.expanders.add(operator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BitWorkingCompilationHandler
    extends UriTemplateProcessor.BaseCompilationHandler {
        public void variable(String var1, String var2);

        public void operator(String var1, String var2, Map<String, String> var3);
    }
}

