/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.sdk.PageParameters;
import com.unboundid.scim.sdk.SortParameters;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryRequest {
    private Set<String> schemas;
    private List<String> attributes;
    private List<String> excludedAttributes;
    private String filter;
    private PageParameters pageParameters;
    private SortParameters sortParameters;
    private Map<String, Map<String, Object>> extensionAttributes = new HashMap<String, Map<String, Object>>();
    public static final String SEARCH_REQUEST_SCHEMA = "urn:ietf:params:scim:api:messages:2.0:SearchRequest";

    public QueryRequest() {
        this.schemas = new HashSet<String>();
        this.schemas.add(SEARCH_REQUEST_SCHEMA);
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    public void setExcludedAttributes(List<String> excludedAttributes) {
        this.excludedAttributes = excludedAttributes;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }

    public SortParameters getSortParameters() {
        return this.sortParameters;
    }

    public void setSortParameters(SortParameters sortParameters) {
        this.sortParameters = sortParameters;
    }

    public void setExtensionAttribute(String schema, String attribute, Object value) {
        this.schemas.add(schema);
        Map<String, Object> schemaAttributes = this.extensionAttributes.get(schema);
        if (schemaAttributes == null) {
            schemaAttributes = new HashMap<String, Object>();
            this.extensionAttributes.put(schema, schemaAttributes);
        }
        schemaAttributes.put(attribute, value);
    }

    public Object getExtensionAttribute(String schema, String attribute) {
        Map<String, Object> schemaAttributes = this.extensionAttributes.get(schema);
        return schemaAttributes == null ? null : schemaAttributes.get(attribute);
    }

    public Map<String, Object> getExtensionAttributes(String schema) {
        return this.extensionAttributes.get(schema);
    }
}

