/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPart {
    private MultivaluedMap<String, String> headers = new CaseInsensitiveMultivaluedMap<String>();
    private InputStream inputStream;
    private Providers providers;

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public InPart() {
    }

    public InPart(MultivaluedMap<String, String> headers, Providers providers) {
        this.headers = headers;
        this.providers = providers;
    }

    protected void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        String res = (String)this.getHeaders().getFirst((Object)"Content-Type");
        if (res == null) {
            res = "text/plain";
        }
        return res;
    }

    public Set<String> getHeadersName() {
        return this.getHeaders().keySet();
    }

    public <T> T getBody(Class<T> type, Type genericType, Providers providers) throws IOException {
        MediaType mt = MediaType.valueOf((String)this.getContentType());
        MessageBodyReader reader = providers.getMessageBodyReader(type, genericType, null, mt);
        if (reader == null) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        return (T)reader.readFrom(type, genericType, null, mt, this.getHeaders(), this.getInputStream());
    }

    public <T> T getBody(Class<T> type, Type genericType) throws IOException {
        return this.getBody(type, genericType, this.providers);
    }
}

