/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.properties;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinkSystemProperties {
    private static final Logger logger = LoggerFactory.getLogger(WinkSystemProperties.class);

    public static Properties loadSystemProperties(Properties properties) {
        String key = null;
        String value = null;
        Properties systemProperties = new Properties();
        if (properties != null) {
            Enumeration<?> keyEnum = properties.propertyNames();
            while (keyEnum.hasMoreElements()) {
                key = (String)keyEnum.nextElement();
                value = (String)properties.get(key);
                if (value == null || value.length() == 0) {
                    value = WinkSystemProperties.getSystemProperty(key);
                    if (value == null) continue;
                    systemProperties.setProperty(key, value);
                    continue;
                }
                logger.trace("Property {} is already defined with value {}", (Object)key, (Object)value);
            }
        } else {
            logger.trace("Properties are null");
        }
        return systemProperties;
    }

    private static String getSystemProperty(final String key) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String v = System.getProperty(key);
                logger.trace(key + " = " + v);
                return v;
            }
        });
        return value;
    }
}

