/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.Operation;
import com.unboundid.scim.data.PatchResource;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.nuxeo.ecm.ScimNuxeoUserUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.jaxrs.usermanager.GroupMapperHelper;
import org.nuxeo.scim.server.jaxrs.usermanager.UserMapperHelper;
import org.nuxeo.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMapper {
    private static final Logger log = LoggerFactory.getLogger(UserMapper.class);
    protected final String baseUrl;
    public static final UserManager um = (UserManager)Framework.getService(UserManager.class);

    public UserMapper(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public GroupResource getGroupResourceFromGroupModel(DocumentModel groupModel) {
        log.debug("getGroupResourceFromGroupModel | {}", (Object)groupModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        GroupResource groupResource = new GroupResource(CoreSchema.GROUP_DESCRIPTOR);
        String groupId = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupIdField());
        String externalId = (String)groupModel.getProperty(um.getGroupSchemaName(), "externalId");
        String groupLabel = (String)groupModel.getProperty(um.getGroupSchemaName(), um.getGroupLabelField());
        groupResource.setDisplayName(groupLabel);
        groupResource.setId(groupId);
        groupResource.setExternalId(externalId);
        URI location = new URI(this.baseUrl + "/" + groupId);
        Meta meta = new Meta(null, null, location, "1");
        groupResource.setMeta(meta);
        return groupResource;
    }

    public UserResource getUserResourceFromUserModel(DocumentModel userModel) {
        log.debug("getUserResourceFromUserModel {}", (Object)userModel.getId());
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        UserResource userResource = new UserResource(CoreSchema.USER_DESCRIPTOR);
        String userId = (String)userModel.getProperty(um.getUserSchemaName(), um.getUserIdField());
        userResource.setUserName(userId);
        userResource.setId(userId);
        userResource.setExternalId(userId);
        String fname = (String)userModel.getProperty(um.getUserSchemaName(), "firstName");
        String lname = (String)userModel.getProperty(um.getUserSchemaName(), "lastName");
        String email = (String)userModel.getProperty(um.getUserSchemaName(), "email");
        String company = (String)userModel.getProperty(um.getUserSchemaName(), "company");
        String displayName = String.format("%s %s", fname, lname);
        displayName = displayName.trim();
        userResource.setDisplayName(displayName);
        ArrayList<Entry> emails = new ArrayList<Entry>();
        if (email != null) {
            emails.add(new Entry((Object)email, "string"));
            userResource.setEmails(emails);
        }
        Name fullName = new Name(displayName, lname, "", fname, "", "");
        userResource.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", Name.NAME_RESOLVER, (Object)fullName);
        URI location = new URI(this.baseUrl + "/" + userId);
        Meta meta = new Meta(null, null, location, "1");
        userResource.setMeta(meta);
        List groupIds = um.getPrincipal(userId).getAllGroups();
        ArrayList<Entry> groups = new ArrayList<Entry>();
        for (String groupId : groupIds) {
            groups.add(new Entry((Object)groupId, "string"));
        }
        userResource.setGroups(groups);
        userResource.setActive(Boolean.valueOf(true));
        return userResource;
    }

    public DocumentModel createUserModelFromUserResource(UserResource user) throws ClientException {
        String userId = user.getId();
        if (userId == null || userId.isEmpty()) {
            userId = user.getUserName();
        }
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel newUser = um.getBareUserModel();
        log.debug("createUserModelFromUserResource | {}", (Object)user.getUserName());
        newUser.setProperty(um.getUserSchemaName(), um.getUserIdField(), (Object)userId);
        this.updateUserModel(newUser, user);
        DocumentModel userModel = (DocumentModel)Framework.doPrivileged(() -> um.createUser(newUser));
        UserManager um2 = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel2 = um2.getUserModel(userModel.getId());
        log.debug("User {} created with ID {}", (Object)userId, (Object)userModel2.getId());
        return userModel;
    }

    public DocumentModel patchUser(String uid, PatchResource patch) {
        log.debug("patchUser");
        DocumentModel doc = um.getUserModel(uid);
        if (doc == null) {
            log.warn("User not found {}", (Object)uid);
            return null;
        }
        PatchUpdater updater = op -> this.userOp(um, doc, op);
        if (this.patch(uid, patch, updater) > 0) {
            um.updateUser(doc);
        }
        return doc;
    }

    public DocumentModel patchGroup(String uid, PatchResource patch) {
        log.debug("patchGroup");
        DocumentModel doc = um.getGroupModel(uid);
        if (doc == null) {
            log.warn("Group not found {}", (Object)uid);
            return null;
        }
        PatchUpdater updater = op -> this.groupOp(um, doc, op);
        if (this.patch(uid, patch, updater) > 0) {
            um.updateGroup(doc);
        }
        return doc;
    }

    public int patch(String uid, PatchResource patch, PatchUpdater updater) throws ClientException {
        int countOfOperations;
        int n = countOfOperations = patch.getOperations() != null ? patch.getOperations().size() : 0;
        if (countOfOperations == 0) {
            log.warn("No operations submitted for PATCH request for doc {}", (Object)uid);
            return 0;
        }
        log.debug("");
        log.debug("Perform {} patch operations for {}", (Object)countOfOperations, (Object)uid);
        log.debug("------------------------------------------------------------------");
        AtomicInteger cnt = new AtomicInteger();
        patch.getOperations().forEach(x -> cnt.addAndGet(updater.op((Operation)x) ? 1 : 0));
        log.debug("{} out of {} path operations succeeded for {}", new Object[]{cnt, countOfOperations, uid});
        return cnt.get();
    }

    private boolean userOp(UserManager um, DocumentModel userModel, Operation op) {
        String opType = op.getOp();
        String field = op.getPath();
        String value = op.getValue();
        log.debug("user op:{}, field:{}, value:{}", new Object[]{opType, field, value});
        if ("displayName".equalsIgnoreCase(field)) {
            if ("Replace".equals(opType)) {
                UserMapperHelper.replaceDisplayName(um, userModel, value);
                return true;
            }
            log.debug("Operation {} is not supported for {}", (Object)opType, (Object)field);
        } else {
            log.warn("Property [{}] is not supported for PATCH ", (Object)field);
        }
        return false;
    }

    private boolean groupOp(UserManager um, DocumentModel doc, Operation op) {
        String opType = op.getOp();
        String field = op.getPath();
        String value = op.getValue();
        log.debug("group op:{}, field:{}, value:{}", new Object[]{opType, field, value});
        if ("displayName".equalsIgnoreCase(field)) {
            if ("Replace".equals(opType)) {
                GroupMapperHelper.replaceDisplayName(um, doc, value);
                return true;
            }
            log.debug("Operation {} is not supported for {}", (Object)opType, (Object)field);
        } else if ("externalId".equalsIgnoreCase(field)) {
            if ("Replace".equals(opType)) {
                GroupMapperHelper.replaceExternalId(um, doc, value);
                return true;
            }
            log.debug("Operation {} is not supported for {}", (Object)opType, (Object)field);
        } else {
            log.warn("Property [{}] is not supported for PATCH ", (Object)field);
        }
        return false;
    }

    public DocumentModel updateUserModelFromUserResource(String uid, UserResource user) throws ClientException {
        log.debug("updateUserModelFromUserResource {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel == null) {
            log.warn("User not found {}", (Object)uid);
            return null;
        }
        this.updateUserModel(userModel, user);
        um.updateUser(userModel);
        if (user.getGroups() != null) {
            Set<String> groups = user.getGroups().stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getValue())).map(Entry::getValue).collect(Collectors.toSet());
            ScimNuxeoUserUtils.addUserToGroups(userModel.getId(), groups);
        }
        return userModel;
    }

    protected void updateUserModel(DocumentModel userModel, UserResource userResource) throws ClientException {
        log.debug("updateUserModel {}", (Object)userResource.getUserName());
        CommonUtils.logUserResource(userResource);
        String displayName = userResource.getDisplayName();
        Collection emails = userResource.getEmails();
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (emails != null && !emails.isEmpty()) {
            userModel.setProperty(um.getUserSchemaName(), "email", ((Entry)userResource.getEmails().iterator().next()).getValue());
        }
        UserMapperHelper.replaceDisplayName(um, userModel, displayName);
    }

    public DocumentModel createGroupModelFromGroupResource(GroupResource group) throws ClientException {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        if (um.getGroup(group.getId()) == null) {
            DocumentModel newGroup = um.getBareGroupModel();
            String groupId = group.getId();
            if (groupId == null || groupId.isEmpty()) {
                groupId = group.getDisplayName();
            }
            newGroup.setProperty(um.getGroupSchemaName(), um.getGroupIdField(), (Object)groupId);
            this.updateGroupModel(newGroup, group);
            return um.createGroup(newGroup);
        }
        log.warn("Group already exists {}", (Object)group.getId());
        return this.updateGroupModelFromGroupResource(group.getId(), group);
    }

    public DocumentModel updateGroupModelFromGroupResource(String uid, GroupResource group) throws ClientException {
        log.debug("updateGroupModelFromGroupResource | {}", (Object)uid);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupModel = um.getGroupModel(uid);
        if (groupModel == null) {
            log.warn("Group not found {}", (Object)uid);
            return null;
        }
        this.updateGroupModel(groupModel, group);
        um.updateGroup(groupModel);
        return groupModel;
    }

    protected void updateGroupModel(DocumentModel userModel, GroupResource groupResource) throws ClientException {
        log.debug("updateGroupModel");
        CommonUtils.logGroupResource(groupResource);
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        String displayName = groupResource.getDisplayName();
        String id = groupResource.getId();
        String externalId = groupResource.getExternalId();
        if (displayName != null && !displayName.isEmpty()) {
            userModel.setProperty(um.getGroupSchemaName(), um.getGroupLabelField(), (Object)displayName);
        }
    }

    static interface PatchUpdater {
        public boolean op(Operation var1);
    }
}

