/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.client;

import com.unboundid.scim.sdk.PreemptiveAuthInterceptor;
import com.unboundid.scim.sdk.SCIMService;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.wink.client.httpclient.ApacheHttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimClient {
    private static final Logger log = LoggerFactory.getLogger(ScimClient.class);

    public static int getServerPort() {
        return Integer.parseInt(System.getProperty("nuxeo.server.http.port"));
    }

    public static SCIMService getJsonService(String url) {
        log.debug("get service url", (Object)url);
        SCIMService scimService = new SCIMService(URI.create(url));
        scimService.setAcceptType(MediaType.APPLICATION_JSON_TYPE);
        return scimService;
    }

    public static SCIMService getJsonService(String url, String user, String password) {
        log.debug("get service url", (Object)url);
        SCIMService scimService = new SCIMService(URI.create(url), user, password);
        scimService.setAcceptType(MediaType.APPLICATION_JSON_TYPE);
        return scimService;
    }

    public static SCIMService getJsonService(String url, ApacheHttpClientConfig config) {
        log.debug("get service url", (Object)url);
        SCIMService scimService = new SCIMService(URI.create(url), config);
        scimService.setAcceptType(MediaType.APPLICATION_JSON_TYPE);
        return scimService;
    }

    public static ApacheHttpClientConfig createHttpBasicClientConfig(String userName, String password) {
        BasicHttpParams params = new BasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        params.setBooleanParameter("http.socket.reuseaddr", true);
        params.setBooleanParameter("http.protocol.expect-continue", true);
        params.setBooleanParameter("http.connection.stalecheck", true);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(schemeRegistry);
        mgr.setMaxTotal(200);
        mgr.setDefaultMaxPerRoute(20);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
        ApacheHttpClientConfig clientConfig = new ApacheHttpClientConfig((HttpClient)httpClient);
        return clientConfig;
    }
}

