/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.PatchResource;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.wink.PATCH;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.scim.server.jaxrs.marshalling.GroupResponse;
import org.nuxeo.scim.server.jaxrs.usermanager.BaseUMEndpoint;
import org.nuxeo.scim.server.jaxrs.usermanager.ReqContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebObject(type="groups")
@Produces(value={"application/json", "application/xml"})
public class SCIMGroupEndpoint
extends BaseUMEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SCIMGroupEndpoint.class);
    private static final Logger logger = LoggerFactory.getLogger(SCIMGroupEndpoint.class);

    @Override
    protected String getPrefix() {
        return "/Groups";
    }

    @GET
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public Resources<GroupResource> getGroups(@Context UriInfo uriInfo) {
        NuxeoPrincipal currentUser = NuxeoPrincipal.getCurrent();
        String username = currentUser.getName();
        log.debug("getGroups as user {}", (Object)username);
        ReqContext context = new ReqContext(uriInfo);
        try {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            String directoryName = um.getGroupDirectoryName();
            DocumentModelList groupModels = this.privilegedQuery(directoryName, context);
            log.debug("Groups found: {}", (Object)groupModels.size());
            ArrayList<GroupResource> groupResources = new ArrayList<GroupResource>(groupModels.size());
            for (DocumentModel groupModel : groupModels) {
                groupResources.add(this.mapper.getGroupResourceFromGroupModel(groupModel));
            }
            return new Resources(groupResources, groupResources.size(), context.startIndex);
        }
        catch (Throwable e) {
            log.error("Error while getting Groups", e);
            SCIMGroupEndpoint.returnError(e);
            return null;
        }
    }

    @Path(value="{uid}")
    @GET
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public GroupResource getGroupResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            return this.resolveGroup(uid);
        }
        catch (Throwable e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Path(value="{uid}.xml")
    @GET
    @Produces(value={"application/xml"})
    public GroupResource getGroupResourceAsXml(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getGroupResource(uriInfo, uid);
    }

    @Path(value="{uid}.json")
    @GET
    @Produces(value={"application/json"})
    public GroupResource getUserResourceAsJSON(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getGroupResource(uriInfo, uid);
    }

    @POST
    @Consumes(value={"application/json", "application/scim+json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response createGroup(@Context UriInfo uriInfo, GroupResource group, @Context HttpServletResponse response) {
        try {
            this.checkUpdateGuardPreconditions();
            return this.doCreateGroup(group, this.fixeMediaType);
        }
        catch (Throwable e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @PATCH
    @Path(value="{uid}")
    @Consumes(value={"application/json", "application/scim+json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response patchGroup(@Context UriInfo uriInfo, @PathParam(value="uid") String uid, PatchResource patch) {
        log.debug("patchGroup {}/{}", (Object)uid, (Object)this.fixeMediaType);
        return this.doPatchGroup(uid, patch, this.fixeMediaType);
    }

    @PUT
    @Path(value="{uid}")
    @Consumes(value={"application/json", "application/scim+json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateGroup(@Context UriInfo uriInfo, @PathParam(value="uid") String uid, GroupResource user) {
        log.debug("Update group {}", (Object)uid);
        try {
            this.checkUpdateGuardPreconditions();
            return this.doUpdateGroup(uid, user, this.fixeMediaType);
        }
        catch (Throwable e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Path(value="{uid}")
    @DELETE
    public Response deleteGroupResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            UserManager um = (UserManager)Framework.getService(UserManager.class);
            um.deleteGroup(uid);
            return Response.ok().build();
        }
        catch (DirectoryException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    protected GroupResource resolveGroup(String uid) throws Exception {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        DocumentModel groupModel = um.getGroupModel(uid);
        if (groupModel != null) {
            return this.mapper.getGroupResourceFromGroupModel(groupModel);
        }
        return null;
    }

    protected Response doUpdateGroup(String uid, GroupResource group, MediaType mt) throws Exception {
        DocumentModel groupModel = this.mapper.updateGroupModelFromGroupResource(uid, group);
        if (groupModel != null) {
            GroupResource groupResource = this.mapper.getGroupResourceFromGroupModel(groupModel);
            return GroupResponse.updated(groupResource, mt);
        }
        return null;
    }

    protected Response doCreateGroup(GroupResource group, MediaType mt) throws Exception {
        DocumentModel newGroup = this.mapper.createGroupModelFromGroupResource(group);
        GroupResource groupResource = this.mapper.getGroupResourceFromGroupModel(newGroup);
        return GroupResponse.created(groupResource, mt);
    }

    protected Response doPatchGroup(String uid, PatchResource patch, MediaType mt) {
        log.debug("doPatchGroup uid:{}, type:{}, sub:{}", new Object[]{uid, mt.getType(), mt.getSubtype()});
        if (patch == null) {
            log.warn("Patch is empty (probably wrong JSON schema. Must be urn:ietf:params:scim:api:messages:2.0:PatchOp");
            return Response.status((int)400).entity((Object)("Bad PATCH request for group" + uid)).build();
        }
        DocumentModel doc = this.mapper.patchGroup(uid, patch);
        if (doc != null) {
            GroupResource doc2 = this.mapper.getGroupResourceFromGroupModel(doc);
            return GroupResponse.updated(doc2, mt);
        }
        return Response.status((int)404).entity((Object)("Group " + uid + " not found for PATCH request")).build();
    }
}

