/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.Name;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.ScimNuxeoUserUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.scim.ScimProjectConstants;
import org.nuxeo.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMapperHelper {
    private static final Logger log = LoggerFactory.getLogger(UserMapperHelper.class);
    protected static String usrDisplayNameFormat = "%2$s, %1$s";

    public static void replaceDisplayName(DocumentModel usr, String displayName) {
        if (StringUtils.isNotEmpty((CharSequence)displayName)) {
            String val = displayName.trim();
            int idxComma = val.indexOf(",");
            if (idxComma > 0) {
                UserMapperHelper.usrVal(usr, "lastName", val.substring(0, idxComma).trim());
                UserMapperHelper.usrVal(usr, "firstName", val.substring(idxComma + 1).trim());
            } else {
                int idxSpace = val.indexOf(" ");
                if (idxSpace > 0) {
                    UserMapperHelper.usrVal(usr, "firstName", val.substring(0, idxSpace).trim());
                    UserMapperHelper.usrVal(usr, "lastName", val.substring(idxSpace + 1).trim());
                } else {
                    UserMapperHelper.usrVal(usr, "firstName", val);
                    UserMapperHelper.usrVal(usr, "lastName", "");
                }
            }
        }
    }

    public static void updateEmails(DocumentModel userModel, Collection<Entry<String>> emails) {
        if (emails != null) {
            for (Entry<String> email : emails) {
                String type = email.getType();
                String val = (String)email.getValue();
                if (!CommonUtils.validEmail(val)) {
                    log.warn("Not a valid email {} {}. Skip", (Object)type, email.getValue());
                    continue;
                }
                if ("work".equalsIgnoreCase(type)) {
                    UserMapperHelper.usrVal(userModel, "email", val);
                    continue;
                }
                log.warn("Unknown email type {} {}", (Object)type, (Object)val);
            }
        }
    }

    public static void updatePhones(DocumentModel userModel, Collection<Entry<String>> phones) {
        if (phones != null) {
            block8: for (Entry<String> phone : phones) {
                String type = phone.getType();
                String val = (String)phone.getValue();
                switch (type) {
                    case "work": {
                        UserMapperHelper.usrVal(userModel, "business_phones", val);
                        continue block8;
                    }
                    case "mobile": {
                        UserMapperHelper.usrVal(userModel, "mobile_phone", val);
                        continue block8;
                    }
                }
                log.warn("Unknown phone type {}", (Object)type);
            }
        }
    }

    public static Collection<Entry<String>> getEmails(DocumentModel userModel) {
        HashSet<Entry<String>> response = new HashSet<Entry<String>>();
        String email = UserMapperHelper.usrVal(userModel, "email");
        if (ObjectUtils.isNotEmpty((Object)email)) {
            response.add((Entry<String>)new Entry((Object)email, "work"));
        }
        return response;
    }

    public static Collection<Entry<String>> getPhones(DocumentModel userModel) {
        HashSet<Entry<String>> response = new HashSet<Entry<String>>();
        String mobile_phone = UserMapperHelper.usrVal(userModel, "mobile_phone");
        String work_phone = UserMapperHelper.usrVal(userModel, "business_phones");
        if (StringUtils.isNotEmpty((CharSequence)mobile_phone)) {
            response.add((Entry<String>)new Entry((Object)mobile_phone, "mobile"));
        }
        if (StringUtils.isNotEmpty((CharSequence)work_phone)) {
            response.add((Entry<String>)new Entry((Object)work_phone, "work"));
        }
        return response;
    }

    public static Collection<Entry<String>> getGroups(String userId) {
        UserManager um = ScimNuxeoUserUtils.getUsrMgr();
        List groupIds = um.getPrincipal(userId).getAllGroups();
        ArrayList<Entry<String>> groups = new ArrayList<Entry<String>>();
        for (String groupId : groupIds) {
            groups.add((Entry<String>)new Entry((Object)groupId, "string"));
        }
        return groups;
    }

    public static String usrVal(DocumentModel usr, String prop) {
        return (String)usr.getProperty(ScimProjectConstants.USR_SCHEMA, prop);
    }

    public static void usrVal(DocumentModel usr, String prop, String val) {
        usr.setProperty(ScimProjectConstants.USR_SCHEMA, prop, (Object)val);
    }

    public static void setUsrDisplayNameFormat(String newFormat) {
        usrDisplayNameFormat = newFormat;
    }

    public static String usrDisplayName(DocumentModel usr) {
        return String.format(usrDisplayNameFormat, UserMapperHelper.usrVal(usr, "firstName"), UserMapperHelper.usrVal(usr, "lastName")).trim();
    }

    public static Name usrFullName(DocumentModel usr) {
        String name1 = CommonUtils.checkNull(UserMapperHelper.usrVal(usr, "firstName"), "");
        String name2 = CommonUtils.checkNull(UserMapperHelper.usrVal(usr, "lastName"), "");
        String displayName = UserMapperHelper.usrDisplayName(usr);
        return new Name(displayName, name2, "", name1, "", "");
    }

    public static Meta usrMeta(String userId, String baseUrl) {
        URI location = new URI(baseUrl + "/" + userId);
        return new Meta(null, null, location, "1");
    }
}

