/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.webengine.app.jersey.WebEngineServlet;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationFragment;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationHost;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationManager;

public class ScimHostServlet
extends WebEngineServlet {
    private static final Logger logger = LogManager.getLogger(ScimHostServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("{}", (Object)request.getRequestURI());
        try {
            super.service(request, response);
        }
        catch (Throwable e) {
            logger.error("-------------------------------------------------------------------------------------------");
            logger.error("Request {} failed: ", (Object)request.getRequestURI());
            logger.error("-------------------------------------------------------------------------------------------");
            throw e;
        }
    }

    public ScimHostServlet() {
        logger.debug("SCIM SERVLET CREATED");
    }

    public void init(ServletConfig config) throws ServletException {
        List<ApplicationFragment> deployed;
        String name = config.getInitParameter("application.name");
        logger.debug("SCIM SERVLET INIT FOR HOST {}", (Object)name);
        ApplicationManager mayIspeakToYourManager = ApplicationManager.getInstance();
        ApplicationHost host = mayIspeakToYourManager.getApplication("scim_host");
        if (host != null && host.getApplications() != null && !(deployed = Arrays.asList(host.getApplications())).isEmpty()) {
            logger.debug("HOST FOUND {} WITH {} APPS", (Object)host.getName(), (Object)deployed.size());
            TreeSet<String> bundles = new TreeSet<String>();
            for (ApplicationFragment deployedApp : deployed) {
                String key = deployedApp.getBundle().getSymbolicName();
                if (bundles.contains(key)) {
                    logger.warn("This bundle was already deployed {}, removing", (Object)key);
                    host.remove(deployedApp);
                    continue;
                }
                bundles.add(key);
            }
        }
        super.init(config);
    }
}

