/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.google.gson.Gson;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.ScimNuxeoUserUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.scim.ScimProjectConstants;
import org.nuxeo.scim.server.jaxrs.usermanager.objects.PatchValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMapperHelper {
    private static final Logger log = LoggerFactory.getLogger(GroupMapperHelper.class);
    private static final Gson gson = new Gson();

    public static final String grpVal(DocumentModel grp, String prop) {
        return (String)grp.getProperty(ScimProjectConstants.GRP_SCHEMA, prop);
    }

    public static final void grpVal(DocumentModel grp, String prop, String val) {
        grp.setProperty(ScimProjectConstants.GRP_SCHEMA, prop, (Object)val);
    }

    public static boolean patchMembers(DocumentModel grp, String opType, String value) {
        List members = (List)gson.fromJson(value, PatchValue.LIST);
        List currentMembers = (List)grp.getProperty(ScimProjectConstants.GRP_SCHEMA, ScimProjectConstants.GROUP_MEMBERS);
        boolean res = false;
        for (PatchValue member : members) {
            String usr = member.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)usr)) continue;
            DocumentModel userObj = ScimNuxeoUserUtils.getUserById(usr);
            if (userObj == null) {
                log.warn("Usr {} not found. No add to grp {}", (Object)usr, (Object)grp.getId());
                continue;
            }
            switch (opType) {
                case "Add": {
                    if (currentMembers.contains(usr)) break;
                    currentMembers.add(usr);
                    res = true;
                    break;
                }
                case "Remove": {
                    if (!currentMembers.contains(usr)) break;
                    currentMembers.remove(usr);
                    res = true;
                }
            }
        }
        if (res) {
            grp.setProperty(ScimProjectConstants.GRP_SCHEMA, ScimProjectConstants.GROUP_MEMBERS, (Object)currentMembers);
        }
        return res;
    }
}

