/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.apache.wink.common.internal.utils.MediaTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDispositionHeader
implements Cloneable {
    private String fileName;
    private String defaultExtension;
    private boolean attachment;
    private static final Map<MediaType, ContentDispositionHeader> mediaType2ContentDisposition = ContentDispositionHeader.contructMediaType2ContentDisposition();

    private static Map<MediaType, ContentDispositionHeader> contructMediaType2ContentDisposition() {
        HashMap<MediaType, ContentDispositionHeader> result = new HashMap<MediaType, ContentDispositionHeader>();
        ContentDispositionHeader.putContentDispositionRecord(result, MediaTypeUtils.CSV_TYPE, true, "csv");
        ContentDispositionHeader.putContentDispositionRecord(result, MediaTypeUtils.PDF_TYPE, false, "pdf");
        return Collections.unmodifiableMap(result);
    }

    private static void putContentDispositionRecord(Map<MediaType, ContentDispositionHeader> map, MediaType mediaType, boolean attachment, String extension) {
        map.put(mediaType, new ContentDispositionHeader(attachment, extension));
    }

    public static ContentDispositionHeader createContentDispositionHeader(MediaType mediaType) {
        try {
            ContentDispositionHeader contentDispositionHeader = mediaType2ContentDisposition.get(mediaType);
            if (contentDispositionHeader != null) {
                return contentDispositionHeader.clone();
            }
            return new ContentDispositionHeader();
        }
        catch (CloneNotSupportedException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public ContentDispositionHeader() {
    }

    public ContentDispositionHeader(boolean attachment, String defaultExtension) {
        this.defaultExtension = defaultExtension;
        this.attachment = attachment;
    }

    public void setDefaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setAttachment(boolean attachment) {
        this.attachment = attachment;
    }

    public boolean isAttachment() {
        return this.attachment;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected ContentDispositionHeader clone() throws CloneNotSupportedException {
        return (ContentDispositionHeader)super.clone();
    }
}

