/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.GenericsUtils;
import org.apache.wink.common.internal.utils.HttpDateParser;
import org.apache.wink.common.internal.utils.UriHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueConvertor {
    public abstract Object convert(String var1) throws WebApplicationException;

    public abstract Object convert(List<String> var1) throws WebApplicationException;

    public Class<?> getConcreteType(Class<?> type) {
        return type;
    }

    public Object convert(String[] value) throws WebApplicationException {
        if (value == null || value.length == 0) {
            return this.convert(new ArrayList<String>());
        }
        return this.convert(Arrays.asList(value));
    }

    public static ValueConvertor createValueConvertor(Class<?> type) {
        return ValueConvertor.createValueConvertor(type, null);
    }

    public static ValueConvertor createValueConvertor(Class<?> type, Type genericType) {
        if (type.isArray()) {
            return ValueConvertor.createArrayValueConvertor(type.getComponentType(), genericType);
        }
        return ValueConvertor.createConcreteValueConvertor(type, genericType);
    }

    private static ValueConvertor createArrayValueConvertor(Class<?> componentType, Type genericType) {
        ValueConvertor concreteConvertor = ValueConvertor.createConcreteValueConvertor(componentType, genericType);
        return new ArrayValueConvertor(concreteConvertor, componentType);
    }

    public static ValueConvertor createConcreteValueConvertor(Class<?> classType, Type genericType) {
        if (classType.equals(List.class)) {
            return new ListConvertor(ValueConvertor.getSingleValueConvertor(GenericsUtils.getGenericParamType(genericType)));
        }
        if (classType.equals(SortedSet.class)) {
            return new SortedSetConvertor(ValueConvertor.getSingleValueConvertor(GenericsUtils.getGenericParamType(genericType)));
        }
        if (classType.equals(Set.class)) {
            return new SetConvertor(ValueConvertor.getSingleValueConvertor(GenericsUtils.getGenericParamType(genericType)));
        }
        if (classType.isEnum()) {
            return ValueConvertor.getEnumValueConvertor(classType);
        }
        return ValueConvertor.getSingleValueConvertor(classType);
    }

    private static ValueConvertor getEnumValueConvertor(Class<?> classType) {
        if (classType == null) {
            return null;
        }
        try {
            Constructor<?> constructor = classType.getConstructor(String.class);
            return new ConstructorConvertor(constructor);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Method valueOf = classType.getDeclaredMethod("fromString", String.class);
            return new FromStringConvertor(valueOf);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            try {
                Method fromString = classType.getDeclaredMethod("valueOf", String.class);
                return new ValueOfConvertor(fromString);
            }
            catch (SecurityException e2) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(Messages.getMessage("notASupportedResourceMethodParam", classType));
    }

    private static ValueConvertor getSingleValueConvertor(Class<?> classType) {
        if (classType.equals(String.class)) {
            return new StringConvertor();
        }
        if (classType.equals(Character.class)) {
            return new CharacterConvertor();
        }
        if (classType.isPrimitive()) {
            return new PrimitiveConvertor(classType);
        }
        if (classType.equals(PathSegment.class)) {
            return new PathSegmentConvertor();
        }
        return ValueConvertor.getComplexValueConverter(classType);
    }

    private static ValueConvertor getComplexValueConverter(Class<?> classType) {
        if (classType == null) {
            return null;
        }
        try {
            Constructor<?> constructor = classType.getConstructor(String.class);
            return new ConstructorConvertor(constructor);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Method valueOf = classType.getDeclaredMethod("valueOf", String.class);
            return new ValueOfConvertor(valueOf);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            try {
                Method fromString = classType.getDeclaredMethod("fromString", String.class);
                return new FromStringConvertor(fromString);
            }
            catch (SecurityException e2) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(Messages.getMessage("notASupportedResourceMethodParam", classType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortedSetConvertor
    extends CollectionValueConvertor {
        public SortedSetConvertor(ValueConvertor converter) {
            super(converter);
        }

        @Override
        public Object convert(List<String> values) throws WebApplicationException {
            return this.convertCollection(values, new TreeSet<Object>());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetConvertor
    extends CollectionValueConvertor {
        public SetConvertor(ValueConvertor converter) {
            super(converter);
        }

        @Override
        public Object convert(List<String> values) throws WebApplicationException {
            return this.convertCollection(values, new LinkedHashSet<Object>());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListConvertor
    extends CollectionValueConvertor {
        public ListConvertor(ValueConvertor converter) {
            super(converter);
        }

        @Override
        public Object convert(List<String> values) throws WebApplicationException {
            return this.convertCollection(values, new ArrayList<Object>(values.size()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CollectionValueConvertor
    extends ValueConvertor {
        protected ValueConvertor converter;

        public CollectionValueConvertor(ValueConvertor converter) {
            this.converter = converter;
        }

        @Override
        public Object convert(String value) {
            ArrayList<String> list = new ArrayList<String>();
            if (value != null) {
                list.add(value);
            }
            return this.convert(list);
        }

        protected Collection<Object> convertCollection(List<String> values, Collection<Object> out) {
            for (String string : values) {
                out.add(this.converter.convert(string));
            }
            return out;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimitiveConvertor
    extends SingleValueConvertor {
        protected final Class<?> targetClass;

        PrimitiveConvertor(Class<?> targetClass) {
            this.targetClass = targetClass;
        }

        @Override
        public Object convert(String value) throws WebApplicationException {
            try {
                if (this.targetClass.equals(Boolean.TYPE)) {
                    if (value == null) {
                        return false;
                    }
                    return (boolean)Boolean.valueOf(value);
                }
                if (this.targetClass.equals(Character.TYPE)) {
                    if (value == null || value.length() == 0) {
                        return Character.valueOf('\u0000');
                    }
                    return Character.valueOf(Character.valueOf(value.charAt(0)).charValue());
                }
                if (this.targetClass.equals(Byte.TYPE)) {
                    if (value == null) {
                        return (byte)0;
                    }
                    return (byte)Byte.valueOf(value);
                }
                if (this.targetClass.equals(Short.TYPE)) {
                    if (value == null) {
                        return (short)0;
                    }
                    return (short)Short.valueOf(value);
                }
                if (this.targetClass.equals(Integer.TYPE)) {
                    if (value == null) {
                        return 0;
                    }
                    return (int)Integer.valueOf(value);
                }
                if (this.targetClass.equals(Long.TYPE)) {
                    if (value == null) {
                        return 0L;
                    }
                    return (long)Long.valueOf(value);
                }
                if (this.targetClass.equals(Float.TYPE)) {
                    if (value == null) {
                        return Float.valueOf(0.0f);
                    }
                    return Float.valueOf(Float.valueOf(value).floatValue());
                }
                if (this.targetClass.equals(Double.TYPE)) {
                    if (value == null) {
                        return 0.0;
                    }
                    return (double)Double.valueOf(value);
                }
            }
            catch (Exception e) {
                throw this.createConversionException(value, this.targetClass, e);
            }
            throw this.createConversionException(value, this.targetClass, null);
        }
    }

    private static class PathSegmentConvertor
    extends SingleValueConvertor {
        private PathSegmentConvertor() {
        }

        public PathSegment convert(String value) throws WebApplicationException {
            if (value == null) {
                return null;
            }
            List<PathSegment> segments = UriHelper.parsePath(value);
            if (segments.isEmpty()) {
                return null;
            }
            return segments.get(segments.size() - 1);
        }
    }

    private static class CharacterConvertor
    extends SingleValueConvertor {
        private CharacterConvertor() {
        }

        public Object convert(String value) throws WebApplicationException {
            if (value == null || value.length() == 0) {
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }
    }

    private static class StringConvertor
    extends SingleValueConvertor {
        private StringConvertor() {
        }

        public Object convert(String value) throws WebApplicationException {
            return value;
        }
    }

    private static class FromStringConvertor
    extends ValueOfConvertor {
        public FromStringConvertor(Method method) {
            super(method);
        }
    }

    private static class ValueOfConvertor
    extends SingleValueConvertor {
        private Method method;

        public ValueOfConvertor(Method method) {
            this.method = method;
        }

        public Object convert(String value) {
            if (value == null) {
                return null;
            }
            try {
                Object objToReturn = this.method.invoke(null, value);
                if (!objToReturn.getClass().equals(this.method.getDeclaringClass())) {
                    throw this.createConversionException(value, this.method.getDeclaringClass(), new Exception(Messages.getMessage("valueFromMethodMustBeType", this.method.toString(), this.method.getDeclaringClass()) + "  " + Messages.getMessage("returnedTypeWas", objToReturn.getClass())));
                }
                return objToReturn;
            }
            catch (IllegalArgumentException e) {
                throw this.createConversionException(value, this.method.getDeclaringClass(), e);
            }
            catch (IllegalAccessException e) {
                throw this.createConversionException(value, this.method.getDeclaringClass(), e);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw this.createConversionException(value, this.method.getDeclaringClass(), targetException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorConvertor
    extends SingleValueConvertor {
        private Constructor<?> constructor;

        public ConstructorConvertor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object convert(String value) {
            if (value == null) {
                return null;
            }
            if (this.constructor.getDeclaringClass() == Date.class) {
                return HttpDateParser.parseHttpDate(value);
            }
            try {
                return this.constructor.newInstance(value);
            }
            catch (IllegalArgumentException e) {
                throw this.createConversionException(value, this.constructor.getDeclaringClass(), e);
            }
            catch (InstantiationException e) {
                throw this.createConversionException(value, this.constructor.getDeclaringClass(), e);
            }
            catch (IllegalAccessException e) {
                throw this.createConversionException(value, this.constructor.getDeclaringClass(), e);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw this.createConversionException(value, this.constructor.getDeclaringClass(), targetException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SingleValueConvertor
    extends ValueConvertor {
        private SingleValueConvertor() {
        }

        RuntimeException createConversionException(String value, Class<?> targetClass, Throwable e) {
            if (e instanceof WebApplicationException) {
                return (RuntimeException)e;
            }
            return new ConversionException(Messages.getMessage("cannotConvertValueFromTo", value, targetClass), e);
        }

        @Override
        public Object convert(List<String> values) throws WebApplicationException {
            if (values == null || values.size() == 0) {
                return this.convert((String)null);
            }
            return this.convert(values.get(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayValueConvertor
    extends ValueConvertor {
        private ValueConvertor concrete;
        private Class<?> type;

        public ArrayValueConvertor(ValueConvertor concrete, Class<?> type) {
            this.concrete = concrete;
            this.type = concrete.getConcreteType(type);
        }

        @Override
        public Object convert(String value) throws WebApplicationException {
            Object[] array = (Object[])Array.newInstance(this.type, 1);
            array[0] = this.concrete.convert(value);
            return null;
        }

        @Override
        public Object convert(List<String> value) throws WebApplicationException {
            if (value == null || value.size() == 0) {
                return Array.newInstance(this.type, 0);
            }
            Object array = Array.newInstance(this.type, value.size());
            for (int i = 0; i < value.size(); ++i) {
                Array.set(array, i, this.concrete.convert(value.get(i)));
            }
            return array;
        }
    }

    public static class ConversionException
    extends RuntimeException {
        private static final long serialVersionUID = -450326706168680880L;

        public ConversionException() {
        }

        public ConversionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ConversionException(String message) {
            super(message);
        }

        public ConversionException(Throwable cause) {
            super(cause);
        }
    }
}

