/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.marshalling;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.PatchResource;
import com.unboundid.scim.marshal.json.JsonMarshaller;
import com.unboundid.scim.marshal.xml.XmlMarshaller;
import com.unboundid.scim.sdk.SCIMException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.nuxeo.scim.server.jaxrs.marshalling.PatchResourceWithMimeType;

@Provider
@Produces(value={"application/xml", "application/json"})
public class PatchResourceWriter
implements MessageBodyWriter<PatchResource> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return PatchResource.class.isAssignableFrom(type);
    }

    public long getSize(PatchResource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(PatchResource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            XmlMarshaller marshaller = null;
            httpHeaders.remove((Object)"Content-Type");
            if (t instanceof PatchResourceWithMimeType) {
                if (((PatchResourceWithMimeType)t).getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    marshaller = new JsonMarshaller();
                    httpHeaders.add((Object)"Content-Type", (Object)"application/json");
                } else {
                    marshaller = new XmlMarshaller();
                    httpHeaders.add((Object)"Content-Type", (Object)"application/xml");
                }
            } else if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                marshaller = new XmlMarshaller();
                httpHeaders.add((Object)"Content-Type", (Object)"application/xml");
            } else {
                marshaller = new JsonMarshaller();
                httpHeaders.add((Object)"Content-Type", (Object)"application/json");
            }
            marshaller.marshal((BaseResource)t, entityStream);
        }
        catch (SCIMException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

