/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.marshalling;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ServiceProviderConfig;
import com.unboundid.scim.marshal.json.JsonMarshaller;
import com.unboundid.scim.marshal.xml.XmlMarshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Provider
@Produces(value={"application/xml", "application/json"})
public class ServiceProviderConfigWriter
implements MessageBodyWriter<ServiceProviderConfig> {
    private static final Logger logger = LogManager.getLogger(MessageBodyWriter.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ServiceProviderConfig.class.isAssignableFrom(type);
    }

    public long getSize(ServiceProviderConfig t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ServiceProviderConfig t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            Object marshaller = null;
            marshaller = mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) ? new XmlMarshaller() : new JsonMarshaller();
            marshaller.marshal((BaseResource)t, entityStream);
        }
        catch (Throwable e) {
            logger.error("Can not write JSON ", e);
            throw new WebApplicationException(e);
        }
    }
}

