/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.scim.ScimProjectConstants;
import org.nuxeo.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortFilterContext {
    private static final Logger log = LoggerFactory.getLogger(SortFilterContext.class);
    Map<String, Serializable> filter = new HashMap<String, Serializable>();
    Map<String, String> orderBy = new HashMap<String, String>();
    int count = 9999;
    int startIndex = 1;

    public SortFilterContext(UriInfo uriInfo, String schema) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        this.applyFilters((Map<String, List<String>>)params, schema);
        this.applySort((Map<String, List<String>>)params);
        if (params.get((Object)"startIndex") != null) {
            this.startIndex = Integer.parseInt((String)((List)params.get((Object)"startIndex")).get(0));
        }
        if (params.get((Object)"count") != null) {
            this.count = SortFilterContext.getCount((Map<String, List<String>>)params);
        }
    }

    private void applyFilters(Map<String, List<String>> params, String schema) {
        List<String> filters = params.get("filter");
        if (filters != null && !filters.isEmpty()) {
            for (String srcFilter : filters) {
                Filter f = new Filter(srcFilter);
                if (f.eq()) {
                    String matchProp = this.matchProp(f, schema);
                    if (StringUtils.isNotEmpty((CharSequence)matchProp)) {
                        log.debug("filter {} {} {}", new Object[]{matchProp, f.op, f.value});
                        this.filter.put(matchProp, (Serializable)((Object)f.value));
                        continue;
                    }
                    throw new NuxeoException(String.format("Not supported filter %s %s %s", f.key, f.op, f.value));
                }
                throw new NuxeoException(String.format("Not supported filter %s %s %s", f.key, f.op, f.value));
            }
        }
    }

    private String matchProp(Filter filter, String schema) {
        if (ScimProjectConstants.USR_SCHEMA.equals(schema)) {
            switch (filter.key) {
                case "userName": {
                    return CommonUtils.isAzureId(filter.value) ? "azure_id" : "username";
                }
                case "displayName": {
                    return "username";
                }
                case "externalId": 
                case "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:employeeNumber": {
                    return "externalId";
                }
                case "nickName": {
                    return "azure_id";
                }
            }
        } else if (ScimProjectConstants.GRP_SCHEMA.equals(schema)) {
            switch (filter.key) {
                case "displayName": {
                    return CommonUtils.isAzureId(filter.value) ? "externalId" : "groupname";
                }
                case "externalId": {
                    return "externalId";
                }
            }
        }
        return null;
    }

    protected void applySort(Map<String, List<String>> params) {
        List<String> sortCol = params.get("sortBy");
        List<String> sortType = params.get("sortOrder");
        if (sortCol != null && sortCol.size() > 0) {
            String order = "asc";
            if (sortType != null && sortType.size() > 0) {
                if (sortType.get(0).equalsIgnoreCase("descending")) {
                    order = "desc";
                }
                this.orderBy.put(sortCol.get(0), order);
            }
        }
    }

    private static int getCount(Map<String, List<String>> params) {
        return Integer.parseInt(params.get("count").get(0));
    }

    private class Filter {
        String op;
        String key;
        String value;

        Filter(String filter) {
            String[] filterParts = filter.split(" ");
            this.key = filterParts[0].trim();
            this.op = filterParts[1].trim();
            this.value = filterParts[2].trim();
            if (this.value.charAt(0) == '\"') {
                this.value = this.value.substring(1, this.value.length() - 1);
            }
        }

        boolean eq() {
            return "eq".equals(this.op);
        }
    }
}

