/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.data;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import java.util.ArrayList;

public class Operation {
    public static final AttributeValueResolver<Operation> OPERATION_RESOLVER = new AttributeValueResolver<Operation>(){

        @Override
        public Operation toInstance(SCIMAttributeValue value) {
            return new Operation((String)value.getSubAttributeValue("op", STRING_RESOLVER), (String)value.getSubAttributeValue("path", STRING_RESOLVER), (String)value.getSubAttributeValue("value", STRING_RESOLVER));
        }

        @Override
        public SCIMAttributeValue fromInstance(AttributeDescriptor descriptor, Operation value) throws InvalidResourceException {
            ArrayList<SCIMAttribute> subAttributes = new ArrayList<SCIMAttribute>(3);
            if (value.op != null) {
                subAttributes.add(SCIMAttribute.create(descriptor.getSubAttribute("op"), SCIMAttributeValue.createStringValue(value.op)));
            }
            if (value.path != null) {
                subAttributes.add(SCIMAttribute.create(descriptor.getSubAttribute("path"), SCIMAttributeValue.createStringValue(value.path)));
            }
            if (value.value != null) {
                subAttributes.add(SCIMAttribute.create(descriptor.getSubAttribute("value"), SCIMAttributeValue.createStringValue(value.value)));
            }
            return SCIMAttributeValue.createComplexValue(subAttributes);
        }
    };
    private String op;
    private String path;
    private String value;

    public Operation(String op, String path, String value) {
        this.op = op;
        this.path = path;
        this.value = value;
    }

    public String getOp() {
        return this.op;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Operation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Operation(op=" + this.getOp() + ", path=" + this.getPath() + ", value=" + this.getValue() + ")";
    }
}

