/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.json;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.QueryRequest;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.json.JSONArray;
import com.unboundid.scim.json.JSONException;
import com.unboundid.scim.json.JSONObject;
import com.unboundid.scim.json.JSONTokener;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonBulkParser;
import com.unboundid.scim.marshal.json.JsonParser;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.ListResponse;
import com.unboundid.scim.sdk.PageParameters;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.ServerErrorException;
import com.unboundid.scim.sdk.SortParameters;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class JsonUnmarshaller
implements Unmarshaller {
    @Override
    public <R extends BaseResource> R unmarshal(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        try {
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            JsonParser parser = new JsonParser();
            return parser.unmarshal(jsonObject, resourceDescriptor, resourceFactory, null);
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public <R extends BaseResource> Resources<R> unmarshalResources(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        try {
            JsonParser parser = new JsonParser();
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            int totalResults = 0;
            if (jsonObject.has("totalresults")) {
                totalResults = jsonObject.getInt("totalresults");
            }
            int startIndex = 1;
            if (jsonObject.has("startindex")) {
                startIndex = jsonObject.getInt("startindex");
            }
            JSONArray schemas = jsonObject.optJSONArray("schemas");
            List resources = Collections.emptyList();
            if (jsonObject.has("resources")) {
                JSONArray resourcesArray = jsonObject.getJSONArray("resources");
                resources = new ArrayList(resourcesArray.length());
                for (int i = 0; i < resourcesArray.length(); ++i) {
                    JSONObject subObject = JsonParser.makeCaseInsensitive(resourcesArray.getJSONObject(i));
                    R resource = parser.unmarshal(subObject, resourceDescriptor, resourceFactory, schemas);
                    resources.add(resource);
                }
            }
            return new Resources(resources, totalResults, startIndex);
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public <R extends BaseResource> ListResponse<R> unmarshalListResponse(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        try {
            JsonParser parser = new JsonParser();
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            int totalResults = 0;
            if (jsonObject.has("totalresults")) {
                totalResults = jsonObject.getInt("totalresults");
            }
            List resources = Collections.emptyList();
            if (jsonObject.has("resources")) {
                JSONArray resourcesArray = jsonObject.getJSONArray("resources");
                resources = new ArrayList(resourcesArray.length());
                for (int i = 0; i < resourcesArray.length(); ++i) {
                    JSONObject subObject = JsonParser.makeCaseInsensitive(resourcesArray.getJSONObject(i));
                    R resource = parser.unmarshal(subObject, resourceDescriptor, resourceFactory, null);
                    resources.add(resource);
                }
            }
            ListResponse response = new ListResponse(resources, totalResults);
            JSONArray schemas = jsonObject.getJSONArray("schemas");
            for (int i = 0; i < schemas.length(); ++i) {
                String schema = schemas.getString(i);
                response.getSchemas().add(schema);
                JSONObject embeddedObject = jsonObject.optJSONObject(schema.toLowerCase());
                if (embeddedObject == null) continue;
                for (String attrName : JSONObject.getNames(embeddedObject)) {
                    response.setExtensionAttribute(schema, attrName, embeddedObject.get(attrName));
                }
            }
            return response;
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public QueryRequest unmarshalQueryRequest(InputStream inputStream) throws InvalidResourceException {
        try {
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            ArrayList<String> attributes = null;
            if (jsonObject.has("attributes")) {
                attributes = new ArrayList<String>();
                JSONArray attributesArray = jsonObject.getJSONArray("attributes");
                for (int i = 0; i < attributesArray.length(); ++i) {
                    attributes.add(attributesArray.getString(i));
                }
            }
            String filter = null;
            if (jsonObject.has("filter")) {
                filter = jsonObject.getString("filter");
            }
            int pageSize = 0;
            int startIndex = 0;
            if (jsonObject.has("count")) {
                pageSize = jsonObject.getInt("count");
            }
            if (jsonObject.has("startIndex")) {
                startIndex = jsonObject.getInt("startIndex");
            }
            String sortBy = null;
            String sortOrder = null;
            if (jsonObject.has("sortBy")) {
                sortBy = jsonObject.getString("sortBy");
            }
            if (jsonObject.has("sortOrder")) {
                sortOrder = jsonObject.getString("sortOrder");
            }
            QueryRequest queryRequest = new QueryRequest();
            queryRequest.setFilter(filter);
            queryRequest.setAttributes(attributes);
            if (pageSize >= 0 || startIndex >= 0) {
                queryRequest.setPageParameters(new PageParameters(startIndex, pageSize));
            }
            if (sortBy != null && sortOrder != null) {
                queryRequest.setSortParameters(new SortParameters(sortBy, sortOrder));
            }
            JSONArray schemas = jsonObject.getJSONArray("schemas");
            for (int i = 0; i < schemas.length(); ++i) {
                String schema = schemas.getString(i);
                queryRequest.getSchemas().add(schema);
                JSONObject embeddedObject = jsonObject.optJSONObject(schema.toLowerCase());
                if (embeddedObject == null) continue;
                for (String attrName : JSONObject.getNames(embeddedObject)) {
                    queryRequest.setExtensionAttribute(schema, attrName, embeddedObject.get(attrName));
                }
            }
            return queryRequest;
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public SCIMException unmarshalError(InputStream inputStream) throws InvalidResourceException {
        try {
            JSONArray errors;
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            if (jsonObject.has("errors") && (errors = jsonObject.getJSONArray("errors")).length() >= 1) {
                JSONObject error = errors.getJSONObject(0);
                int code = error.optInt("code");
                String description = error.optString("description");
                return SCIMException.createException(code, description);
            }
            return null;
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public void bulkUnmarshal(InputStream inputStream, BulkConfig bulkConfig, BulkContentHandler handler) throws SCIMException {
        JsonBulkParser bulkUnmarshaller = new JsonBulkParser(inputStream, bulkConfig, handler);
        bulkUnmarshaller.unmarshal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkUnmarshal(File file, BulkConfig bulkConfig, BulkContentHandler handler) throws SCIMException {
        final AtomicInteger failOnErrorsValue = new AtomicInteger(-1);
        BulkContentHandler preProcessHandler = new BulkContentHandler(){

            @Override
            public void handleFailOnErrors(int failOnErrors) {
                failOnErrorsValue.set(failOnErrors);
            }
        };
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            JsonBulkParser jsonBulkParser = new JsonBulkParser(bufferedInputStream, bulkConfig, preProcessHandler);
            jsonBulkParser.setSkipOperations(true);
            jsonBulkParser.unmarshal();
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Error pre-processing bulk request: " + e.getMessage());
        }
        int failOnErrors = failOnErrorsValue.get();
        if (failOnErrors != -1) {
            handler.handleFailOnErrors(failOnErrors);
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            JsonBulkParser jsonBulkParser = new JsonBulkParser(bufferedInputStream, bulkConfig, handler);
            jsonBulkParser.unmarshal();
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Error parsing bulk request: " + e.getMessage());
        }
    }
}

