/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.marshal.StreamMarshaller;
import com.unboundid.scim.marshal.json.JsonStreamMarshaller;
import com.unboundid.scim.marshal.xml.XmlStreamMarshaller;
import com.unboundid.scim.sdk.BulkOperation;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.DebugType;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMResponse;
import com.unboundid.scim.sdk.ServerErrorException;
import com.unboundid.scim.wink.RequestContext;
import com.unboundid.scim.wink.SCIMApplication;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;

public class BulkStreamResponse
implements SCIMResponse {
    private final File file;
    private final StreamMarshaller streamMarshaller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkStreamResponse(SCIMApplication application, RequestContext requestContext) throws SCIMException {
        BufferedOutputStream outputStream;
        try {
            this.file = File.createTempFile("scim-bulk-response-", "." + requestContext.getProduceMediaType().getSubtype(), application.getTmpDataDir());
            this.file.deleteOnExit();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ServerErrorException("Cannot create a temporary file for the bulk response" + e.getMessage());
        }
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (!this.file.delete()) {
                Debug.debug(Level.WARNING, DebugType.OTHER, "Could not delete temporary file " + this.file.getAbsolutePath());
            }
            throw new ServerErrorException("Cannot create output stream for temporary file '" + this.file + "': " + e.getMessage());
        }
        try {
            this.streamMarshaller = requestContext.getProduceMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonStreamMarshaller(outputStream) : new XmlStreamMarshaller(outputStream);
            Set<String> schemaURIs = Collections.singleton("urn:scim:schemas:core:1.0");
            this.streamMarshaller.writeBulkStart(-1, schemaURIs);
        }
        catch (SCIMException e) {
            Debug.debugException(e);
            try {
                ((OutputStream)outputStream).close();
            }
            catch (Exception e1) {
                Debug.debugException(e1);
            }
            finally {
                if (!this.file.delete()) {
                    Debug.debug(Level.WARNING, DebugType.OTHER, "Could not delete temporary file " + this.file.getAbsolutePath());
                }
            }
            throw e;
        }
    }

    public void writeBulkOperation(BulkOperation o) throws SCIMException {
        this.streamMarshaller.writeBulkOperation(o);
    }

    public void finalizeResponse() {
        if (this.file.exists() && !this.file.delete()) {
            Debug.debug(Level.WARNING, DebugType.OTHER, "Could not delete temporary file " + this.file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Marshaller marshaller, OutputStream outputStream) throws Exception {
        try {
            int bytesRead;
            this.streamMarshaller.writeBulkFinish();
            this.streamMarshaller.close();
            FileInputStream inputStream = new FileInputStream(this.file);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            this.finalizeResponse();
        }
    }
}

