/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.providers.entity.xml.AbstractJAXBProvider;
import org.apache.wink.common.internal.utils.GenericsUtils;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBCollectionProvider
extends AbstractJAXBProvider {
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final Logger logger = LoggerFactory.getLogger(AbstractJAXBCollectionProvider.class);

    public Object read(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        XMLStreamReader xsr = null;
        try {
            xsr = this.getXMLStreamReader(entityStream);
            Class<?> theType = AbstractJAXBCollectionProvider.getParameterizedTypeClassForRead(type, genericType, true);
            theType = this.getConcreteTypeFromTypeMap(theType, annotations);
            JAXBContext context = this.getContext(theType, mediaType);
            Unmarshaller unmarshaller = this.getJAXBUnmarshaller(type, context, mediaType);
            int nextEvent = xsr.getEventType();
            while (nextEvent != 1) {
                nextEvent = xsr.next();
            }
            ArrayList<Object> elementList = new ArrayList<Object>();
            nextEvent = xsr.next();
            block8: while (nextEvent != 8) {
                switch (nextEvent) {
                    case 1: {
                        Class<?> parameterizedTypeClass = AbstractJAXBCollectionProvider.getParameterizedTypeClassForRead(type, genericType, false);
                        if (parameterizedTypeClass == JAXBElement.class) {
                            elementList.add(unmarshaller.unmarshal(xsr, theType));
                        } else if (theType.isAnnotationPresent(XmlRootElement.class)) {
                            Object o = unmarshaller.unmarshal(xsr);
                            if ((o = this.unmarshalWithXmlAdapter(o, type, AbstractJAXBCollectionProvider.getParameterizedTypeClassForRead(type, genericType, false), annotations)) instanceof JAXBElement) {
                                o = ((JAXBElement)o).getValue();
                            }
                            elementList.add(o);
                        } else {
                            elementList.add(unmarshaller.unmarshal(xsr, theType).getValue());
                        }
                        nextEvent = xsr.getEventType();
                        continue block8;
                    }
                }
                nextEvent = xsr.next();
            }
            AbstractJAXBCollectionProvider.closeXMLStreamReader(xsr);
            AbstractCollection ret = null;
            ret = type.isArray() ? AbstractJAXBCollectionProvider.convertListToArray(theType, elementList) : (type == Set.class ? new HashSet<Object>(elementList) : elementList);
            this.releaseJAXBUnmarshaller(context, unmarshaller);
            return ret;
        }
        catch (XMLStreamException e) {
            AbstractJAXBCollectionProvider.closeXMLStreamReader(xsr);
            logger.error(Messages.getMessage("jaxbFailToUnmarshal", type.getName()), (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (JAXBException e) {
            AbstractJAXBCollectionProvider.closeXMLStreamReader(xsr);
            logger.error(Messages.getMessage("jaxbFailToUnmarshal", type.getName()), (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (RuntimeException e) {
            AbstractJAXBCollectionProvider.closeXMLStreamReader(xsr);
            throw e;
        }
    }

    public void write(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, mediaType);
        try {
            Class<?> adapterClass = AbstractJAXBCollectionProvider.getParameterizedTypeClassForWrite(type, genericType, true);
            Class<?> theType = this.getConcreteTypeFromTypeMap(adapterClass, annotations);
            Object[] elementArray = type.isArray() ? (Object[])t : ((Collection)t).toArray();
            QName qname = null;
            boolean isJAXBElement = false;
            if (elementArray.length > 0 && elementArray[0] instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)elementArray[0];
                qname = jaxbElement.getName();
                isJAXBElement = true;
            } else {
                qname = AbstractJAXBCollectionProvider.getJaxbQName(theType);
            }
            if (qname != null) {
                AbstractJAXBCollectionProvider.writeStartTag(qname, entityStream, mediaType);
            }
            Marshaller marshaller = null;
            JAXBContext context = null;
            for (Object o : elementArray) {
                o = this.marshalWithXmlAdapter(o, type, AbstractJAXBCollectionProvider.getParameterizedTypeClassForWrite(type, genericType, false), annotations);
                if (marshaller == null) {
                    Class oType = isJAXBElement ? ((JAXBElement)o).getDeclaredType() : o.getClass();
                    context = this.getContext(oType, mediaType);
                    marshaller = this.getJAXBMarshaller(oType, context, mediaType);
                    marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                    Charset charSet = AbstractJAXBCollectionProvider.getCharSet(mediaType);
                    marshaller.setProperty("jaxb.encoding", (Object)charSet.name());
                }
                Object entityToMarshal = this.getEntityToMarshal(o, AbstractJAXBCollectionProvider.getParameterizedTypeClassForWrite(type, genericType, false));
                if (qname == null) {
                    qname = entityToMarshal instanceof JAXBElement ? ((JAXBElement)entityToMarshal).getName() : new QName(entityToMarshal.getClass().getPackage().getName(), entityToMarshal.getClass().getSimpleName());
                    AbstractJAXBCollectionProvider.writeStartTag(qname, entityStream, mediaType);
                }
                marshaller.marshal(entityToMarshal, entityStream);
                this.releaseJAXBMarshaller(context, marshaller);
                marshaller = null;
            }
            AbstractJAXBCollectionProvider.writeEndTag(qname, entityStream);
        }
        catch (JAXBException e) {
            logger.error(Messages.getMessage("jaxbFailToMarshal", type.getName()), (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected static <T> Object convertListToArray(Class<T> type, List<Object> elementList) {
        Object[] ret = (Object[])Array.newInstance(type, elementList.size());
        for (int i = 0; i < elementList.size(); ++i) {
            ret[i] = elementList.get(i);
        }
        return ret;
    }

    protected static void writeStartTag(QName qname, OutputStream entityStream, MediaType m) throws IOException {
        String startTag = null;
        Charset charSet = AbstractJAXBCollectionProvider.getCharSet(m);
        startTag = "<?xml version=\"1.0\" encoding=\"" + charSet.name() + "\" standalone=\"yes\"?>";
        entityStream.write(startTag.getBytes());
        startTag = "<" + qname.getLocalPart() + "s>";
        entityStream.write(startTag.getBytes());
    }

    protected static Charset getCharSet(MediaType m) {
        String charSetString = (String)m.getParameters().get("charset");
        Charset charSet = charSetString == null ? Charset.forName("UTF-8") : Charset.forName(charSetString);
        return charSet;
    }

    protected static void writeEndTag(QName qname, OutputStream entityStream) throws IOException {
        String endTag = null;
        endTag = qname.getNamespaceURI().length() > 0 ? "</" + qname.getLocalPart() + "s>" : "</" + qname.getLocalPart() + "s>";
        entityStream.write(endTag.getBytes());
    }

    public static Class<?> getParameterizedTypeClassForRead(Class<?> type, Type genericType, boolean recurse) {
        if (Collection.class.isAssignableFrom(type)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (!(actualTypeArguments[0] instanceof ParameterizedType)) {
                    return (Class)actualTypeArguments[0];
                }
                parameterizedType = (ParameterizedType)actualTypeArguments[0];
                if (recurse) {
                    return AbstractJAXBCollectionProvider.getParameterizedTypeClassForRead(type, parameterizedType, recurse);
                }
                return (Class)parameterizedType.getRawType();
            }
            return GenericsUtils.getGenericParamType(genericType);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    public static Class<?> getParameterizedTypeClassForWrite(Class<?> type, Type genericType, boolean recurse) {
        if (Collection.class.isAssignableFrom(type)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (!(actualTypeArguments[0] instanceof ParameterizedType)) {
                    return (Class)actualTypeArguments[0];
                }
                parameterizedType = (ParameterizedType)actualTypeArguments[0];
                if (recurse) {
                    return AbstractJAXBCollectionProvider.getParameterizedTypeClassForRead(type, parameterizedType, recurse);
                }
                return (Class)parameterizedType.getRawType();
            }
            return GenericsUtils.getGenericParamType(genericType);
        }
        if (genericType != null) {
            Class<?> genericTypeClass = null;
            try {
                genericTypeClass = (Class<?>)genericType;
            }
            catch (ClassCastException cce) {
                genericTypeClass = genericType.getClass();
            }
            if (genericTypeClass.isArray()) {
                return genericTypeClass.getComponentType();
            }
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    protected static QName getJaxbQName(Class<?> cls) {
        XmlRootElement root = cls.getAnnotation(XmlRootElement.class);
        if (root != null) {
            String namespace = AbstractJAXBCollectionProvider.getNamespace(root.namespace());
            String name = AbstractJAXBCollectionProvider.getLocalName(root.name(), cls.getSimpleName());
            return new QName(namespace, name);
        }
        return null;
    }

    protected static String getLocalName(String name, String clsName) {
        if ("##default".equals(name)) {
            name = clsName;
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        }
        return name;
    }

    protected static String getNamespace(String namespace) {
        if ("##default".equals(namespace)) {
            return "";
        }
        return namespace;
    }
}

