/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.scim.ScimProjectConstants;

public class ScimNuxeoUserUtils {
    private static final Logger logger = LogManager.getLogger(ScimNuxeoUserUtils.class);
    private static final ThreadLocal<UserManager> umHolder = new ThreadLocal();
    private static final String docLabelTemplate = "%s %s/\"%s\"";
    public static String serverNameOverride = null;

    public static UserManager getUsrMgr() {
        if (umHolder.get() == null) {
            umHolder.set((UserManager)Framework.getService(UserManager.class));
        }
        return umHolder.get();
    }

    public static DocumentModel createUser(String nuxeoLogin) {
        return ScimNuxeoUserUtils.createUser(nuxeoLogin, null);
    }

    public static DocumentModel createUser(String nuxeoLogin, Map<String, Object> propertyMap) {
        DocumentModel userDoc;
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel user = userManager.getBareUserModel();
        user.setPropertyValue(userManager.getUserIdField(), (Serializable)((Object)nuxeoLogin));
        if (propertyMap != null) {
            for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
                user.setPropertyValue(entry.getKey(), (Serializable)entry.getValue());
            }
        }
        try {
            userDoc = ScimNuxeoUserUtils.getUsrMgr().createUser(user);
        }
        catch (NuxeoException e) {
            logger.error("Error while creating user " + nuxeoLogin + "in UserManager", (Throwable)e);
            return null;
        }
        return userDoc;
    }

    public static DocumentModel createGroup(String name, List<String> users) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel groupDoc = userManager.getBareGroupModel();
        groupDoc.setPropertyValue("groupname", (Serializable)((Object)name));
        if (users != null) {
            groupDoc.setProperty(userManager.getGroupSchemaName(), userManager.getGroupMembersField(), users);
        }
        return (DocumentModel)Framework.doPrivileged(() -> userManager.createGroup(groupDoc));
    }

    public static void addUserToGroups(String user, Collection<String> groups) {
        logger.debug("add user {} to the following groups {}", (Object)user, groups);
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        NuxeoPrincipal userPrincipal = userManager.getPrincipal(user);
        if (userPrincipal == null) {
            logger.error("User does not exist {}. Can not add to group", (Object)user);
            return;
        }
        List existing = userPrincipal.getAllGroups();
        for (String group : groups) {
            if (!existing.contains(group)) {
                NuxeoGroup nuxeoGroup = userManager.getGroup(group);
                if (nuxeoGroup != null) {
                    ScimNuxeoUserUtils.addUserToGroup(nuxeoGroup, user);
                    continue;
                }
                logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)user, (Object)group);
                continue;
            }
            logger.trace("User {} is already part of group {}. Skipping", (Object)user, (Object)group);
        }
    }

    public static void removeUserFromGroups(List<String> groups, String userNameId) {
        if (!groups.isEmpty()) {
            for (String group : groups) {
                ScimNuxeoUserUtils.removeUserFromGroup(group, userNameId);
            }
        }
    }

    public static NuxeoGroup removeUserFromGroup(String group, String userNameId) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        NuxeoGroup nuxeoGroup = (NuxeoGroup)Framework.doPrivileged(() -> userManager.getGroup(group));
        if (nuxeoGroup != null) {
            ScimNuxeoUserUtils.removeUserFromGroup(nuxeoGroup, userNameId);
        } else {
            logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)userNameId, (Object)group);
        }
        return nuxeoGroup;
    }

    public static void addUserToGroups(String user, String ... groupNames) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        List existing = userManager.getPrincipal(user).getAllGroups();
        for (String group : groupNames) {
            if (existing.contains(group)) continue;
            NuxeoGroup nuxeoGroup = (NuxeoGroup)Framework.doPrivileged(() -> userManager.getGroup(group));
            if (nuxeoGroup != null) {
                ScimNuxeoUserUtils.addUserToGroup(nuxeoGroup, user);
                continue;
            }
            logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)user, (Object)group);
        }
    }

    public static NuxeoGroup addUsersToGroup(String group, String ... userNames) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        NuxeoGroup nuxeoGroup = userManager.getGroup(group);
        if (nuxeoGroup != null) {
            for (String user : userNames) {
                ScimNuxeoUserUtils.addUserToGroup(nuxeoGroup, user);
            }
        } else {
            logger.warn("Could NOT add user [{}] to group [{}] as this group does not exist", (Object)userNames, (Object)group);
        }
        return nuxeoGroup;
    }

    public static List<String> getGroupMembers(String group) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        return userManager.getUsersInGroupAndSubGroups(group);
    }

    public static List<String> getUsersInGroup(String group) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        return userManager.getUsersInGroup(group);
    }

    public static List<String> getSubGroups(String group) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        return (List)Framework.doPrivileged(() -> userManager.getDescendantGroups(group));
    }

    public static List<String> getParentGroups(String group) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        return (List)Framework.doPrivileged(() -> userManager.getGroup(group).getParentGroups());
    }

    public static List<String> getUserGroups(String user) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        return (List)Framework.doPrivileged(() -> {
            NuxeoPrincipal user1 = userManager.getPrincipal(user);
            if (user1 == null) {
                logger.error("user {} does not exist", (Object)user);
            }
            return user1.getGroups();
        });
    }

    public static void addUserToGroup(NuxeoGroup group, String userNameId) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        List users = userManager.getUsersInGroupAndSubGroups(group.getName());
        if (!users.contains(userNameId)) {
            logger.debug("Add " + userNameId + " to group [" + group.getName() + "]");
            users.add(userNameId);
            ScimNuxeoUserUtils.updateGroup(group, users);
        } else {
            logger.warn("User [" + userNameId + "] is already in group [" + group.getName() + "]");
        }
    }

    public static void removeUserFromGroup(NuxeoGroup group, String userNameId) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        List users = userManager.getUsersInGroupAndSubGroups(group.getName());
        if (users.contains(userNameId)) {
            logger.debug("Removing user " + userNameId + " from group " + group.getName());
            users.remove(userNameId);
            ScimNuxeoUserUtils.updateGroup(group, users);
        } else {
            logger.debug("User " + userNameId + " is not in group " + group.getName());
        }
    }

    public static void updateGroup(NuxeoGroup group, List<String> users) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel groupDoc = group.getModel();
        groupDoc.setProperty(ScimProjectConstants.GRP_SCHEMA, ScimProjectConstants.GROUP_MEMBERS, users);
        userManager.updateGroup(groupDoc);
    }

    public static void addSubGroups(NuxeoGroup group, List<String> subgroups) {
        UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel groupDoc = group.getModel();
        List existingSubGroups = group.getMemberGroups();
        existingSubGroups.addAll(subgroups);
        groupDoc.setProperty(userManager.getGroupSchemaName(), userManager.getGroupSubGroupsField(), (Object)existingSubGroups);
        Framework.doPrivileged(() -> userManager.updateGroup(groupDoc));
    }

    public static DocumentModel getUserById(String userId) {
        try {
            UserManager userManager = ScimNuxeoUserUtils.getUsrMgr();
            HashMap<String, String> query = new HashMap<String, String>();
            query.put(userManager.getUserIdField(), userId);
            DocumentModelList users = (DocumentModelList)Framework.doPrivileged(() -> userManager.searchUsers(query, null));
            if (users.isEmpty()) {
                return null;
            }
            return (DocumentModel)users.get(0);
        }
        catch (NuxeoException e) {
            logger.error("Error while search user in UserManager using ID " + userId, (Throwable)e);
            return null;
        }
    }

    public static void raiseException(String errMsg) {
        logger.error(errMsg);
        TransactionHelper.setTransactionRollbackOnly();
        throw new NuxeoException(errMsg);
    }

    public static String getConfigProperty(String name) {
        return Framework.getProperty((String)name);
    }

    public static boolean booleanConfig(String name) {
        String prop = Framework.getProperty((String)name);
        if (prop == null) {
            return false;
        }
        return (prop = prop.trim().toLowerCase()).equals("true") || prop.equals("1") || prop.equals("yes") || prop.equals("da") || prop.equals("oui");
    }

    public static void sendEvent(CoreSession session, String name) {
        EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        EventContextImpl ctx = new EventContextImpl(session, session.getPrincipal());
        Event event = ctx.newEvent(name);
        eventProducer.fireEvent(event);
    }

    public static String docLabel(DocumentModel doc) {
        if (doc == null) {
            return "n/a";
        }
        return String.format(docLabelTemplate, doc.getType(), doc.getId(), doc.getName());
    }

    public static void setServerNameOverride(String serverName) {
        serverNameOverride = serverName;
    }

    public static String serverName() {
        return StringUtils.isNotEmpty((CharSequence)serverNameOverride) ? serverNameOverride : Framework.getProperty((String)"nuxeo.server_name");
    }

    protected static boolean isProd(String serverName) {
        return "PROD".equals(serverName);
    }

    protected static boolean isProdGroup(String orgGroupName) {
        String uC = orgGroupName.toUpperCase(Locale.ROOT);
        for (String env : ScimProjectConstants.ENV_NON_PROD) {
            if (!uC.endsWith("_" + env)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isNonProdGroup(String orgGroupName) {
        return !ScimNuxeoUserUtils.isProdGroup(orgGroupName);
    }

    public static boolean hasServerSuffix(String orgGroupName) {
        String serverName = ScimNuxeoUserUtils.serverName();
        if (StringUtils.isEmpty((CharSequence)serverName)) {
            logger.warn("ServerName is empty. We do not know environment type. Could not get group name for {}", (Object)orgGroupName);
        }
        String uC = orgGroupName.toUpperCase(Locale.ROOT);
        String suffix = "_" + serverName.toUpperCase(Locale.ROOT);
        return uC.endsWith(suffix);
    }

    public static String serverSpecificGroupName(String orgGroupName) {
        String suffix;
        String serverName = ScimNuxeoUserUtils.serverName();
        if (StringUtils.isEmpty((CharSequence)orgGroupName)) {
            logger.warn("Original Group Name is empty. Could not get a group name for server {}", (Object)serverName);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)serverName)) {
            logger.warn("ServerName is empty. We do not know environment type. Could not get group name for {}", (Object)orgGroupName);
            return null;
        }
        String uC = orgGroupName.toUpperCase(Locale.ROOT);
        Boolean noSuffixForProd = Boolean.valueOf(Framework.getProperty((String)"nuxeo.scim.use_prod_groups_without_suffix"));
        if (noSuffixForProd.booleanValue()) {
            if (ScimNuxeoUserUtils.isProdGroup(orgGroupName)) {
                return orgGroupName;
            }
            if (ScimNuxeoUserUtils.isProd(serverName)) {
                return null;
            }
        }
        if (!uC.endsWith(suffix = "_" + serverName.toUpperCase(Locale.ROOT))) {
            return null;
        }
        return orgGroupName.substring(0, uC.lastIndexOf(suffix));
    }
}

