/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.PatchResource;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.wink.PATCH;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.ScimNuxeoUserUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.scim.ScimProjectConstants;
import org.nuxeo.scim.server.WebException;
import org.nuxeo.scim.server.jaxrs.marshalling.UserResponse;
import org.nuxeo.scim.server.jaxrs.usermanager.BaseUMEndpoint;
import org.nuxeo.scim.server.jaxrs.usermanager.SortFilterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebObject(type="users")
@Produces(value={"application/json", "application/xml"})
public class SCIMUserEndpoint
extends BaseUMEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SCIMUserEndpoint.class);
    private static final Logger logger = LoggerFactory.getLogger(SCIMUserEndpoint.class);

    @Override
    protected String getPrefix() {
        return "/Users";
    }

    @GET
    @Produces(value={"application/json", "application/xml; qs=0.9"})
    public Resources<UserResource> getUsers(@Context UriInfo uriInfo) {
        logger.debug("getUsers uriInfo:{}", (Object)uriInfo);
        SortFilterContext context = new SortFilterContext(uriInfo, ScimProjectConstants.USR_SCHEMA);
        try {
            DocumentModelList userModels = this.query(ScimProjectConstants.USR_DR, context);
            logger.debug("Users: {}", (Object)userModels.size());
            ArrayList<UserResource> userResources = new ArrayList<UserResource>(userModels.size());
            for (DocumentModel userModel : userModels) {
                try {
                    userResources.add(this.mapper.getUserResourceFromUserModel(userModel));
                }
                catch (Throwable e) {
                    log.error("Can not map user " + userModel.getId(), e);
                }
            }
            return new Resources(userResources, userResources.size(), context.startIndex);
        }
        catch (Throwable e) {
            log.error("Can not get users", e);
            throw WebException.wrap(e);
        }
    }

    @Path(value="{uid}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    public UserResource getUserResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            return this.resolveUserResource(uid);
        }
        catch (Exception e) {
            logger.error("Error while getting Users", (Throwable)e);
            throw WebException.wrap(e);
        }
    }

    @Path(value="{uid}.xml")
    @GET
    @Produces(value={"application/xml"})
    public UserResource getUserResourceAsXml(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getUserResource(uriInfo, uid);
    }

    @Path(value="{uid}.json")
    @GET
    @Produces(value={"application/json"})
    public UserResource getUserResourceAsJSON(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        return this.getUserResource(uriInfo, uid);
    }

    @POST
    @Consumes(value={"application/json", "application/scim+json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response createUser(UserResource user) {
        logger.debug("Create user {}, fixeMediaType={}", (Object)user, (Object)this.fixeMediaType);
        if (user == null) {
            logger.warn("Input user is not submitted or incorrect format to create user");
            throw new NuxeoException("Input user is not submitted or incorrect format to create user");
        }
        return this.doCreateUserResponse(user, this.fixeMediaType);
    }

    @PATCH
    @Path(value="{uid}")
    @Consumes(value={"application/xml", "application/json", "application/scim+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response patchUser(@Context UriInfo uriInfo, @PathParam(value="uid") String uid, PatchResource patch) {
        logger.debug("patchUser {}/{}", (Object)uid, (Object)this.fixeMediaType);
        return this.doPatchUser(uid, patch, this.fixeMediaType);
    }

    @PUT
    @Path(value="{uid}")
    @Consumes(value={"application/xml", "application/json", "application/scim+json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateUser(@Context UriInfo uriInfo, @PathParam(value="uid") String uid, UserResource user) {
        logger.debug("updateUser {}/{}", (Object)uid, (Object)this.fixeMediaType);
        if (user == null) {
            logger.warn("Input user is not submitted or incorrect format to update user");
            throw new NuxeoException("Input user is not submitted or incorrect format to update user");
        }
        try {
            this.checkUpdateGuardPreconditions();
            return this.doUpdateUser(uid, user, this.fixeMediaType);
        }
        catch (Throwable e) {
            throw WebException.wrap(e);
        }
    }

    protected Response doCreateUserResponse(UserResource user, MediaType mt) {
        logger.debug("doCreateUserResponse");
        try {
            this.checkUpdateGuardPreconditions();
            return UserResponse.created(this.doCreateUser(user), mt);
        }
        catch (Throwable e) {
            logger.error("Can not create user", e);
            throw WebException.wrap(e);
        }
    }

    protected Response doPatchUser(String uid, PatchResource patch, MediaType mt) {
        logger.debug("doPatchUser uid:{}, type:{}, sub:{}", new Object[]{uid, mt.getType(), mt.getSubtype()});
        if (patch == null) {
            log.warn("Patch is empty (probably wrong JSON schema. Must be urn:ietf:params:scim:api:messages:2.0:PatchOp");
            return Response.status((int)400).entity((Object)("Bad PATCH request for user" + uid)).build();
        }
        DocumentModel userModel = this.mapper.patchUser(uid, patch);
        if (userModel != null) {
            UserResource userResource = this.mapper.getUserResourceFromUserModel(userModel);
            return UserResponse.updated(userResource, mt);
        }
        return Response.status((int)404).entity((Object)("User " + uid + " not found for PATCH request")).build();
    }

    protected Response doUpdateUser(String uid, UserResource user, MediaType mt) {
        logger.debug("doUpdateUser {}, {}/{}", new Object[]{uid, mt.getType(), mt.getSubtype()});
        DocumentModel userModel = this.mapper.updateUserModelFromUserResource(uid, user);
        if (userModel != null) {
            UserResource userResource = this.mapper.getUserResourceFromUserModel(userModel);
            return UserResponse.updated(userResource, mt);
        }
        return Response.status((int)400).entity((Object)("User not found " + uid)).build();
    }

    @Path(value="{uid}")
    @DELETE
    public Response deleteUserResource(@Context UriInfo uriInfo, @PathParam(value="uid") String uid) {
        try {
            UserManager um = ScimNuxeoUserUtils.getUsrMgr();
            um.deleteUser(uid);
            return Response.ok().build();
        }
        catch (DirectoryException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    protected UserResource doCreateUser(UserResource user) {
        logger.debug("doCreateUser");
        DocumentModel newUser = this.mapper.createUserModelFromUserResource(user);
        UserResource resource = this.mapper.getUserResourceFromUserModel(newUser);
        return resource;
    }

    protected UserResource resolveUserResource(String uid) {
        logger.debug("resolveUserResource {}", (Object)uid);
        UserManager um = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel != null) {
            logger.debug("User was found by uid {}", (Object)uid);
            return this.mapper.getUserResourceFromUserModel(userModel);
        }
        logger.warn("User not found by uid {}", (Object)uid);
        return null;
    }
}

