/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.scim.server.jaxrs.usermanager;

import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.GroupResource;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.Operation;
import com.unboundid.scim.data.PatchResource;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.CoreSchema;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.ScimNuxeoUserUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.scim.ScimProjectConstants;
import org.nuxeo.scim.server.jaxrs.usermanager.GroupMapperHelper;
import org.nuxeo.scim.server.jaxrs.usermanager.UserMapperHelper;
import org.nuxeo.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMapper {
    private static final Logger log = LoggerFactory.getLogger(UserMapper.class);
    static Map<String, String> USR_SCIM2NUXEO = CommonUtils.stringMap("title", "job_title", "emails[type eq \"work\"]", "email", "business_phones", "business_phones", "phoneNumbers[type eq \"mobile\"].value", "mobile_phone", "phoneNumbers[type eq \"work\"].value", "business_phones", "externalId", "externalId", "nickName", "azure_id");
    static Map<String, String> GRP_SCIM2NUXEO = CommonUtils.stringMap("externalId", "externalId", "displayName", ScimProjectConstants.GROUP_LABEL);
    protected final String baseUrl;

    public UserMapper(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public GroupResource getGroupResourceFromGroupModel(DocumentModel groupModel) {
        String groupId = GroupMapperHelper.grpVal(groupModel, ScimProjectConstants.GROUP_ID);
        String name = GroupMapperHelper.grpVal(groupModel, ScimProjectConstants.GROUP_LABEL);
        log.debug("getGroupResourceFromGroupModel id:{} name:{}", (Object)groupId, (Object)name);
        GroupResource groupResource = new GroupResource(CoreSchema.GROUP_DESCRIPTOR);
        groupResource.setDisplayName(name);
        groupResource.setId(groupId);
        groupResource.setExternalId(GroupMapperHelper.grpVal(groupModel, "externalId"));
        groupResource.setMeta(UserMapperHelper.usrMeta(groupId, this.baseUrl));
        List<String> members = ScimNuxeoUserUtils.getUsersInGroup(groupId);
        if (members != null) {
            log.debug("grp:{} members:{}", (Object)groupId, (Object)members.size());
            Collection scimMembers = members.stream().map(member -> new Entry(member, "member")).collect(Collectors.toList());
            groupResource.setMembers(scimMembers);
        }
        return groupResource;
    }

    public UserResource getUserResourceFromUserModel(DocumentModel userModel) {
        log.debug("getUserResourceFromUserModel {}", (Object)userModel.getId());
        UserResource userResource = new UserResource(CoreSchema.USER_DESCRIPTOR);
        String userId = UserMapperHelper.usrVal(userModel, ScimProjectConstants.USR_ID);
        userResource.setUserName(userId);
        userResource.setId(userId);
        userResource.setExternalId(UserMapperHelper.usrVal(userModel, "externalId"));
        userResource.setNickName(UserMapperHelper.usrVal(userModel, "azure_id"));
        userResource.setTitle(UserMapperHelper.usrVal(userModel, "job_title"));
        userResource.setPhoneNumbers(UserMapperHelper.getPhones(userModel));
        userResource.setEmails(UserMapperHelper.getEmails(userModel));
        userResource.setDisplayName(UserMapperHelper.usrDisplayName(userModel));
        userResource.setSingularAttributeValue("urn:scim:schemas:core:1.0", "name", Name.NAME_RESOLVER, (Object)UserMapperHelper.usrFullName(userModel));
        userResource.setGroups(UserMapperHelper.getGroups(userId));
        userResource.setMeta(UserMapperHelper.usrMeta(userId, this.baseUrl));
        return userResource;
    }

    public DocumentModel createUserModelFromUserResource(UserResource user) throws ClientException {
        String userId = user.getId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            if (StringUtils.isEmpty((CharSequence)user.getUserName())) {
                throw new NuxeoException("No user name/id");
            }
            userId = user.getUserName();
            log.warn("No user ID provided, use name {}", (Object)userId);
        }
        UserManager um = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel newUser = um.getBareUserModel();
        log.debug("new user w/id:{}", (Object)userId);
        UserMapperHelper.usrVal(newUser, ScimProjectConstants.USR_ID, userId);
        this.updateUserModel(newUser, user);
        DocumentModel userModel = um.createUser(newUser);
        ScimNuxeoUserUtils.addUsersToGroup("members", userId);
        if (user.getGroups() != null) {
            Set<String> groups = user.getGroups().stream().map(Entry::getValue).map(ScimNuxeoUserUtils::serverSpecificGroupName).filter(x -> !ObjectUtils.isEmpty((Object)x)).collect(Collectors.toSet());
            ScimNuxeoUserUtils.addUserToGroups(userModel.getId(), groups);
        }
        return userModel;
    }

    public DocumentModel createGroupModelFromGroupResource(GroupResource group) throws ClientException {
        UserManager um;
        String groupId = group.getId();
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            groupId = group.getDisplayName();
        }
        if ((um = ScimNuxeoUserUtils.getUsrMgr()).getGroup(groupId) == null) {
            DocumentModel newGroup = um.getBareGroupModel();
            GroupMapperHelper.grpVal(newGroup, ScimProjectConstants.GROUP_ID, groupId);
            this.updateGroupModel(newGroup, group);
            return um.createGroup(newGroup);
        }
        log.warn("Group exists {}", (Object)groupId);
        return this.updateGroupModelFromGroupResource(groupId, group);
    }

    public DocumentModel patchUser(String uid, PatchResource patch) {
        log.debug("patchUser");
        UserManager um = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel doc = um.getUserModel(uid);
        if (doc == null) {
            log.warn("User not found {}", (Object)uid);
            return null;
        }
        PatchUpdater updater = op -> this.userOp(doc, op);
        if (this.patch(uid, patch, updater) > 0) {
            UserMapperHelper.usrVal(doc, "scim_updated", Calendar.getInstance());
            um.updateUser(doc);
        }
        return doc;
    }

    public DocumentModel patchGroup(String uid, PatchResource patch) {
        log.debug("patchGroup");
        UserManager um = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel doc = um.getGroupModel(uid);
        if (doc == null) {
            log.warn("Group not found {}", (Object)uid);
            return null;
        }
        PatchUpdater updater = op -> this.groupOp(doc, op);
        if (this.patch(uid, patch, updater) > 0) {
            log.debug("save group");
            GroupMapperHelper.grpVal(doc, "scim_updated", Calendar.getInstance());
            um.updateGroup(doc);
        }
        return doc;
    }

    public int patch(String uid, PatchResource patch, PatchUpdater updater) throws ClientException {
        int countOfOperations;
        int n = countOfOperations = patch.getOperations() != null ? patch.getOperations().size() : 0;
        if (countOfOperations == 0) {
            log.warn("No PATCH operations for {}", (Object)uid);
            return 0;
        }
        log.debug("");
        log.debug("{} patch operations for {}", (Object)countOfOperations, (Object)uid);
        log.debug("------------------------------------------------------------------");
        AtomicInteger cnt = new AtomicInteger();
        patch.getOperations().forEach(x -> cnt.addAndGet(updater.op((Operation)x) ? 1 : 0));
        log.debug("completed {} out of {} patch operations for {}", new Object[]{cnt, countOfOperations, uid});
        return cnt.get();
    }

    private boolean userOp(DocumentModel userModel, Operation op) {
        String opType = op.getOp();
        String scimField = op.getPath();
        String value = op.getValue();
        log.debug("user op:{}, field:{}, value:{}", new Object[]{opType, scimField, value});
        if ("Remove".equals(opType)) {
            log.warn("Remove op is not supported usr {}", (Object)scimField);
            return false;
        }
        if ("displayName".equalsIgnoreCase(scimField)) {
            UserMapperHelper.replaceDisplayName(userModel, value);
            return true;
        }
        String nuxeoField = USR_SCIM2NUXEO.get(scimField);
        if (nuxeoField != null) {
            UserMapperHelper.usrVal(userModel, nuxeoField, value);
            return true;
        }
        log.debug("Property {} operation {} is not supported ", (Object)scimField, (Object)opType);
        return false;
    }

    private boolean groupOp(DocumentModel grp, Operation op) {
        String group = grp.getId();
        String opType = op.getOp();
        String scimField = op.getPath();
        String value = op.getValue();
        log.debug("group:{}, op:{}, field:{}, value:{}", new Object[]{group, opType, scimField, value});
        if ("members".equals(scimField)) {
            log.debug("grp:{} op:{} members:{}", new Object[]{group, opType, value});
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return GroupMapperHelper.patchMembers(grp, opType, value);
            }
        }
        if ("Remove".equals(opType)) {
            log.warn("Remove op is not supported grp {}", (Object)scimField);
            return false;
        }
        String nuxeoField = GRP_SCIM2NUXEO.get(scimField);
        if (nuxeoField != null) {
            GroupMapperHelper.grpVal(grp, nuxeoField, value);
            return true;
        }
        return false;
    }

    public DocumentModel updateUserModelFromUserResource(String uid, UserResource user) throws ClientException {
        log.debug("updateUserModelFromUserResource {}", (Object)uid);
        UserManager um = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel userModel = um.getUserModel(uid);
        if (userModel == null) {
            log.warn("User not found {}", (Object)uid);
            return null;
        }
        this.updateUserModel(userModel, user);
        um.updateUser(userModel);
        List<String> nuxeoGroups = UserMapper.getRegularGroups(uid);
        if (!nuxeoGroups.contains("members")) {
            log.debug("Add {} to {} group", (Object)uid, (Object)"members");
            ScimNuxeoUserUtils.addUsersToGroup("members", uid);
        }
        List<String> restrictedGroups = UserMapper.getRestrictedGroups(uid);
        if (user.getGroups() != null) {
            Set<String> groups = user.getGroups().stream().map(Entry::getValue).map(ScimNuxeoUserUtils::serverSpecificGroupName).filter(x -> !ObjectUtils.isEmpty((Object)x)).collect(Collectors.toSet());
            ScimNuxeoUserUtils.addUserToGroups(userModel.getId(), groups);
            restrictedGroups.removeAll(groups);
            ScimNuxeoUserUtils.removeUserFromGroups(restrictedGroups, userModel.getId());
        }
        return userModel;
    }

    public static List<String> getRestrictedGroups(String user) {
        return ScimNuxeoUserUtils.getUserGroups(user).stream().filter(group -> group.startsWith("gRestricted_Nuxeo_")).collect(Collectors.toList());
    }

    public static List<String> getRegularGroups(String user) {
        return ScimNuxeoUserUtils.getUserGroups(user).stream().filter(group -> !group.startsWith("gRestricted_Nuxeo_")).collect(Collectors.toList());
    }

    protected void updateUserModel(DocumentModel userModel, UserResource userResource) throws ClientException {
        log.debug("updateUserModel {}", (Object)userResource.getUserName());
        CommonUtils.logUserResource(userResource);
        UserMapperHelper.usrVal(userModel, "job_title", userResource.getTitle());
        UserMapperHelper.usrVal(userModel, "externalId", userResource.getExternalId());
        UserMapperHelper.usrVal(userModel, "azure_id", userResource.getNickName());
        UserMapperHelper.usrVal(userModel, "scim_updated", Calendar.getInstance());
        UserMapperHelper.replaceDisplayName(userModel, userResource.getDisplayName());
        UserMapperHelper.updateEmails(userModel, userResource.getEmails());
        UserMapperHelper.updatePhones(userModel, userResource.getPhoneNumbers());
    }

    public DocumentModel updateGroupModelFromGroupResource(String uid, GroupResource group) throws ClientException {
        log.debug("updateGroupModelFromGroupResource | {}", (Object)uid);
        UserManager um = ScimNuxeoUserUtils.getUsrMgr();
        DocumentModel groupModel = um.getGroupModel(uid);
        if (groupModel == null) {
            log.warn("Group not found {}", (Object)uid);
            return null;
        }
        this.updateGroupModel(groupModel, group);
        um.updateGroup(groupModel);
        return groupModel;
    }

    protected void updateGroupModel(DocumentModel grp, GroupResource groupResource) throws ClientException {
        log.debug("updateGroupModel");
        CommonUtils.logGroupResource(groupResource);
        GroupMapperHelper.grpVal(grp, "externalId", groupResource.getExternalId());
        GroupMapperHelper.grpVal(grp, "scim_updated", Calendar.getInstance());
        String displayName = groupResource.getDisplayName();
        if (StringUtils.isNotEmpty((CharSequence)displayName)) {
            GroupMapperHelper.grpVal(grp, ScimProjectConstants.GROUP_LABEL, displayName);
        }
        if (groupResource.getMembers() != null) {
            GroupMapperHelper.updateMembers(grp, groupResource.getMembers().stream().map(Entry::getValue).collect(Collectors.toList()));
        }
    }

    static interface PatchUpdater {
        public boolean op(Operation var1);
    }
}

