/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.utils.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Injectable {
    private final ParamType paramType;
    private final Class<?> type;
    private final Type genericType;
    private final Member member;
    private Annotation[] annotations;

    protected Injectable(ParamType paramType, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
        this.paramType = paramType;
        this.type = type;
        this.genericType = genericType;
        this.annotations = annotations;
        this.member = member;
    }

    public Class<?> getType() {
        return this.type;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    protected boolean isTypeOf(Class<?> typeOf) {
        return this.type.equals(typeOf);
    }

    protected boolean isTypeCollectionOf(Class<?> collectionType) {
        return (this.type.equals(List.class) || this.type.equals(Set.class) || this.type.equals(SortedSet.class)) && collectionType.equals(GenericsUtils.getGenericParamType(this.genericType));
    }

    protected <T> Collection<T> elementAsTypeCollection(T object, Comparator<T> comparator) {
        return this.asTypeCollection(Collections.nCopies(1, object), comparator);
    }

    protected <T> Collection<T> asTypeCollection(Collection<T> collection, Comparator<T> comparator) {
        if (this.type.equals(List.class)) {
            return new ArrayList<T>(collection);
        }
        if (this.type.equals(Set.class)) {
            return new LinkedHashSet<T>(collection);
        }
        if (this.type.equals(SortedSet.class)) {
            TreeSet<T> treeSet = new TreeSet<T>(comparator);
            treeSet.addAll(collection);
            return treeSet;
        }
        return null;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Member getMember() {
        return this.member;
    }

    public abstract Object getValue(RuntimeContext var1) throws IOException;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Injectable [paramType=").append((Object)this.paramType).append(", type=").append(this.type).append(", genericType=").append(this.genericType).append(", member=").append(this.member).append(", annotations=").append(Arrays.toString(this.annotations)).append("]");
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParamType {
        ENTITY,
        CONTEXT,
        PATH,
        QUERY,
        MATRIX,
        FORM,
        HEADER,
        COOKIE;

    }
}

