/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.request.MultipartRequest;
import org.richfaces.event.FileUploadListener;
import org.richfaces.event.UploadAjaxActionEvent;
import org.richfaces.event.UploadEvent;
import org.richfaces.renderkit.FileUploadRendererBase;

public abstract class UIFileUpload
extends UIInput {
    public static final String COMPONENT_TYPE = "org.richfaces.component.FileUpload";
    public static final String COMPONENT_FAMILY = "org.richfaces.component.FileUpload";
    private String localContentType;
    private String localFileName;
    private Integer localFileSize;
    private InputStream localInputStream;

    private void setupProgressBarValueExpression(FacesContext context, String uid) {
        FileUploadRendererBase renderer = (FileUploadRendererBase)this.getRenderer(context);
        UIComponent progressBar = renderer.getProgressBar(context, (UIComponent)this);
        String percentExpression = "_richfaces_upload_percents['" + uid + "']";
        ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
        ELContext elContext = context.getELContext();
        ValueExpression value = expressionFactory.createValueExpression(elContext, "#{" + percentExpression + "}", Integer.class);
        progressBar.setValueExpression("value", value);
        ValueExpression enabled = expressionFactory.createValueExpression(elContext, "#{" + percentExpression + " < 100}", Boolean.class);
        progressBar.setValueExpression("enabled", enabled);
    }

    public String getLocalContentType() {
        return this.localContentType;
    }

    public void setLocalContentType(String localContentType) {
        this.localContentType = localContentType;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
    }

    public Integer getLocalFileSize() {
        return this.localFileSize;
    }

    public void setLocalFileSize(Integer localFileSize) {
        this.localFileSize = localFileSize;
    }

    public InputStream getLocalInputStream() {
        return this.localInputStream;
    }

    public void setLocalInputStream(InputStream localInputStream) {
        this.localInputStream = localInputStream;
    }

    public abstract void setAcceptedTypes(String var1);

    public abstract String getAcceptedTypes();

    public abstract Integer getMaxFilesQuantity();

    public abstract void setMaxFilesQuantity(Integer var1);

    public abstract String getListHeight();

    public abstract void setListHeight(String var1);

    public abstract String getListWidth();

    public abstract void setListWidth(String var1);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);

    public abstract Object getLocale();

    public abstract void setLocale(Object var1);

    public abstract MethodBinding getFileUploadListener();

    public abstract void setFileUploadListener(MethodBinding var1);

    public void addFileUploadListener(FileUploadListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public FileUploadListener[] getFileUploadListeners() {
        return (FileUploadListener[])this.getFacesListeners(FileUploadListener.class);
    }

    public void removeFileUploadListener(FileUploadListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void reset() {
        this.localContentType = null;
        this.localContentType = null;
        this.localFileName = null;
        this.localFileSize = null;
        this.localInputStream = null;
    }

    public void broadcast(FacesEvent e) {
        if (e instanceof UploadEvent) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            MethodBinding binding = this.getFileUploadListener();
            if (binding != null) {
                binding.invoke(facesContext, new Object[]{e});
            }
        } else if (e instanceof UploadAjaxActionEvent) {
            MultipartRequest multipartRequest;
            UploadAjaxActionEvent uploadActionEvent = (UploadAjaxActionEvent)e;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            AjaxContext ajaxContext = AjaxContextImpl.getCurrentInstance((FacesContext)facesContext);
            String uid = uploadActionEvent.getUploadId();
            String actionString = uploadActionEvent.getAction();
            if ("progress".equals(actionString)) {
                Map sessionMap = externalContext.getSessionMap();
                Map requestsSizeMap = (Map)sessionMap.get("_richfaces_request_size");
                if (requestsSizeMap != null) {
                    this.setupProgressBarValueExpression(facesContext, uid);
                    ajaxContext.setResponseData(requestsSizeMap.get(uid));
                }
            } else if ("richfaces_file_upload_action_stop".equals(actionString) && (multipartRequest = MultipartRequest.lookupRequest((FacesContext)facesContext, (String)uid)) != null) {
                multipartRequest.stop();
                if (multipartRequest.isStopped()) {
                    ajaxContext.setResponseData((Object)uid);
                }
            }
        }
        super.broadcast(e);
    }

    public Locale parseLocale(String localeStr) {
        int length = localeStr.length();
        if (null == localeStr || length < 2) {
            return Locale.getDefault();
        }
        int index1 = localeStr.indexOf("_");
        String language = null;
        if (index1 == -1) {
            return new Locale(localeStr);
        }
        language = localeStr.substring(0, index1);
        int index2 = localeStr.indexOf("_", index1 + 1);
        String country = null;
        if (index2 != -1) {
            country = localeStr.substring(index1 + 1, index2);
            String variant = localeStr.substring(index2 + 1);
            return new Locale(language, country, variant);
        }
        country = localeStr.substring(index1 + 1);
        return new Locale(language, country);
    }

    public Locale getAsLocale(Object locale) {
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof String) {
            return this.parseLocale((String)locale);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        Converter converter = application.createConverter(locale.getClass());
        if (null != converter) {
            return this.parseLocale(converter.getAsString(context, (UIComponent)this, locale));
        }
        throw new FacesException("Wrong locale attibute type or there is no converter for custom attibute type");
    }
}

