/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIMenuGroup;
import org.richfaces.component.UIMenuItem;
import org.richfaces.component.UIMenuSeparator;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.ScriptOptions;

public abstract class AbstractMenuRenderer
extends HeaderResourcesRendererBase {
    private final InternetResource[] scripts = new InternetResource[]{new PrototypeScript(), new AjaxScript(), this.getResource("scripts/menu.js")};

    protected InternetResource[] getScripts() {
        return this.scripts;
    }

    protected InternetResource[] getStyles() {
        return super.getStyles();
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLayerScript(context, component));
        List children = component.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            buffer.append(this.getItemScript(context, (UIComponent)it.next()));
        }
        ResponseWriter out = context.getResponseWriter();
        String script = buffer.append(";").toString();
        out.write(script);
    }

    protected abstract String getLayerScript(FacesContext var1, UIComponent var2);

    protected String getItemScript(FacesContext context, UIComponent kid) {
        String itemId = null;
        boolean closeOnClick = true;
        Integer flagGroup = null;
        boolean disabled = false;
        if (kid instanceof UIMenuItem) {
            UIMenuItem menuItem = (UIMenuItem)kid;
            itemId = kid.getClientId(context);
            disabled = menuItem.isDisabled();
            if (disabled) {
                closeOnClick = false;
            }
        } else if (kid instanceof UIMenuGroup) {
            UIMenuGroup menuGroup = (UIMenuGroup)kid;
            itemId = kid.getClientId(context);
            closeOnClick = false;
            disabled = menuGroup.isDisabled();
            flagGroup = disabled ? Integer.valueOf(2) : Integer.valueOf(1);
        }
        if (itemId != null) {
            JSFunction function = new JSFunction(".addItem", new Object[0]);
            function.addParameter((Object)itemId);
            ScriptOptions options = new ScriptOptions(kid);
            options.addEventHandler("onmouseout");
            options.addEventHandler("onmouseover");
            if (closeOnClick) {
                options.addOption("closeOnClick", (Object)Boolean.TRUE);
            }
            options.addOption("flagGroup", (Object)flagGroup);
            options.addOption("styleClass");
            options.addOption("style");
            options.addOption("itemClass");
            options.addOption("itemStyle");
            options.addOption("disabledItemClass");
            options.addOption("disabledItemStyle");
            options.addOption("selectItemClass");
            options.addOption("labelClass");
            options.addOption("selectedLabelClass");
            options.addOption("disabledLabelClass");
            options.addOption("selectClass");
            options.addOption("selectStyle");
            options.addOption("iconClass");
            if (disabled) {
                options.addOption("disabled", (Object)Boolean.TRUE);
            }
            options.addEventHandler("onselect");
            function.addParameter((Object)options);
            return function.toScript();
        }
        return "";
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        LinkedList flatListOfNodes = new LinkedList();
        String width = (String)component.getAttributes().get("popupWidth");
        this.flatten(component.getChildren(), flatListOfNodes);
        this.processLayer(context, component, width);
        for (UIMenuGroup node : flatListOfNodes) {
            if (!node.isRendered() || node.isDisabled()) continue;
            this.processLayer(context, (UIComponent)node, width);
        }
    }

    public void processLayer(FacesContext context, UIComponent layer, String width) throws IOException {
        String clientId = layer.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", layer);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        this.processLayerStyles(context, layer, writer);
        writer.startElement("div", layer);
        writer.writeAttribute("class", (Object)"rich-menu-list-bg", null);
        this.encodeItems(context, layer);
        writer.startElement("div", layer);
        writer.writeAttribute("class", (Object)"rich-menu-list-strut", null);
        writer.startElement("div", layer);
        writer.writeAttribute("class", (Object)"rich-menu-list-strut", null);
        writer.writeAttribute("style", (Object)(width != null && width.length() > 0 ? "width: " + HtmlUtil.qualifySize((String)width) : ""), null);
        writer.write("&#160;");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("script", layer);
        writer.writeAttribute("id", (Object)(clientId + "_menu_script"), null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        this.encodeScript(context, layer);
        writer.endElement("script");
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
        Set renderedAreas = ajaxContext.getAjaxRenderedAreas();
        renderedAreas.add(clientId + "_menu_script");
    }

    public void encodeItems(FacesContext context, UIComponent component) throws IOException {
        List kids = component.getChildren();
        for (UIComponent kid : kids) {
            if (!(kid instanceof UIMenuGroup) && !(kid instanceof UIMenuItem) && !(kid instanceof UIMenuSeparator)) continue;
            this.renderChild(context, kid);
        }
    }

    private void flatten(List kids, List flatList) {
        if (kids != null) {
            for (UIComponent kid : kids) {
                if (!(kid instanceof UIMenuGroup)) continue;
                UIMenuGroup node = (UIMenuGroup)kid;
                flatList.add(node);
                this.flatten(node.getChildren(), flatList);
            }
        }
    }

    protected abstract void processLayerStyles(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;
}

