/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.classification.core.resolver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.classification.api.ClassificationResolver;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;

public class LastVersionResolver
implements ClassificationResolver {
    private static final Log log = LogFactory.getLog(LastVersionResolver.class);

    public String resolve(CoreSession session, String docId) {
        try {
            DocumentModel lastDocumentVersion = session.getLastDocumentVersion((DocumentRef)new IdRef(docId));
            if (lastDocumentVersion == null) {
                log.info((Object)"Any version found, returning the docId");
                return docId;
            }
            return lastDocumentVersion.getId();
        }
        catch (ClientException e) {
            log.warn((Object)("Unable to resolve lastVersion of document" + docId));
            log.info((Object)e, (Throwable)e);
            return docId;
        }
    }
}

